<?php
/**
 * ItemShop
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * ItemShop Class Doc Comment
 *
 * @category Class
 * @description Item shop inventory information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemShop implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemShop';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_shop_id' => 'int',
        'item_id' => 'int',
        'shop_id' => 'int',
        'qoh' => 'int',
        'sellable' => 'int',
        'backorder' => 'int',
        'reorder_point' => 'int',
        'reorder_level' => 'int',
        'time_stamp' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_shop_id' => null,
        'item_id' => null,
        'shop_id' => null,
        'qoh' => null,
        'sellable' => null,
        'backorder' => null,
        'reorder_point' => null,
        'reorder_level' => null,
        'time_stamp' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_shop_id' => false,
        'item_id' => false,
        'shop_id' => false,
        'qoh' => false,
        'sellable' => false,
        'backorder' => false,
        'reorder_point' => false,
        'reorder_level' => false,
        'time_stamp' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_shop_id' => 'itemShopID',
        'item_id' => 'itemID',
        'shop_id' => 'shopID',
        'qoh' => 'qoh',
        'sellable' => 'sellable',
        'backorder' => 'backorder',
        'reorder_point' => 'reorderPoint',
        'reorder_level' => 'reorderLevel',
        'time_stamp' => 'timeStamp'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_shop_id' => 'setItemShopId',
        'item_id' => 'setItemId',
        'shop_id' => 'setShopId',
        'qoh' => 'setQoh',
        'sellable' => 'setSellable',
        'backorder' => 'setBackorder',
        'reorder_point' => 'setReorderPoint',
        'reorder_level' => 'setReorderLevel',
        'time_stamp' => 'setTimeStamp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_shop_id' => 'getItemShopId',
        'item_id' => 'getItemId',
        'shop_id' => 'getShopId',
        'qoh' => 'getQoh',
        'sellable' => 'getSellable',
        'backorder' => 'getBackorder',
        'reorder_point' => 'getReorderPoint',
        'reorder_level' => 'getReorderLevel',
        'time_stamp' => 'getTimeStamp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_shop_id', $data ?? [], null);
        $this->setIfExists('item_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('qoh', $data ?? [], null);
        $this->setIfExists('sellable', $data ?? [], null);
        $this->setIfExists('backorder', $data ?? [], null);
        $this->setIfExists('reorder_point', $data ?? [], null);
        $this->setIfExists('reorder_level', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_shop_id
     *
     * @return int|null
     */
    public function getItemShopId()
    {
        return $this->container['item_shop_id'];
    }

    /**
     * Sets item_shop_id
     *
     * @param int|null $item_shop_id Item shop identifier
     *
     * @return self
     */
    public function setItemShopId($item_shop_id)
    {
        if (is_null($item_shop_id)) {
            throw new \InvalidArgumentException('non-nullable item_shop_id cannot be null');
        }
        $this->container['item_shop_id'] = $item_shop_id;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return int|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int|null $item_id Item identifier
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id Shop identifier (0 indicates summary for all shops)
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets qoh
     *
     * @return int|null
     */
    public function getQoh()
    {
        return $this->container['qoh'];
    }

    /**
     * Sets qoh
     *
     * @param int|null $qoh Quantity on hand
     *
     * @return self
     */
    public function setQoh($qoh)
    {
        if (is_null($qoh)) {
            throw new \InvalidArgumentException('non-nullable qoh cannot be null');
        }
        $this->container['qoh'] = $qoh;

        return $this;
    }

    /**
     * Gets sellable
     *
     * @return int|null
     */
    public function getSellable()
    {
        return $this->container['sellable'];
    }

    /**
     * Sets sellable
     *
     * @param int|null $sellable Available for sale quantity
     *
     * @return self
     */
    public function setSellable($sellable)
    {
        if (is_null($sellable)) {
            throw new \InvalidArgumentException('non-nullable sellable cannot be null');
        }
        $this->container['sellable'] = $sellable;

        return $this;
    }

    /**
     * Gets backorder
     *
     * @return int|null
     */
    public function getBackorder()
    {
        return $this->container['backorder'];
    }

    /**
     * Sets backorder
     *
     * @param int|null $backorder Backorder quantity
     *
     * @return self
     */
    public function setBackorder($backorder)
    {
        if (is_null($backorder)) {
            throw new \InvalidArgumentException('non-nullable backorder cannot be null');
        }
        $this->container['backorder'] = $backorder;

        return $this;
    }

    /**
     * Gets reorder_point
     *
     * @return int|null
     */
    public function getReorderPoint()
    {
        return $this->container['reorder_point'];
    }

    /**
     * Sets reorder_point
     *
     * @param int|null $reorder_point Reorder point threshold
     *
     * @return self
     */
    public function setReorderPoint($reorder_point)
    {
        if (is_null($reorder_point)) {
            throw new \InvalidArgumentException('non-nullable reorder_point cannot be null');
        }
        $this->container['reorder_point'] = $reorder_point;

        return $this;
    }

    /**
     * Gets reorder_level
     *
     * @return int|null
     */
    public function getReorderLevel()
    {
        return $this->container['reorder_level'];
    }

    /**
     * Sets reorder_level
     *
     * @param int|null $reorder_level Desired restock quantity
     *
     * @return self
     */
    public function setReorderLevel($reorder_level)
    {
        if (is_null($reorder_level)) {
            throw new \InvalidArgumentException('non-nullable reorder_level cannot be null');
        }
        $this->container['reorder_level'] = $reorder_level;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Last modification timestamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


