<?php
/**
 * ItemCreateRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * ItemCreateRequest Class Doc Comment
 *
 * @category Class
 * @description Item creation request
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemCreateRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemCreateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'description' => 'string',
        'custom_sku' => 'string',
        'upc' => 'string',
        'ean' => 'string',
        'manufacturer_sku' => 'string',
        'default_cost' => 'float',
        'discountable' => 'bool',
        'tax' => 'bool',
        'item_type' => 'string',
        'serialized' => 'bool',
        'publish_to_ecom' => 'bool',
        'prices' => '\LightspeedV3\Model\ItemPrices'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'description' => null,
        'custom_sku' => null,
        'upc' => null,
        'ean' => null,
        'manufacturer_sku' => null,
        'default_cost' => 'float',
        'discountable' => null,
        'tax' => null,
        'item_type' => null,
        'serialized' => null,
        'publish_to_ecom' => null,
        'prices' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'description' => false,
        'custom_sku' => false,
        'upc' => false,
        'ean' => false,
        'manufacturer_sku' => false,
        'default_cost' => false,
        'discountable' => false,
        'tax' => false,
        'item_type' => false,
        'serialized' => false,
        'publish_to_ecom' => false,
        'prices' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'description' => 'description',
        'custom_sku' => 'customSku',
        'upc' => 'upc',
        'ean' => 'ean',
        'manufacturer_sku' => 'manufacturerSku',
        'default_cost' => 'defaultCost',
        'discountable' => 'discountable',
        'tax' => 'tax',
        'item_type' => 'itemType',
        'serialized' => 'serialized',
        'publish_to_ecom' => 'publishToEcom',
        'prices' => 'Prices'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'description' => 'setDescription',
        'custom_sku' => 'setCustomSku',
        'upc' => 'setUpc',
        'ean' => 'setEan',
        'manufacturer_sku' => 'setManufacturerSku',
        'default_cost' => 'setDefaultCost',
        'discountable' => 'setDiscountable',
        'tax' => 'setTax',
        'item_type' => 'setItemType',
        'serialized' => 'setSerialized',
        'publish_to_ecom' => 'setPublishToEcom',
        'prices' => 'setPrices'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'description' => 'getDescription',
        'custom_sku' => 'getCustomSku',
        'upc' => 'getUpc',
        'ean' => 'getEan',
        'manufacturer_sku' => 'getManufacturerSku',
        'default_cost' => 'getDefaultCost',
        'discountable' => 'getDiscountable',
        'tax' => 'getTax',
        'item_type' => 'getItemType',
        'serialized' => 'getSerialized',
        'publish_to_ecom' => 'getPublishToEcom',
        'prices' => 'getPrices'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ITEM_TYPE__DEFAULT = 'default';
    public const ITEM_TYPE_NON_INVENTORY = 'non_inventory';
    public const ITEM_TYPE_SERIALIZED = 'serialized';
    public const ITEM_TYPE_BOX = 'box';
    public const ITEM_TYPE_ASSEMBLY = 'assembly';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getItemTypeAllowableValues()
    {
        return [
            self::ITEM_TYPE__DEFAULT,
            self::ITEM_TYPE_NON_INVENTORY,
            self::ITEM_TYPE_SERIALIZED,
            self::ITEM_TYPE_BOX,
            self::ITEM_TYPE_ASSEMBLY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('custom_sku', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
        $this->setIfExists('ean', $data ?? [], null);
        $this->setIfExists('manufacturer_sku', $data ?? [], null);
        $this->setIfExists('default_cost', $data ?? [], null);
        $this->setIfExists('discountable', $data ?? [], true);
        $this->setIfExists('tax', $data ?? [], true);
        $this->setIfExists('item_type', $data ?? [], null);
        $this->setIfExists('serialized', $data ?? [], false);
        $this->setIfExists('publish_to_ecom', $data ?? [], false);
        $this->setIfExists('prices', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        $allowedValues = $this->getItemTypeAllowableValues();
        if (!is_null($this->container['item_type']) && !in_array($this->container['item_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'item_type', must be one of '%s'",
                $this->container['item_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description Item description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets custom_sku
     *
     * @return string|null
     */
    public function getCustomSku()
    {
        return $this->container['custom_sku'];
    }

    /**
     * Sets custom_sku
     *
     * @param string|null $custom_sku Custom SKU
     *
     * @return self
     */
    public function setCustomSku($custom_sku)
    {
        if (is_null($custom_sku)) {
            throw new \InvalidArgumentException('non-nullable custom_sku cannot be null');
        }
        $this->container['custom_sku'] = $custom_sku;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc UPC barcode
     *
     * @return self
     */
    public function setUpc($upc)
    {
        if (is_null($upc)) {
            throw new \InvalidArgumentException('non-nullable upc cannot be null');
        }
        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets ean
     *
     * @return string|null
     */
    public function getEan()
    {
        return $this->container['ean'];
    }

    /**
     * Sets ean
     *
     * @param string|null $ean EAN barcode
     *
     * @return self
     */
    public function setEan($ean)
    {
        if (is_null($ean)) {
            throw new \InvalidArgumentException('non-nullable ean cannot be null');
        }
        $this->container['ean'] = $ean;

        return $this;
    }

    /**
     * Gets manufacturer_sku
     *
     * @return string|null
     */
    public function getManufacturerSku()
    {
        return $this->container['manufacturer_sku'];
    }

    /**
     * Sets manufacturer_sku
     *
     * @param string|null $manufacturer_sku Manufacturer SKU
     *
     * @return self
     */
    public function setManufacturerSku($manufacturer_sku)
    {
        if (is_null($manufacturer_sku)) {
            throw new \InvalidArgumentException('non-nullable manufacturer_sku cannot be null');
        }
        $this->container['manufacturer_sku'] = $manufacturer_sku;

        return $this;
    }

    /**
     * Gets default_cost
     *
     * @return float|null
     */
    public function getDefaultCost()
    {
        return $this->container['default_cost'];
    }

    /**
     * Sets default_cost
     *
     * @param float|null $default_cost Default cost of item
     *
     * @return self
     */
    public function setDefaultCost($default_cost)
    {
        if (is_null($default_cost)) {
            throw new \InvalidArgumentException('non-nullable default_cost cannot be null');
        }
        $this->container['default_cost'] = $default_cost;

        return $this;
    }

    /**
     * Gets discountable
     *
     * @return bool|null
     */
    public function getDiscountable()
    {
        return $this->container['discountable'];
    }

    /**
     * Sets discountable
     *
     * @param bool|null $discountable Whether item can be discounted
     *
     * @return self
     */
    public function setDiscountable($discountable)
    {
        if (is_null($discountable)) {
            throw new \InvalidArgumentException('non-nullable discountable cannot be null');
        }
        $this->container['discountable'] = $discountable;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return bool|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param bool|null $tax Whether item is taxable
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets item_type
     *
     * @return string|null
     */
    public function getItemType()
    {
        return $this->container['item_type'];
    }

    /**
     * Sets item_type
     *
     * @param string|null $item_type Type of item
     *
     * @return self
     */
    public function setItemType($item_type)
    {
        if (is_null($item_type)) {
            throw new \InvalidArgumentException('non-nullable item_type cannot be null');
        }
        $allowedValues = $this->getItemTypeAllowableValues();
        if (!in_array($item_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'item_type', must be one of '%s'",
                    $item_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['item_type'] = $item_type;

        return $this;
    }

    /**
     * Gets serialized
     *
     * @return bool|null
     */
    public function getSerialized()
    {
        return $this->container['serialized'];
    }

    /**
     * Sets serialized
     *
     * @param bool|null $serialized Whether item is serialized
     *
     * @return self
     */
    public function setSerialized($serialized)
    {
        if (is_null($serialized)) {
            throw new \InvalidArgumentException('non-nullable serialized cannot be null');
        }
        $this->container['serialized'] = $serialized;

        return $this;
    }

    /**
     * Gets publish_to_ecom
     *
     * @return bool|null
     */
    public function getPublishToEcom()
    {
        return $this->container['publish_to_ecom'];
    }

    /**
     * Sets publish_to_ecom
     *
     * @param bool|null $publish_to_ecom Whether to publish to e-commerce
     *
     * @return self
     */
    public function setPublishToEcom($publish_to_ecom)
    {
        if (is_null($publish_to_ecom)) {
            throw new \InvalidArgumentException('non-nullable publish_to_ecom cannot be null');
        }
        $this->container['publish_to_ecom'] = $publish_to_ecom;

        return $this;
    }

    /**
     * Gets prices
     *
     * @return \LightspeedV3\Model\ItemPrices|null
     */
    public function getPrices()
    {
        return $this->container['prices'];
    }

    /**
     * Sets prices
     *
     * @param \LightspeedV3\Model\ItemPrices|null $prices prices
     *
     * @return self
     */
    public function setPrices($prices)
    {
        if (is_null($prices)) {
            throw new \InvalidArgumentException('non-nullable prices cannot be null');
        }
        $this->container['prices'] = $prices;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


