<?php
/**
 * ItemAttributeSet
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * ItemAttributeSet Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemAttributeSet implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemAttributeSet';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_attribute_set_id' => 'int',
        'name' => 'string',
        'attribute_name1' => 'string',
        'attribute_name2' => 'string',
        'attribute_name3' => 'string',
        'system' => 'bool',
        'archived' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_attribute_set_id' => null,
        'name' => null,
        'attribute_name1' => null,
        'attribute_name2' => null,
        'attribute_name3' => null,
        'system' => null,
        'archived' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_attribute_set_id' => false,
        'name' => false,
        'attribute_name1' => false,
        'attribute_name2' => false,
        'attribute_name3' => false,
        'system' => false,
        'archived' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_attribute_set_id' => 'itemAttributeSetID',
        'name' => 'name',
        'attribute_name1' => 'attributeName1',
        'attribute_name2' => 'attributeName2',
        'attribute_name3' => 'attributeName3',
        'system' => 'system',
        'archived' => 'archived'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_attribute_set_id' => 'setItemAttributeSetId',
        'name' => 'setName',
        'attribute_name1' => 'setAttributeName1',
        'attribute_name2' => 'setAttributeName2',
        'attribute_name3' => 'setAttributeName3',
        'system' => 'setSystem',
        'archived' => 'setArchived'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_attribute_set_id' => 'getItemAttributeSetId',
        'name' => 'getName',
        'attribute_name1' => 'getAttributeName1',
        'attribute_name2' => 'getAttributeName2',
        'attribute_name3' => 'getAttributeName3',
        'system' => 'getSystem',
        'archived' => 'getArchived'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_attribute_set_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('attribute_name1', $data ?? [], null);
        $this->setIfExists('attribute_name2', $data ?? [], null);
        $this->setIfExists('attribute_name3', $data ?? [], null);
        $this->setIfExists('system', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_attribute_set_id
     *
     * @return int|null
     */
    public function getItemAttributeSetId()
    {
        return $this->container['item_attribute_set_id'];
    }

    /**
     * Sets item_attribute_set_id
     *
     * @param int|null $item_attribute_set_id item_attribute_set_id
     *
     * @return self
     */
    public function setItemAttributeSetId($item_attribute_set_id)
    {
        if (is_null($item_attribute_set_id)) {
            throw new \InvalidArgumentException('non-nullable item_attribute_set_id cannot be null');
        }
        $this->container['item_attribute_set_id'] = $item_attribute_set_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets attribute_name1
     *
     * @return string|null
     */
    public function getAttributeName1()
    {
        return $this->container['attribute_name1'];
    }

    /**
     * Sets attribute_name1
     *
     * @param string|null $attribute_name1 attribute_name1
     *
     * @return self
     */
    public function setAttributeName1($attribute_name1)
    {
        if (is_null($attribute_name1)) {
            throw new \InvalidArgumentException('non-nullable attribute_name1 cannot be null');
        }
        $this->container['attribute_name1'] = $attribute_name1;

        return $this;
    }

    /**
     * Gets attribute_name2
     *
     * @return string|null
     */
    public function getAttributeName2()
    {
        return $this->container['attribute_name2'];
    }

    /**
     * Sets attribute_name2
     *
     * @param string|null $attribute_name2 attribute_name2
     *
     * @return self
     */
    public function setAttributeName2($attribute_name2)
    {
        if (is_null($attribute_name2)) {
            throw new \InvalidArgumentException('non-nullable attribute_name2 cannot be null');
        }
        $this->container['attribute_name2'] = $attribute_name2;

        return $this;
    }

    /**
     * Gets attribute_name3
     *
     * @return string|null
     */
    public function getAttributeName3()
    {
        return $this->container['attribute_name3'];
    }

    /**
     * Sets attribute_name3
     *
     * @param string|null $attribute_name3 attribute_name3
     *
     * @return self
     */
    public function setAttributeName3($attribute_name3)
    {
        if (is_null($attribute_name3)) {
            throw new \InvalidArgumentException('non-nullable attribute_name3 cannot be null');
        }
        $this->container['attribute_name3'] = $attribute_name3;

        return $this;
    }

    /**
     * Gets system
     *
     * @return bool|null
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     *
     * @param bool|null $system system
     *
     * @return self
     */
    public function setSystem($system)
    {
        if (is_null($system)) {
            throw new \InvalidArgumentException('non-nullable system cannot be null');
        }
        $this->container['system'] = $system;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


