<?php
/**
 * Item
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Item Class Doc Comment
 *
 * @category Class
 * @description Item information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Item implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Item';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_id' => 'int',
        'system_sku' => 'string',
        'default_cost' => 'float',
        'avg_cost' => 'float',
        'discountable' => 'bool',
        'tax' => 'bool',
        'archived' => 'bool',
        'item_type' => 'string',
        'serialized' => 'bool',
        'description' => 'string',
        'upc' => 'string',
        'ean' => 'string',
        'custom_sku' => 'string',
        'manufacturer_sku' => 'string',
        'create_time' => '\DateTime',
        'time_stamp' => '\DateTime',
        'publish_to_ecom' => 'bool',
        'prices' => '\LightspeedV3\Model\ItemPrices',
        'item_shops' => '\LightspeedV3\Model\ItemItemShops',
        'category' => '\LightspeedV3\Model\Category',
        'tax_class' => '\LightspeedV3\Model\TaxClass',
        'custom_field_values' => '\LightspeedV3\Model\ItemCustomFieldValues',
        'category_id' => 'int',
        'tax_class_id' => 'int',
        'department_id' => 'int',
        'item_matrix_id' => 'int',
        'manufacturer_id' => 'int',
        'season_id' => 'int',
        'default_vendor_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_id' => null,
        'system_sku' => null,
        'default_cost' => 'float',
        'avg_cost' => 'float',
        'discountable' => null,
        'tax' => null,
        'archived' => null,
        'item_type' => null,
        'serialized' => null,
        'description' => null,
        'upc' => null,
        'ean' => null,
        'custom_sku' => null,
        'manufacturer_sku' => null,
        'create_time' => 'date-time',
        'time_stamp' => 'date-time',
        'publish_to_ecom' => null,
        'prices' => null,
        'item_shops' => null,
        'category' => null,
        'tax_class' => null,
        'custom_field_values' => null,
        'category_id' => null,
        'tax_class_id' => null,
        'department_id' => null,
        'item_matrix_id' => null,
        'manufacturer_id' => null,
        'season_id' => null,
        'default_vendor_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_id' => false,
        'system_sku' => false,
        'default_cost' => false,
        'avg_cost' => false,
        'discountable' => false,
        'tax' => false,
        'archived' => false,
        'item_type' => false,
        'serialized' => false,
        'description' => false,
        'upc' => false,
        'ean' => false,
        'custom_sku' => false,
        'manufacturer_sku' => false,
        'create_time' => false,
        'time_stamp' => false,
        'publish_to_ecom' => false,
        'prices' => false,
        'item_shops' => false,
        'category' => false,
        'tax_class' => false,
        'custom_field_values' => false,
        'category_id' => false,
        'tax_class_id' => false,
        'department_id' => false,
        'item_matrix_id' => false,
        'manufacturer_id' => false,
        'season_id' => false,
        'default_vendor_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_id' => 'itemID',
        'system_sku' => 'systemSku',
        'default_cost' => 'defaultCost',
        'avg_cost' => 'avgCost',
        'discountable' => 'discountable',
        'tax' => 'tax',
        'archived' => 'archived',
        'item_type' => 'itemType',
        'serialized' => 'serialized',
        'description' => 'description',
        'upc' => 'upc',
        'ean' => 'ean',
        'custom_sku' => 'customSku',
        'manufacturer_sku' => 'manufacturerSku',
        'create_time' => 'createTime',
        'time_stamp' => 'timeStamp',
        'publish_to_ecom' => 'publishToEcom',
        'prices' => 'Prices',
        'item_shops' => 'ItemShops',
        'category' => 'Category',
        'tax_class' => 'TaxClass',
        'custom_field_values' => 'CustomFieldValues',
        'category_id' => 'categoryID',
        'tax_class_id' => 'taxClassID',
        'department_id' => 'departmentID',
        'item_matrix_id' => 'itemMatrixID',
        'manufacturer_id' => 'manufacturerID',
        'season_id' => 'seasonID',
        'default_vendor_id' => 'defaultVendorID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_id' => 'setItemId',
        'system_sku' => 'setSystemSku',
        'default_cost' => 'setDefaultCost',
        'avg_cost' => 'setAvgCost',
        'discountable' => 'setDiscountable',
        'tax' => 'setTax',
        'archived' => 'setArchived',
        'item_type' => 'setItemType',
        'serialized' => 'setSerialized',
        'description' => 'setDescription',
        'upc' => 'setUpc',
        'ean' => 'setEan',
        'custom_sku' => 'setCustomSku',
        'manufacturer_sku' => 'setManufacturerSku',
        'create_time' => 'setCreateTime',
        'time_stamp' => 'setTimeStamp',
        'publish_to_ecom' => 'setPublishToEcom',
        'prices' => 'setPrices',
        'item_shops' => 'setItemShops',
        'category' => 'setCategory',
        'tax_class' => 'setTaxClass',
        'custom_field_values' => 'setCustomFieldValues',
        'category_id' => 'setCategoryId',
        'tax_class_id' => 'setTaxClassId',
        'department_id' => 'setDepartmentId',
        'item_matrix_id' => 'setItemMatrixId',
        'manufacturer_id' => 'setManufacturerId',
        'season_id' => 'setSeasonId',
        'default_vendor_id' => 'setDefaultVendorId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_id' => 'getItemId',
        'system_sku' => 'getSystemSku',
        'default_cost' => 'getDefaultCost',
        'avg_cost' => 'getAvgCost',
        'discountable' => 'getDiscountable',
        'tax' => 'getTax',
        'archived' => 'getArchived',
        'item_type' => 'getItemType',
        'serialized' => 'getSerialized',
        'description' => 'getDescription',
        'upc' => 'getUpc',
        'ean' => 'getEan',
        'custom_sku' => 'getCustomSku',
        'manufacturer_sku' => 'getManufacturerSku',
        'create_time' => 'getCreateTime',
        'time_stamp' => 'getTimeStamp',
        'publish_to_ecom' => 'getPublishToEcom',
        'prices' => 'getPrices',
        'item_shops' => 'getItemShops',
        'category' => 'getCategory',
        'tax_class' => 'getTaxClass',
        'custom_field_values' => 'getCustomFieldValues',
        'category_id' => 'getCategoryId',
        'tax_class_id' => 'getTaxClassId',
        'department_id' => 'getDepartmentId',
        'item_matrix_id' => 'getItemMatrixId',
        'manufacturer_id' => 'getManufacturerId',
        'season_id' => 'getSeasonId',
        'default_vendor_id' => 'getDefaultVendorId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ITEM_TYPE__DEFAULT = 'default';
    public const ITEM_TYPE_NON_INVENTORY = 'non_inventory';
    public const ITEM_TYPE_SERIALIZED = 'serialized';
    public const ITEM_TYPE_BOX = 'box';
    public const ITEM_TYPE_ASSEMBLY = 'assembly';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getItemTypeAllowableValues()
    {
        return [
            self::ITEM_TYPE__DEFAULT,
            self::ITEM_TYPE_NON_INVENTORY,
            self::ITEM_TYPE_SERIALIZED,
            self::ITEM_TYPE_BOX,
            self::ITEM_TYPE_ASSEMBLY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_id', $data ?? [], null);
        $this->setIfExists('system_sku', $data ?? [], null);
        $this->setIfExists('default_cost', $data ?? [], null);
        $this->setIfExists('avg_cost', $data ?? [], null);
        $this->setIfExists('discountable', $data ?? [], true);
        $this->setIfExists('tax', $data ?? [], true);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('item_type', $data ?? [], null);
        $this->setIfExists('serialized', $data ?? [], false);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
        $this->setIfExists('ean', $data ?? [], null);
        $this->setIfExists('custom_sku', $data ?? [], null);
        $this->setIfExists('manufacturer_sku', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('publish_to_ecom', $data ?? [], false);
        $this->setIfExists('prices', $data ?? [], null);
        $this->setIfExists('item_shops', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('tax_class', $data ?? [], null);
        $this->setIfExists('custom_field_values', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('tax_class_id', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('item_matrix_id', $data ?? [], null);
        $this->setIfExists('manufacturer_id', $data ?? [], null);
        $this->setIfExists('season_id', $data ?? [], null);
        $this->setIfExists('default_vendor_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['item_id'] === null) {
            $invalidProperties[] = "'item_id' can't be null";
        }
        $allowedValues = $this->getItemTypeAllowableValues();
        if (!is_null($this->container['item_type']) && !in_array($this->container['item_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'item_type', must be one of '%s'",
                $this->container['item_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_id
     *
     * @return int
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int $item_id Unique item identifier
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets system_sku
     *
     * @return string|null
     */
    public function getSystemSku()
    {
        return $this->container['system_sku'];
    }

    /**
     * Sets system_sku
     *
     * @param string|null $system_sku System-generated SKU
     *
     * @return self
     */
    public function setSystemSku($system_sku)
    {
        if (is_null($system_sku)) {
            throw new \InvalidArgumentException('non-nullable system_sku cannot be null');
        }
        $this->container['system_sku'] = $system_sku;

        return $this;
    }

    /**
     * Gets default_cost
     *
     * @return float|null
     */
    public function getDefaultCost()
    {
        return $this->container['default_cost'];
    }

    /**
     * Sets default_cost
     *
     * @param float|null $default_cost Default cost of item
     *
     * @return self
     */
    public function setDefaultCost($default_cost)
    {
        if (is_null($default_cost)) {
            throw new \InvalidArgumentException('non-nullable default_cost cannot be null');
        }
        $this->container['default_cost'] = $default_cost;

        return $this;
    }

    /**
     * Gets avg_cost
     *
     * @return float|null
     */
    public function getAvgCost()
    {
        return $this->container['avg_cost'];
    }

    /**
     * Sets avg_cost
     *
     * @param float|null $avg_cost Average cost of item
     *
     * @return self
     */
    public function setAvgCost($avg_cost)
    {
        if (is_null($avg_cost)) {
            throw new \InvalidArgumentException('non-nullable avg_cost cannot be null');
        }
        $this->container['avg_cost'] = $avg_cost;

        return $this;
    }

    /**
     * Gets discountable
     *
     * @return bool|null
     */
    public function getDiscountable()
    {
        return $this->container['discountable'];
    }

    /**
     * Sets discountable
     *
     * @param bool|null $discountable Whether item can be discounted
     *
     * @return self
     */
    public function setDiscountable($discountable)
    {
        if (is_null($discountable)) {
            throw new \InvalidArgumentException('non-nullable discountable cannot be null');
        }
        $this->container['discountable'] = $discountable;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return bool|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param bool|null $tax Whether item is taxable
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Whether item is archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets item_type
     *
     * @return string|null
     */
    public function getItemType()
    {
        return $this->container['item_type'];
    }

    /**
     * Sets item_type
     *
     * @param string|null $item_type Type of item
     *
     * @return self
     */
    public function setItemType($item_type)
    {
        if (is_null($item_type)) {
            throw new \InvalidArgumentException('non-nullable item_type cannot be null');
        }
        $allowedValues = $this->getItemTypeAllowableValues();
        if (!in_array($item_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'item_type', must be one of '%s'",
                    $item_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['item_type'] = $item_type;

        return $this;
    }

    /**
     * Gets serialized
     *
     * @return bool|null
     */
    public function getSerialized()
    {
        return $this->container['serialized'];
    }

    /**
     * Sets serialized
     *
     * @param bool|null $serialized Whether item is serialized
     *
     * @return self
     */
    public function setSerialized($serialized)
    {
        if (is_null($serialized)) {
            throw new \InvalidArgumentException('non-nullable serialized cannot be null');
        }
        $this->container['serialized'] = $serialized;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description Item description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc UPC barcode
     *
     * @return self
     */
    public function setUpc($upc)
    {
        if (is_null($upc)) {
            throw new \InvalidArgumentException('non-nullable upc cannot be null');
        }
        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets ean
     *
     * @return string|null
     */
    public function getEan()
    {
        return $this->container['ean'];
    }

    /**
     * Sets ean
     *
     * @param string|null $ean EAN barcode
     *
     * @return self
     */
    public function setEan($ean)
    {
        if (is_null($ean)) {
            throw new \InvalidArgumentException('non-nullable ean cannot be null');
        }
        $this->container['ean'] = $ean;

        return $this;
    }

    /**
     * Gets custom_sku
     *
     * @return string|null
     */
    public function getCustomSku()
    {
        return $this->container['custom_sku'];
    }

    /**
     * Sets custom_sku
     *
     * @param string|null $custom_sku Custom SKU
     *
     * @return self
     */
    public function setCustomSku($custom_sku)
    {
        if (is_null($custom_sku)) {
            throw new \InvalidArgumentException('non-nullable custom_sku cannot be null');
        }
        $this->container['custom_sku'] = $custom_sku;

        return $this;
    }

    /**
     * Gets manufacturer_sku
     *
     * @return string|null
     */
    public function getManufacturerSku()
    {
        return $this->container['manufacturer_sku'];
    }

    /**
     * Sets manufacturer_sku
     *
     * @param string|null $manufacturer_sku Manufacturer SKU
     *
     * @return self
     */
    public function setManufacturerSku($manufacturer_sku)
    {
        if (is_null($manufacturer_sku)) {
            throw new \InvalidArgumentException('non-nullable manufacturer_sku cannot be null');
        }
        $this->container['manufacturer_sku'] = $manufacturer_sku;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return \DateTime|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param \DateTime|null $create_time Record creation timestamp
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Last modification timestamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets publish_to_ecom
     *
     * @return bool|null
     */
    public function getPublishToEcom()
    {
        return $this->container['publish_to_ecom'];
    }

    /**
     * Sets publish_to_ecom
     *
     * @param bool|null $publish_to_ecom Whether to publish to e-commerce
     *
     * @return self
     */
    public function setPublishToEcom($publish_to_ecom)
    {
        if (is_null($publish_to_ecom)) {
            throw new \InvalidArgumentException('non-nullable publish_to_ecom cannot be null');
        }
        $this->container['publish_to_ecom'] = $publish_to_ecom;

        return $this;
    }

    /**
     * Gets prices
     *
     * @return \LightspeedV3\Model\ItemPrices|null
     */
    public function getPrices()
    {
        return $this->container['prices'];
    }

    /**
     * Sets prices
     *
     * @param \LightspeedV3\Model\ItemPrices|null $prices prices
     *
     * @return self
     */
    public function setPrices($prices)
    {
        if (is_null($prices)) {
            throw new \InvalidArgumentException('non-nullable prices cannot be null');
        }
        $this->container['prices'] = $prices;

        return $this;
    }

    /**
     * Gets item_shops
     *
     * @return \LightspeedV3\Model\ItemItemShops|null
     */
    public function getItemShops()
    {
        return $this->container['item_shops'];
    }

    /**
     * Sets item_shops
     *
     * @param \LightspeedV3\Model\ItemItemShops|null $item_shops item_shops
     *
     * @return self
     */
    public function setItemShops($item_shops)
    {
        if (is_null($item_shops)) {
            throw new \InvalidArgumentException('non-nullable item_shops cannot be null');
        }
        $this->container['item_shops'] = $item_shops;

        return $this;
    }

    /**
     * Gets category
     *
     * @return \LightspeedV3\Model\Category|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param \LightspeedV3\Model\Category|null $category category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets tax_class
     *
     * @return \LightspeedV3\Model\TaxClass|null
     */
    public function getTaxClass()
    {
        return $this->container['tax_class'];
    }

    /**
     * Sets tax_class
     *
     * @param \LightspeedV3\Model\TaxClass|null $tax_class tax_class
     *
     * @return self
     */
    public function setTaxClass($tax_class)
    {
        if (is_null($tax_class)) {
            throw new \InvalidArgumentException('non-nullable tax_class cannot be null');
        }
        $this->container['tax_class'] = $tax_class;

        return $this;
    }

    /**
     * Gets custom_field_values
     *
     * @return \LightspeedV3\Model\ItemCustomFieldValues|null
     */
    public function getCustomFieldValues()
    {
        return $this->container['custom_field_values'];
    }

    /**
     * Sets custom_field_values
     *
     * @param \LightspeedV3\Model\ItemCustomFieldValues|null $custom_field_values custom_field_values
     *
     * @return self
     */
    public function setCustomFieldValues($custom_field_values)
    {
        if (is_null($custom_field_values)) {
            throw new \InvalidArgumentException('non-nullable custom_field_values cannot be null');
        }
        $this->container['custom_field_values'] = $custom_field_values;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id category_id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets tax_class_id
     *
     * @return int|null
     */
    public function getTaxClassId()
    {
        return $this->container['tax_class_id'];
    }

    /**
     * Sets tax_class_id
     *
     * @param int|null $tax_class_id tax_class_id
     *
     * @return self
     */
    public function setTaxClassId($tax_class_id)
    {
        if (is_null($tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable tax_class_id cannot be null');
        }
        $this->container['tax_class_id'] = $tax_class_id;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id department_id
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets item_matrix_id
     *
     * @return int|null
     */
    public function getItemMatrixId()
    {
        return $this->container['item_matrix_id'];
    }

    /**
     * Sets item_matrix_id
     *
     * @param int|null $item_matrix_id item_matrix_id
     *
     * @return self
     */
    public function setItemMatrixId($item_matrix_id)
    {
        if (is_null($item_matrix_id)) {
            throw new \InvalidArgumentException('non-nullable item_matrix_id cannot be null');
        }
        $this->container['item_matrix_id'] = $item_matrix_id;

        return $this;
    }

    /**
     * Gets manufacturer_id
     *
     * @return int|null
     */
    public function getManufacturerId()
    {
        return $this->container['manufacturer_id'];
    }

    /**
     * Sets manufacturer_id
     *
     * @param int|null $manufacturer_id manufacturer_id
     *
     * @return self
     */
    public function setManufacturerId($manufacturer_id)
    {
        if (is_null($manufacturer_id)) {
            throw new \InvalidArgumentException('non-nullable manufacturer_id cannot be null');
        }
        $this->container['manufacturer_id'] = $manufacturer_id;

        return $this;
    }

    /**
     * Gets season_id
     *
     * @return int|null
     */
    public function getSeasonId()
    {
        return $this->container['season_id'];
    }

    /**
     * Sets season_id
     *
     * @param int|null $season_id season_id
     *
     * @return self
     */
    public function setSeasonId($season_id)
    {
        if (is_null($season_id)) {
            throw new \InvalidArgumentException('non-nullable season_id cannot be null');
        }
        $this->container['season_id'] = $season_id;

        return $this;
    }

    /**
     * Gets default_vendor_id
     *
     * @return int|null
     */
    public function getDefaultVendorId()
    {
        return $this->container['default_vendor_id'];
    }

    /**
     * Sets default_vendor_id
     *
     * @param int|null $default_vendor_id default_vendor_id
     *
     * @return self
     */
    public function setDefaultVendorId($default_vendor_id)
    {
        if (is_null($default_vendor_id)) {
            throw new \InvalidArgumentException('non-nullable default_vendor_id cannot be null');
        }
        $this->container['default_vendor_id'] = $default_vendor_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


