<?php
/**
 * InventoryCountReconcile
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * InventoryCountReconcile Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InventoryCountReconcile implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InventoryCountReconcile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'inventory_count_reconcile_id' => 'string',
        'cost_change' => 'string',
        'qoh_change' => 'string',
        'create_time' => 'string',
        'inventory_count_id' => 'string',
        'item_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'inventory_count_reconcile_id' => null,
        'cost_change' => null,
        'qoh_change' => null,
        'create_time' => null,
        'inventory_count_id' => null,
        'item_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'inventory_count_reconcile_id' => false,
        'cost_change' => false,
        'qoh_change' => false,
        'create_time' => false,
        'inventory_count_id' => false,
        'item_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'inventory_count_reconcile_id' => 'inventoryCountReconcileID',
        'cost_change' => 'costChange',
        'qoh_change' => 'qohChange',
        'create_time' => 'createTime',
        'inventory_count_id' => 'inventoryCountID',
        'item_id' => 'itemID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'inventory_count_reconcile_id' => 'setInventoryCountReconcileId',
        'cost_change' => 'setCostChange',
        'qoh_change' => 'setQohChange',
        'create_time' => 'setCreateTime',
        'inventory_count_id' => 'setInventoryCountId',
        'item_id' => 'setItemId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'inventory_count_reconcile_id' => 'getInventoryCountReconcileId',
        'cost_change' => 'getCostChange',
        'qoh_change' => 'getQohChange',
        'create_time' => 'getCreateTime',
        'inventory_count_id' => 'getInventoryCountId',
        'item_id' => 'getItemId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('inventory_count_reconcile_id', $data ?? [], null);
        $this->setIfExists('cost_change', $data ?? [], null);
        $this->setIfExists('qoh_change', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('inventory_count_id', $data ?? [], null);
        $this->setIfExists('item_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets inventory_count_reconcile_id
     *
     * @return string|null
     */
    public function getInventoryCountReconcileId()
    {
        return $this->container['inventory_count_reconcile_id'];
    }

    /**
     * Sets inventory_count_reconcile_id
     *
     * @param string|null $inventory_count_reconcile_id inventory_count_reconcile_id
     *
     * @return self
     */
    public function setInventoryCountReconcileId($inventory_count_reconcile_id)
    {
        if (is_null($inventory_count_reconcile_id)) {
            throw new \InvalidArgumentException('non-nullable inventory_count_reconcile_id cannot be null');
        }
        $this->container['inventory_count_reconcile_id'] = $inventory_count_reconcile_id;

        return $this;
    }

    /**
     * Gets cost_change
     *
     * @return string|null
     */
    public function getCostChange()
    {
        return $this->container['cost_change'];
    }

    /**
     * Sets cost_change
     *
     * @param string|null $cost_change cost_change
     *
     * @return self
     */
    public function setCostChange($cost_change)
    {
        if (is_null($cost_change)) {
            throw new \InvalidArgumentException('non-nullable cost_change cannot be null');
        }
        $this->container['cost_change'] = $cost_change;

        return $this;
    }

    /**
     * Gets qoh_change
     *
     * @return string|null
     */
    public function getQohChange()
    {
        return $this->container['qoh_change'];
    }

    /**
     * Sets qoh_change
     *
     * @param string|null $qoh_change qoh_change
     *
     * @return self
     */
    public function setQohChange($qoh_change)
    {
        if (is_null($qoh_change)) {
            throw new \InvalidArgumentException('non-nullable qoh_change cannot be null');
        }
        $this->container['qoh_change'] = $qoh_change;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return string|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param string|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets inventory_count_id
     *
     * @return string|null
     */
    public function getInventoryCountId()
    {
        return $this->container['inventory_count_id'];
    }

    /**
     * Sets inventory_count_id
     *
     * @param string|null $inventory_count_id inventory_count_id
     *
     * @return self
     */
    public function setInventoryCountId($inventory_count_id)
    {
        if (is_null($inventory_count_id)) {
            throw new \InvalidArgumentException('non-nullable inventory_count_id cannot be null');
        }
        $this->container['inventory_count_id'] = $inventory_count_id;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return string|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param string|null $item_id item_id
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


