<?php
/**
 * Customer
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Customer Class Doc Comment
 *
 * @category Class
 * @description Customer information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Customer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'customer_id' => 'int',
        'first_name' => 'string',
        'last_name' => 'string',
        'dob' => '\DateTime',
        'archived' => 'bool',
        'title' => 'string',
        'company' => 'string',
        'company_registration_number' => 'string',
        'vat_number' => 'string',
        'create_time' => '\DateTime',
        'time_stamp' => '\DateTime',
        'credit_account_id' => 'int',
        'customer_type_id' => 'int',
        'discount_id' => 'int',
        'tax_category_id' => 'int',
        'contact' => '\LightspeedV3\Model\Contact'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'customer_id' => null,
        'first_name' => null,
        'last_name' => null,
        'dob' => 'date-time',
        'archived' => null,
        'title' => null,
        'company' => null,
        'company_registration_number' => null,
        'vat_number' => null,
        'create_time' => 'date-time',
        'time_stamp' => 'date-time',
        'credit_account_id' => null,
        'customer_type_id' => null,
        'discount_id' => null,
        'tax_category_id' => null,
        'contact' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'customer_id' => false,
        'first_name' => false,
        'last_name' => false,
        'dob' => false,
        'archived' => false,
        'title' => false,
        'company' => false,
        'company_registration_number' => false,
        'vat_number' => false,
        'create_time' => false,
        'time_stamp' => false,
        'credit_account_id' => false,
        'customer_type_id' => false,
        'discount_id' => false,
        'tax_category_id' => false,
        'contact' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customer_id' => 'customerID',
        'first_name' => 'firstName',
        'last_name' => 'lastName',
        'dob' => 'dob',
        'archived' => 'archived',
        'title' => 'title',
        'company' => 'company',
        'company_registration_number' => 'companyRegistrationNumber',
        'vat_number' => 'vatNumber',
        'create_time' => 'createTime',
        'time_stamp' => 'timeStamp',
        'credit_account_id' => 'creditAccountID',
        'customer_type_id' => 'customerTypeID',
        'discount_id' => 'discountID',
        'tax_category_id' => 'taxCategoryID',
        'contact' => 'Contact'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'customer_id' => 'setCustomerId',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'dob' => 'setDob',
        'archived' => 'setArchived',
        'title' => 'setTitle',
        'company' => 'setCompany',
        'company_registration_number' => 'setCompanyRegistrationNumber',
        'vat_number' => 'setVatNumber',
        'create_time' => 'setCreateTime',
        'time_stamp' => 'setTimeStamp',
        'credit_account_id' => 'setCreditAccountId',
        'customer_type_id' => 'setCustomerTypeId',
        'discount_id' => 'setDiscountId',
        'tax_category_id' => 'setTaxCategoryId',
        'contact' => 'setContact'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'customer_id' => 'getCustomerId',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'dob' => 'getDob',
        'archived' => 'getArchived',
        'title' => 'getTitle',
        'company' => 'getCompany',
        'company_registration_number' => 'getCompanyRegistrationNumber',
        'vat_number' => 'getVatNumber',
        'create_time' => 'getCreateTime',
        'time_stamp' => 'getTimeStamp',
        'credit_account_id' => 'getCreditAccountId',
        'customer_type_id' => 'getCustomerTypeId',
        'discount_id' => 'getDiscountId',
        'tax_category_id' => 'getTaxCategoryId',
        'contact' => 'getContact'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('dob', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('company_registration_number', $data ?? [], null);
        $this->setIfExists('vat_number', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('credit_account_id', $data ?? [], null);
        $this->setIfExists('customer_type_id', $data ?? [], null);
        $this->setIfExists('discount_id', $data ?? [], null);
        $this->setIfExists('tax_category_id', $data ?? [], null);
        $this->setIfExists('contact', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['customer_id'] === null) {
            $invalidProperties[] = "'customer_id' can't be null";
        }
        if ($this->container['first_name'] === null) {
            $invalidProperties[] = "'first_name' can't be null";
        }
        if ($this->container['last_name'] === null) {
            $invalidProperties[] = "'last_name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets customer_id
     *
     * @return int
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int $customer_id Unique customer identifier
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string $first_name Customer first name
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string $last_name Customer last name
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets dob
     *
     * @return \DateTime|null
     */
    public function getDob()
    {
        return $this->container['dob'];
    }

    /**
     * Sets dob
     *
     * @param \DateTime|null $dob Date of birth
     *
     * @return self
     */
    public function setDob($dob)
    {
        if (is_null($dob)) {
            throw new \InvalidArgumentException('non-nullable dob cannot be null');
        }
        $this->container['dob'] = $dob;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Whether customer is archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title Job title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company Company name
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets company_registration_number
     *
     * @return string|null
     */
    public function getCompanyRegistrationNumber()
    {
        return $this->container['company_registration_number'];
    }

    /**
     * Sets company_registration_number
     *
     * @param string|null $company_registration_number Company registration number
     *
     * @return self
     */
    public function setCompanyRegistrationNumber($company_registration_number)
    {
        if (is_null($company_registration_number)) {
            throw new \InvalidArgumentException('non-nullable company_registration_number cannot be null');
        }
        $this->container['company_registration_number'] = $company_registration_number;

        return $this;
    }

    /**
     * Gets vat_number
     *
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->container['vat_number'];
    }

    /**
     * Sets vat_number
     *
     * @param string|null $vat_number VAT number
     *
     * @return self
     */
    public function setVatNumber($vat_number)
    {
        if (is_null($vat_number)) {
            throw new \InvalidArgumentException('non-nullable vat_number cannot be null');
        }
        $this->container['vat_number'] = $vat_number;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return \DateTime|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param \DateTime|null $create_time Record creation timestamp
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Last modification timestamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets credit_account_id
     *
     * @return int|null
     */
    public function getCreditAccountId()
    {
        return $this->container['credit_account_id'];
    }

    /**
     * Sets credit_account_id
     *
     * @param int|null $credit_account_id Associated credit account ID
     *
     * @return self
     */
    public function setCreditAccountId($credit_account_id)
    {
        if (is_null($credit_account_id)) {
            throw new \InvalidArgumentException('non-nullable credit_account_id cannot be null');
        }
        $this->container['credit_account_id'] = $credit_account_id;

        return $this;
    }

    /**
     * Gets customer_type_id
     *
     * @return int|null
     */
    public function getCustomerTypeId()
    {
        return $this->container['customer_type_id'];
    }

    /**
     * Sets customer_type_id
     *
     * @param int|null $customer_type_id Customer type identifier
     *
     * @return self
     */
    public function setCustomerTypeId($customer_type_id)
    {
        if (is_null($customer_type_id)) {
            throw new \InvalidArgumentException('non-nullable customer_type_id cannot be null');
        }
        $this->container['customer_type_id'] = $customer_type_id;

        return $this;
    }

    /**
     * Gets discount_id
     *
     * @return int|null
     */
    public function getDiscountId()
    {
        return $this->container['discount_id'];
    }

    /**
     * Sets discount_id
     *
     * @param int|null $discount_id Associated discount ID
     *
     * @return self
     */
    public function setDiscountId($discount_id)
    {
        if (is_null($discount_id)) {
            throw new \InvalidArgumentException('non-nullable discount_id cannot be null');
        }
        $this->container['discount_id'] = $discount_id;

        return $this;
    }

    /**
     * Gets tax_category_id
     *
     * @return int|null
     */
    public function getTaxCategoryId()
    {
        return $this->container['tax_category_id'];
    }

    /**
     * Sets tax_category_id
     *
     * @param int|null $tax_category_id Tax category identifier
     *
     * @return self
     */
    public function setTaxCategoryId($tax_category_id)
    {
        if (is_null($tax_category_id)) {
            throw new \InvalidArgumentException('non-nullable tax_category_id cannot be null');
        }
        $this->container['tax_category_id'] = $tax_category_id;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \LightspeedV3\Model\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \LightspeedV3\Model\Contact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        if (is_null($contact)) {
            throw new \InvalidArgumentException('non-nullable contact cannot be null');
        }
        $this->container['contact'] = $contact;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


