<?php
/**
 * Account
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Account Class Doc Comment
 *
 * @category Class
 * @description Account information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Account implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Account';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'at_attributes' => '\LightspeedV3\Model\AccountAttributes',
        'status' => 'string',
        'name' => 'string',
        'employee_count' => 'int',
        'employee_limit' => 'int',
        'unique_subscription_identifier' => 'string',
        'default_currency' => '\LightspeedV3\Model\Currency',
        'purchasing_currencies' => '\LightspeedV3\Model\AccountPurchasingCurrencies'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'at_attributes' => null,
        'status' => null,
        'name' => null,
        'employee_count' => null,
        'employee_limit' => null,
        'unique_subscription_identifier' => null,
        'default_currency' => null,
        'purchasing_currencies' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'at_attributes' => false,
        'status' => false,
        'name' => false,
        'employee_count' => false,
        'employee_limit' => false,
        'unique_subscription_identifier' => false,
        'default_currency' => false,
        'purchasing_currencies' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'at_attributes' => '@attributes',
        'status' => 'status',
        'name' => 'name',
        'employee_count' => 'employeeCount',
        'employee_limit' => 'employeeLimit',
        'unique_subscription_identifier' => 'uniqueSubscriptionIdentifier',
        'default_currency' => 'defaultCurrency',
        'purchasing_currencies' => 'purchasingCurrencies'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'at_attributes' => 'setAtAttributes',
        'status' => 'setStatus',
        'name' => 'setName',
        'employee_count' => 'setEmployeeCount',
        'employee_limit' => 'setEmployeeLimit',
        'unique_subscription_identifier' => 'setUniqueSubscriptionIdentifier',
        'default_currency' => 'setDefaultCurrency',
        'purchasing_currencies' => 'setPurchasingCurrencies'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'at_attributes' => 'getAtAttributes',
        'status' => 'getStatus',
        'name' => 'getName',
        'employee_count' => 'getEmployeeCount',
        'employee_limit' => 'getEmployeeLimit',
        'unique_subscription_identifier' => 'getUniqueSubscriptionIdentifier',
        'default_currency' => 'getDefaultCurrency',
        'purchasing_currencies' => 'getPurchasingCurrencies'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('at_attributes', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('employee_count', $data ?? [], null);
        $this->setIfExists('employee_limit', $data ?? [], null);
        $this->setIfExists('unique_subscription_identifier', $data ?? [], null);
        $this->setIfExists('default_currency', $data ?? [], null);
        $this->setIfExists('purchasing_currencies', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['default_currency'] === null) {
            $invalidProperties[] = "'default_currency' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets at_attributes
     *
     * @return \LightspeedV3\Model\AccountAttributes|null
     */
    public function getAtAttributes()
    {
        return $this->container['at_attributes'];
    }

    /**
     * Sets at_attributes
     *
     * @param \LightspeedV3\Model\AccountAttributes|null $at_attributes at_attributes
     *
     * @return self
     */
    public function setAtAttributes($at_attributes)
    {
        if (is_null($at_attributes)) {
            throw new \InvalidArgumentException('non-nullable at_attributes cannot be null');
        }
        $this->container['at_attributes'] = $at_attributes;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Account status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Account name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets employee_count
     *
     * @return int|null
     */
    public function getEmployeeCount()
    {
        return $this->container['employee_count'];
    }

    /**
     * Sets employee_count
     *
     * @param int|null $employee_count Current number of employees
     *
     * @return self
     */
    public function setEmployeeCount($employee_count)
    {
        if (is_null($employee_count)) {
            throw new \InvalidArgumentException('non-nullable employee_count cannot be null');
        }
        $this->container['employee_count'] = $employee_count;

        return $this;
    }

    /**
     * Gets employee_limit
     *
     * @return int|null
     */
    public function getEmployeeLimit()
    {
        return $this->container['employee_limit'];
    }

    /**
     * Sets employee_limit
     *
     * @param int|null $employee_limit Maximum number of employees allowed
     *
     * @return self
     */
    public function setEmployeeLimit($employee_limit)
    {
        if (is_null($employee_limit)) {
            throw new \InvalidArgumentException('non-nullable employee_limit cannot be null');
        }
        $this->container['employee_limit'] = $employee_limit;

        return $this;
    }

    /**
     * Gets unique_subscription_identifier
     *
     * @return string|null
     */
    public function getUniqueSubscriptionIdentifier()
    {
        return $this->container['unique_subscription_identifier'];
    }

    /**
     * Sets unique_subscription_identifier
     *
     * @param string|null $unique_subscription_identifier Unique subscription identifier for support
     *
     * @return self
     */
    public function setUniqueSubscriptionIdentifier($unique_subscription_identifier)
    {
        if (is_null($unique_subscription_identifier)) {
            throw new \InvalidArgumentException('non-nullable unique_subscription_identifier cannot be null');
        }
        $this->container['unique_subscription_identifier'] = $unique_subscription_identifier;

        return $this;
    }

    /**
     * Gets default_currency
     *
     * @return \LightspeedV3\Model\Currency
     */
    public function getDefaultCurrency()
    {
        return $this->container['default_currency'];
    }

    /**
     * Sets default_currency
     *
     * @param \LightspeedV3\Model\Currency $default_currency default_currency
     *
     * @return self
     */
    public function setDefaultCurrency($default_currency)
    {
        if (is_null($default_currency)) {
            throw new \InvalidArgumentException('non-nullable default_currency cannot be null');
        }
        $this->container['default_currency'] = $default_currency;

        return $this;
    }

    /**
     * Gets purchasing_currencies
     *
     * @return \LightspeedV3\Model\AccountPurchasingCurrencies|null
     */
    public function getPurchasingCurrencies()
    {
        return $this->container['purchasing_currencies'];
    }

    /**
     * Sets purchasing_currencies
     *
     * @param \LightspeedV3\Model\AccountPurchasingCurrencies|null $purchasing_currencies purchasing_currencies
     *
     * @return self
     */
    public function setPurchasingCurrencies($purchasing_currencies)
    {
        if (is_null($purchasing_currencies)) {
            throw new \InvalidArgumentException('non-nullable purchasing_currencies cannot be null');
        }
        $this->container['purchasing_currencies'] = $purchasing_currencies;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


