<?php
/**
 * WorkorderWorkorderWorkorderLineApi
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use LightspeedV3\ApiException;
use LightspeedV3\Configuration;
use LightspeedV3\FormDataProcessor;
use LightspeedV3\HeaderSelector;
use LightspeedV3\ObjectSerializer;

/**
 * WorkorderWorkorderWorkorderLineApi Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WorkorderWorkorderWorkorderLineApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'workorderWorkorderIDWorkorderLineGet' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderLinePost' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderLineWorkorderLineIDDelete' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderLineWorkorderLineIDGet' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderLineWorkorderLineIDPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineGet
     *
     * Get Workorder.WorkorderLine list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\WorkorderListResponse
     */
    public function workorderWorkorderIDWorkorderLineGet($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineGet'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderLineGetWithHttpInfo($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineGetWithHttpInfo
     *
     * Get Workorder.WorkorderLine list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\WorkorderListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderLineGetWithHttpInfo($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineGet'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderLineGetRequest($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\WorkorderListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineGetAsync
     *
     * Get Workorder.WorkorderLine list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineGetAsync($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineGet'][0])
    {
        return $this->workorderWorkorderIDWorkorderLineGetAsyncWithHttpInfo($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineGetAsyncWithHttpInfo
     *
     * Get Workorder.WorkorderLine list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineGetAsyncWithHttpInfo($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineGet'][0])
    {
        $returnType = '\LightspeedV3\Model\WorkorderListResponse';
        $request = $this->workorderWorkorderIDWorkorderLineGetRequest($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderLineGet'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderLineGetRequest($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineGet'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderLineGet'
            );
        }




        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling WorkorderWorkorderWorkorderLineApi.workorderWorkorderIDWorkorderLineGet, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 0) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling WorkorderWorkorderWorkorderLineApi.workorderWorkorderIDWorkorderLineGet, must be bigger than or equal to 0.');
        }
        






        $resourcePath = '/Workorder/{workorderID}/WorkorderLine';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $count,
            'count', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $time_stamp,
            'timeStamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLinePost
     *
     * Create Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderCreateRequest $workorder_create_request workorder_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLinePost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object|\LightspeedV3\Model\CategoryPost400Response
     */
    public function workorderWorkorderIDWorkorderLinePost($workorder_id, $workorder_create_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLinePost'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderLinePostWithHttpInfo($workorder_id, $workorder_create_request, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderLinePostWithHttpInfo
     *
     * Create Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderCreateRequest $workorder_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLinePost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object|\LightspeedV3\Model\CategoryPost400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderLinePostWithHttpInfo($workorder_id, $workorder_create_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLinePost'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderLinePostRequest($workorder_id, $workorder_create_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderLinePostAsync
     *
     * Create Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderCreateRequest $workorder_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLinePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLinePostAsync($workorder_id, $workorder_create_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLinePost'][0])
    {
        return $this->workorderWorkorderIDWorkorderLinePostAsyncWithHttpInfo($workorder_id, $workorder_create_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLinePostAsyncWithHttpInfo
     *
     * Create Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderCreateRequest $workorder_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLinePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLinePostAsyncWithHttpInfo($workorder_id, $workorder_create_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLinePost'][0])
    {
        $returnType = 'object';
        $request = $this->workorderWorkorderIDWorkorderLinePostRequest($workorder_id, $workorder_create_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderLinePost'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderCreateRequest $workorder_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLinePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderLinePostRequest($workorder_id, $workorder_create_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLinePost'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderLinePost'
            );
        }

        // verify the required parameter 'workorder_create_request' is set
        if ($workorder_create_request === null || (is_array($workorder_create_request) && count($workorder_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_create_request when calling workorderWorkorderIDWorkorderLinePost'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderLine';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($workorder_create_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($workorder_create_request));
            } else {
                $httpBody = $workorder_create_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDDelete
     *
     * Delete Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDDelete($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'][0])
    {
        $this->workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteWithHttpInfo($workorder_id, $workorder_line_id, $contentType);
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteWithHttpInfo
     *
     * Delete Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteWithHttpInfo($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteRequest($workorder_id, $workorder_line_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteAsync
     *
     * Delete Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteAsync($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'][0])
    {
        return $this->workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteAsyncWithHttpInfo($workorder_id, $workorder_line_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteAsyncWithHttpInfo
     *
     * Delete Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteAsyncWithHttpInfo($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'][0])
    {
        $returnType = '';
        $request = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteRequest($workorder_id, $workorder_line_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDDeleteRequest($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'
            );
        }

        // verify the required parameter 'workorder_line_id' is set
        if ($workorder_line_id === null || (is_array($workorder_line_id) && count($workorder_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_line_id when calling workorderWorkorderIDWorkorderLineWorkorderLineIDDelete'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderLine/{workorderLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }
        // path params
        if ($workorder_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderLineID' . '}',
                ObjectSerializer::toPathValue($workorder_line_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDGet
     *
     * Get Workorder.WorkorderLine by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\WorkorderListResponse
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDGet($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDGetWithHttpInfo($workorder_id, $workorder_line_id, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDGetWithHttpInfo
     *
     * Get Workorder.WorkorderLine by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\WorkorderListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDGetWithHttpInfo($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDGetRequest($workorder_id, $workorder_line_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\WorkorderListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDGetAsync
     *
     * Get Workorder.WorkorderLine by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDGetAsync($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'][0])
    {
        return $this->workorderWorkorderIDWorkorderLineWorkorderLineIDGetAsyncWithHttpInfo($workorder_id, $workorder_line_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDGetAsyncWithHttpInfo
     *
     * Get Workorder.WorkorderLine by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDGetAsyncWithHttpInfo($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'][0])
    {
        $returnType = '\LightspeedV3\Model\WorkorderListResponse';
        $request = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDGetRequest($workorder_id, $workorder_line_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderLineWorkorderLineIDGet'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDGetRequest($workorder_id, $workorder_line_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDGet'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderLineWorkorderLineIDGet'
            );
        }

        // verify the required parameter 'workorder_line_id' is set
        if ($workorder_line_id === null || (is_array($workorder_line_id) && count($workorder_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_line_id when calling workorderWorkorderIDWorkorderLineWorkorderLineIDGet'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderLine/{workorderLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }
        // path params
        if ($workorder_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderLineID' . '}',
                ObjectSerializer::toPathValue($workorder_line_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDPut
     *
     * Update Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderUpdateRequest $workorder_update_request workorder_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\WorkorderResponse
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDPut($workorder_id, $workorder_line_id, $workorder_update_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDPutWithHttpInfo($workorder_id, $workorder_line_id, $workorder_update_request, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDPutWithHttpInfo
     *
     * Update Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderUpdateRequest $workorder_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\WorkorderResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDPutWithHttpInfo($workorder_id, $workorder_line_id, $workorder_update_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDPutRequest($workorder_id, $workorder_line_id, $workorder_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\WorkorderResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\WorkorderResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\WorkorderResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDPutAsync
     *
     * Update Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderUpdateRequest $workorder_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDPutAsync($workorder_id, $workorder_line_id, $workorder_update_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'][0])
    {
        return $this->workorderWorkorderIDWorkorderLineWorkorderLineIDPutAsyncWithHttpInfo($workorder_id, $workorder_line_id, $workorder_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderLineWorkorderLineIDPutAsyncWithHttpInfo
     *
     * Update Workorder.WorkorderLine
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderUpdateRequest $workorder_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDPutAsyncWithHttpInfo($workorder_id, $workorder_line_id, $workorder_update_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'][0])
    {
        $returnType = '\LightspeedV3\Model\WorkorderResponse';
        $request = $this->workorderWorkorderIDWorkorderLineWorkorderLineIDPutRequest($workorder_id, $workorder_line_id, $workorder_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderLineWorkorderLineIDPut'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_line_id The workorderLineID identifier (required)
     * @param  \LightspeedV3\Model\WorkorderUpdateRequest $workorder_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderLineWorkorderLineIDPutRequest($workorder_id, $workorder_line_id, $workorder_update_request, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderLineWorkorderLineIDPut'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderLineWorkorderLineIDPut'
            );
        }

        // verify the required parameter 'workorder_line_id' is set
        if ($workorder_line_id === null || (is_array($workorder_line_id) && count($workorder_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_line_id when calling workorderWorkorderIDWorkorderLineWorkorderLineIDPut'
            );
        }

        // verify the required parameter 'workorder_update_request' is set
        if ($workorder_update_request === null || (is_array($workorder_update_request) && count($workorder_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_update_request when calling workorderWorkorderIDWorkorderLineWorkorderLineIDPut'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderLine/{workorderLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }
        // path params
        if ($workorder_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderLineID' . '}',
                ObjectSerializer::toPathValue($workorder_line_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($workorder_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($workorder_update_request));
            } else {
                $httpBody = $workorder_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
