<?php
/**
 * WorkorderWorkorderWorkorderImageApi
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use LightspeedV3\ApiException;
use LightspeedV3\Configuration;
use LightspeedV3\FormDataProcessor;
use LightspeedV3\HeaderSelector;
use LightspeedV3\ObjectSerializer;

/**
 * WorkorderWorkorderWorkorderImageApi Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WorkorderWorkorderWorkorderImageApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'workorderWorkorderIDWorkorderImageGet' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderImagePost' => [
            'multipart/form-data',
        ],
        'workorderWorkorderIDWorkorderImageWorkorderImageIDDelete' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderImageWorkorderImageIDGet' => [
            'application/json',
        ],
        'workorderWorkorderIDWorkorderImageWorkorderImageIDPut' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageGet
     *
     * Get Workorder.WorkorderImage list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\WorkorderListResponse
     */
    public function workorderWorkorderIDWorkorderImageGet($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageGet'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderImageGetWithHttpInfo($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageGetWithHttpInfo
     *
     * Get Workorder.WorkorderImage list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\WorkorderListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderImageGetWithHttpInfo($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageGet'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderImageGetRequest($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\WorkorderListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageGetAsync
     *
     * Get Workorder.WorkorderImage list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageGetAsync($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageGet'][0])
    {
        return $this->workorderWorkorderIDWorkorderImageGetAsyncWithHttpInfo($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageGetAsyncWithHttpInfo
     *
     * Get Workorder.WorkorderImage list
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageGetAsyncWithHttpInfo($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageGet'][0])
    {
        $returnType = '\LightspeedV3\Model\WorkorderListResponse';
        $request = $this->workorderWorkorderIDWorkorderImageGetRequest($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderImageGet'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderImageGetRequest($workorder_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageGet'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderImageGet'
            );
        }




        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling WorkorderWorkorderWorkorderImageApi.workorderWorkorderIDWorkorderImageGet, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 0) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling WorkorderWorkorderWorkorderImageApi.workorderWorkorderIDWorkorderImageGet, must be bigger than or equal to 0.');
        }
        






        $resourcePath = '/Workorder/{workorderID}/WorkorderImage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $count,
            'count', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $time_stamp,
            'timeStamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImagePost
     *
     * Create Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImagePost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object|\LightspeedV3\Model\CategoryPost400Response
     */
    public function workorderWorkorderIDWorkorderImagePost($workorder_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImagePost'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderImagePostWithHttpInfo($workorder_id, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderImagePostWithHttpInfo
     *
     * Create Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImagePost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object|\LightspeedV3\Model\CategoryPost400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderImagePostWithHttpInfo($workorder_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImagePost'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderImagePostRequest($workorder_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderImagePostAsync
     *
     * Create Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImagePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImagePostAsync($workorder_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImagePost'][0])
    {
        return $this->workorderWorkorderIDWorkorderImagePostAsyncWithHttpInfo($workorder_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImagePostAsyncWithHttpInfo
     *
     * Create Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImagePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImagePostAsyncWithHttpInfo($workorder_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImagePost'][0])
    {
        $returnType = 'object';
        $request = $this->workorderWorkorderIDWorkorderImagePostRequest($workorder_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderImagePost'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImagePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderImagePostRequest($workorder_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImagePost'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderImagePost'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderImage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }


        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDDelete
     *
     * Delete Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDDelete($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'][0])
    {
        $this->workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteWithHttpInfo($workorder_id, $workorder_image_id, $contentType);
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteWithHttpInfo
     *
     * Delete Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteWithHttpInfo($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteRequest($workorder_id, $workorder_image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteAsync
     *
     * Delete Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteAsync($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'][0])
    {
        return $this->workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteAsyncWithHttpInfo($workorder_id, $workorder_image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteAsyncWithHttpInfo
     *
     * Delete Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteAsyncWithHttpInfo($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'][0])
    {
        $returnType = '';
        $request = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteRequest($workorder_id, $workorder_image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDDeleteRequest($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'
            );
        }

        // verify the required parameter 'workorder_image_id' is set
        if ($workorder_image_id === null || (is_array($workorder_image_id) && count($workorder_image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_image_id when calling workorderWorkorderIDWorkorderImageWorkorderImageIDDelete'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderImage/{workorderImageID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }
        // path params
        if ($workorder_image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderImageID' . '}',
                ObjectSerializer::toPathValue($workorder_image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDGet
     *
     * Get Workorder.WorkorderImage by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\WorkorderListResponse
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDGet($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDGetWithHttpInfo($workorder_id, $workorder_image_id, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDGetWithHttpInfo
     *
     * Get Workorder.WorkorderImage by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\WorkorderListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDGetWithHttpInfo($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDGetRequest($workorder_id, $workorder_image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\WorkorderListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\WorkorderListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDGetAsync
     *
     * Get Workorder.WorkorderImage by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDGetAsync($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'][0])
    {
        return $this->workorderWorkorderIDWorkorderImageWorkorderImageIDGetAsyncWithHttpInfo($workorder_id, $workorder_image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDGetAsyncWithHttpInfo
     *
     * Get Workorder.WorkorderImage by ID
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDGetAsyncWithHttpInfo($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'][0])
    {
        $returnType = '\LightspeedV3\Model\WorkorderListResponse';
        $request = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDGetRequest($workorder_id, $workorder_image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderImageWorkorderImageIDGet'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDGetRequest($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDGet'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderImageWorkorderImageIDGet'
            );
        }

        // verify the required parameter 'workorder_image_id' is set
        if ($workorder_image_id === null || (is_array($workorder_image_id) && count($workorder_image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_image_id when calling workorderWorkorderIDWorkorderImageWorkorderImageIDGet'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderImage/{workorderImageID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }
        // path params
        if ($workorder_image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderImageID' . '}',
                ObjectSerializer::toPathValue($workorder_image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDPut
     *
     * Update Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\WorkorderResponse
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDPut($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'][0])
    {
        list($response) = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDPutWithHttpInfo($workorder_id, $workorder_image_id, $contentType);
        return $response;
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDPutWithHttpInfo
     *
     * Update Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\WorkorderResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDPutWithHttpInfo($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'][0])
    {
        $request = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDPutRequest($workorder_id, $workorder_image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\WorkorderResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\WorkorderResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\WorkorderResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDPutAsync
     *
     * Update Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDPutAsync($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'][0])
    {
        return $this->workorderWorkorderIDWorkorderImageWorkorderImageIDPutAsyncWithHttpInfo($workorder_id, $workorder_image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation workorderWorkorderIDWorkorderImageWorkorderImageIDPutAsyncWithHttpInfo
     *
     * Update Workorder.WorkorderImage
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDPutAsyncWithHttpInfo($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'][0])
    {
        $returnType = '\LightspeedV3\Model\WorkorderResponse';
        $request = $this->workorderWorkorderIDWorkorderImageWorkorderImageIDPutRequest($workorder_id, $workorder_image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'workorderWorkorderIDWorkorderImageWorkorderImageIDPut'
     *
     * @param  int $workorder_id The workorderID identifier (required)
     * @param  int $workorder_image_id The workorderImageID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function workorderWorkorderIDWorkorderImageWorkorderImageIDPutRequest($workorder_id, $workorder_image_id, string $contentType = self::contentTypes['workorderWorkorderIDWorkorderImageWorkorderImageIDPut'][0])
    {

        // verify the required parameter 'workorder_id' is set
        if ($workorder_id === null || (is_array($workorder_id) && count($workorder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_id when calling workorderWorkorderIDWorkorderImageWorkorderImageIDPut'
            );
        }

        // verify the required parameter 'workorder_image_id' is set
        if ($workorder_image_id === null || (is_array($workorder_image_id) && count($workorder_image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workorder_image_id when calling workorderWorkorderIDWorkorderImageWorkorderImageIDPut'
            );
        }


        $resourcePath = '/Workorder/{workorderID}/WorkorderImage/{workorderImageID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workorder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderID' . '}',
                ObjectSerializer::toPathValue($workorder_id),
                $resourcePath
            );
        }
        // path params
        if ($workorder_image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workorderImageID' . '}',
                ObjectSerializer::toPathValue($workorder_image_id),
                $resourcePath
            );
        }


        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
