<?php
/**
 * ReportsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use LightspeedV3\ApiException;
use LightspeedV3\Configuration;
use LightspeedV3\FormDataProcessor;
use LightspeedV3\HeaderSelector;
use LightspeedV3\ObjectSerializer;

/**
 * ReportsApi Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ReportsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'reportsAccountingDiscountsByDayGet' => [
            'application/json',
        ],
        'reportsAccountingOrdersByTaxClassGet' => [
            'application/json',
        ],
        'reportsAccountingPaymentsByDayGet' => [
            'application/json',
        ],
        'reportsAccountingTaxClassSalesByDayGet' => [
            'application/json',
        ],
        'reportsAccountingTaxesByDayGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation reportsAccountingDiscountsByDayGet
     *
     * Reports.Accounting.DiscountsByDay
     *
     * @param  string|null $start_date start_date (optional)
     * @param  string|null $end_date end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingDiscountsByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\GenericResponse
     */
    public function reportsAccountingDiscountsByDayGet($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingDiscountsByDayGet'][0])
    {
        list($response) = $this->reportsAccountingDiscountsByDayGetWithHttpInfo($start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation reportsAccountingDiscountsByDayGetWithHttpInfo
     *
     * Reports.Accounting.DiscountsByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingDiscountsByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\GenericResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function reportsAccountingDiscountsByDayGetWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingDiscountsByDayGet'][0])
    {
        $request = $this->reportsAccountingDiscountsByDayGetRequest($start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\GenericResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\GenericResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\GenericResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation reportsAccountingDiscountsByDayGetAsync
     *
     * Reports.Accounting.DiscountsByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingDiscountsByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingDiscountsByDayGetAsync($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingDiscountsByDayGet'][0])
    {
        return $this->reportsAccountingDiscountsByDayGetAsyncWithHttpInfo($start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation reportsAccountingDiscountsByDayGetAsyncWithHttpInfo
     *
     * Reports.Accounting.DiscountsByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingDiscountsByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingDiscountsByDayGetAsyncWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingDiscountsByDayGet'][0])
    {
        $returnType = '\LightspeedV3\Model\GenericResponse';
        $request = $this->reportsAccountingDiscountsByDayGetRequest($start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'reportsAccountingDiscountsByDayGet'
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingDiscountsByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function reportsAccountingDiscountsByDayGetRequest($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingDiscountsByDayGet'][0])
    {




        $resourcePath = '/Reports/Accounting/DiscountsByDay';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation reportsAccountingOrdersByTaxClassGet
     *
     * Reports.Accounting.OrdersByTaxClass
     *
     * @param  string|null $start_date start_date (optional)
     * @param  string|null $end_date end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingOrdersByTaxClassGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\GenericResponse
     */
    public function reportsAccountingOrdersByTaxClassGet($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingOrdersByTaxClassGet'][0])
    {
        list($response) = $this->reportsAccountingOrdersByTaxClassGetWithHttpInfo($start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation reportsAccountingOrdersByTaxClassGetWithHttpInfo
     *
     * Reports.Accounting.OrdersByTaxClass
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingOrdersByTaxClassGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\GenericResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function reportsAccountingOrdersByTaxClassGetWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingOrdersByTaxClassGet'][0])
    {
        $request = $this->reportsAccountingOrdersByTaxClassGetRequest($start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\GenericResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\GenericResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\GenericResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation reportsAccountingOrdersByTaxClassGetAsync
     *
     * Reports.Accounting.OrdersByTaxClass
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingOrdersByTaxClassGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingOrdersByTaxClassGetAsync($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingOrdersByTaxClassGet'][0])
    {
        return $this->reportsAccountingOrdersByTaxClassGetAsyncWithHttpInfo($start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation reportsAccountingOrdersByTaxClassGetAsyncWithHttpInfo
     *
     * Reports.Accounting.OrdersByTaxClass
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingOrdersByTaxClassGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingOrdersByTaxClassGetAsyncWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingOrdersByTaxClassGet'][0])
    {
        $returnType = '\LightspeedV3\Model\GenericResponse';
        $request = $this->reportsAccountingOrdersByTaxClassGetRequest($start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'reportsAccountingOrdersByTaxClassGet'
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingOrdersByTaxClassGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function reportsAccountingOrdersByTaxClassGetRequest($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingOrdersByTaxClassGet'][0])
    {




        $resourcePath = '/Reports/Accounting/OrdersByTaxClass';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation reportsAccountingPaymentsByDayGet
     *
     * Reports.Accounting.PaymentsByDay
     *
     * @param  string|null $start_date start_date (optional)
     * @param  string|null $end_date end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingPaymentsByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\GenericResponse
     */
    public function reportsAccountingPaymentsByDayGet($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingPaymentsByDayGet'][0])
    {
        list($response) = $this->reportsAccountingPaymentsByDayGetWithHttpInfo($start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation reportsAccountingPaymentsByDayGetWithHttpInfo
     *
     * Reports.Accounting.PaymentsByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingPaymentsByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\GenericResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function reportsAccountingPaymentsByDayGetWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingPaymentsByDayGet'][0])
    {
        $request = $this->reportsAccountingPaymentsByDayGetRequest($start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\GenericResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\GenericResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\GenericResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation reportsAccountingPaymentsByDayGetAsync
     *
     * Reports.Accounting.PaymentsByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingPaymentsByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingPaymentsByDayGetAsync($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingPaymentsByDayGet'][0])
    {
        return $this->reportsAccountingPaymentsByDayGetAsyncWithHttpInfo($start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation reportsAccountingPaymentsByDayGetAsyncWithHttpInfo
     *
     * Reports.Accounting.PaymentsByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingPaymentsByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingPaymentsByDayGetAsyncWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingPaymentsByDayGet'][0])
    {
        $returnType = '\LightspeedV3\Model\GenericResponse';
        $request = $this->reportsAccountingPaymentsByDayGetRequest($start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'reportsAccountingPaymentsByDayGet'
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingPaymentsByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function reportsAccountingPaymentsByDayGetRequest($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingPaymentsByDayGet'][0])
    {




        $resourcePath = '/Reports/Accounting/PaymentsByDay';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation reportsAccountingTaxClassSalesByDayGet
     *
     * Reports.Accounting.TaxClassSalesByDay
     *
     * @param  string|null $start_date start_date (optional)
     * @param  string|null $end_date end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxClassSalesByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\GenericResponse
     */
    public function reportsAccountingTaxClassSalesByDayGet($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxClassSalesByDayGet'][0])
    {
        list($response) = $this->reportsAccountingTaxClassSalesByDayGetWithHttpInfo($start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation reportsAccountingTaxClassSalesByDayGetWithHttpInfo
     *
     * Reports.Accounting.TaxClassSalesByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxClassSalesByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\GenericResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function reportsAccountingTaxClassSalesByDayGetWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxClassSalesByDayGet'][0])
    {
        $request = $this->reportsAccountingTaxClassSalesByDayGetRequest($start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\GenericResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\GenericResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\GenericResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation reportsAccountingTaxClassSalesByDayGetAsync
     *
     * Reports.Accounting.TaxClassSalesByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxClassSalesByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingTaxClassSalesByDayGetAsync($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxClassSalesByDayGet'][0])
    {
        return $this->reportsAccountingTaxClassSalesByDayGetAsyncWithHttpInfo($start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation reportsAccountingTaxClassSalesByDayGetAsyncWithHttpInfo
     *
     * Reports.Accounting.TaxClassSalesByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxClassSalesByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingTaxClassSalesByDayGetAsyncWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxClassSalesByDayGet'][0])
    {
        $returnType = '\LightspeedV3\Model\GenericResponse';
        $request = $this->reportsAccountingTaxClassSalesByDayGetRequest($start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'reportsAccountingTaxClassSalesByDayGet'
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxClassSalesByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function reportsAccountingTaxClassSalesByDayGetRequest($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxClassSalesByDayGet'][0])
    {




        $resourcePath = '/Reports/Accounting/TaxClassSalesByDay';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation reportsAccountingTaxesByDayGet
     *
     * Reports.Accounting.TaxesByDay
     *
     * @param  string|null $start_date start_date (optional)
     * @param  string|null $end_date end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxesByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\GenericResponse
     */
    public function reportsAccountingTaxesByDayGet($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxesByDayGet'][0])
    {
        list($response) = $this->reportsAccountingTaxesByDayGetWithHttpInfo($start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation reportsAccountingTaxesByDayGetWithHttpInfo
     *
     * Reports.Accounting.TaxesByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxesByDayGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\GenericResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function reportsAccountingTaxesByDayGetWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxesByDayGet'][0])
    {
        $request = $this->reportsAccountingTaxesByDayGetRequest($start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\GenericResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\GenericResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\GenericResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation reportsAccountingTaxesByDayGetAsync
     *
     * Reports.Accounting.TaxesByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxesByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingTaxesByDayGetAsync($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxesByDayGet'][0])
    {
        return $this->reportsAccountingTaxesByDayGetAsyncWithHttpInfo($start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation reportsAccountingTaxesByDayGetAsyncWithHttpInfo
     *
     * Reports.Accounting.TaxesByDay
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxesByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function reportsAccountingTaxesByDayGetAsyncWithHttpInfo($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxesByDayGet'][0])
    {
        $returnType = '\LightspeedV3\Model\GenericResponse';
        $request = $this->reportsAccountingTaxesByDayGetRequest($start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'reportsAccountingTaxesByDayGet'
     *
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['reportsAccountingTaxesByDayGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function reportsAccountingTaxesByDayGetRequest($start_date = null, $end_date = null, string $contentType = self::contentTypes['reportsAccountingTaxesByDayGet'][0])
    {




        $resourcePath = '/Reports/Accounting/TaxesByDay';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
