<?php
/**
 * OrderOrderCustomFieldCustomFieldChoiceApi
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use LightspeedV3\ApiException;
use LightspeedV3\Configuration;
use LightspeedV3\FormDataProcessor;
use LightspeedV3\HeaderSelector;
use LightspeedV3\ObjectSerializer;

/**
 * OrderOrderCustomFieldCustomFieldChoiceApi Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderOrderCustomFieldCustomFieldChoiceApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete' => [
            'application/json',
        ],
        'orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet' => [
            'application/json',
        ],
        'orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut' => [
            'application/json',
        ],
        'orderCustomFieldCustomFieldIDCustomFieldChoiceGet' => [
            'application/json',
        ],
        'orderCustomFieldCustomFieldIDCustomFieldChoicePost' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete
     *
     * Delete Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'][0])
    {
        $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteWithHttpInfo($custom_field_id, $custom_field_choice_id, $contentType);
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteWithHttpInfo
     *
     * Delete Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteWithHttpInfo($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'][0])
    {
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteRequest($custom_field_id, $custom_field_choice_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteAsync
     *
     * Delete Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteAsync($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'][0])
    {
        return $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteAsyncWithHttpInfo($custom_field_id, $custom_field_choice_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteAsyncWithHttpInfo
     *
     * Delete Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteAsyncWithHttpInfo($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'][0])
    {
        $returnType = '';
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteRequest($custom_field_id, $custom_field_choice_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDeleteRequest($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'][0])
    {

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'
            );
        }

        // verify the required parameter 'custom_field_choice_id' is set
        if ($custom_field_choice_id === null || (is_array($custom_field_choice_id) && count($custom_field_choice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_choice_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete'
            );
        }


        $resourcePath = '/Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldID' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_choice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldChoiceID' . '}',
                ObjectSerializer::toPathValue($custom_field_choice_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet
     *
     * Get Order.CustomField.CustomFieldChoice by ID
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\OrderListResponse
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'][0])
    {
        list($response) = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetWithHttpInfo($custom_field_id, $custom_field_choice_id, $contentType);
        return $response;
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetWithHttpInfo
     *
     * Get Order.CustomField.CustomFieldChoice by ID
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\OrderListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetWithHttpInfo($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'][0])
    {
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetRequest($custom_field_id, $custom_field_choice_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\OrderListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\OrderListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\OrderListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetAsync
     *
     * Get Order.CustomField.CustomFieldChoice by ID
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetAsync($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'][0])
    {
        return $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetAsyncWithHttpInfo($custom_field_id, $custom_field_choice_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetAsyncWithHttpInfo
     *
     * Get Order.CustomField.CustomFieldChoice by ID
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetAsyncWithHttpInfo($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'][0])
    {
        $returnType = '\LightspeedV3\Model\OrderListResponse';
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetRequest($custom_field_id, $custom_field_choice_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGetRequest($custom_field_id, $custom_field_choice_id, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'][0])
    {

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'
            );
        }

        // verify the required parameter 'custom_field_choice_id' is set
        if ($custom_field_choice_id === null || (is_array($custom_field_choice_id) && count($custom_field_choice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_choice_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet'
            );
        }


        $resourcePath = '/Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldID' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_choice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldChoiceID' . '}',
                ObjectSerializer::toPathValue($custom_field_choice_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut
     *
     * Update Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  \LightspeedV3\Model\OrderUpdateRequest $order_update_request order_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\OrderResponse
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut($custom_field_id, $custom_field_choice_id, $order_update_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'][0])
    {
        list($response) = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutWithHttpInfo($custom_field_id, $custom_field_choice_id, $order_update_request, $contentType);
        return $response;
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutWithHttpInfo
     *
     * Update Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  \LightspeedV3\Model\OrderUpdateRequest $order_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\OrderResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutWithHttpInfo($custom_field_id, $custom_field_choice_id, $order_update_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'][0])
    {
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutRequest($custom_field_id, $custom_field_choice_id, $order_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\OrderResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\OrderResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\OrderResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutAsync
     *
     * Update Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  \LightspeedV3\Model\OrderUpdateRequest $order_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutAsync($custom_field_id, $custom_field_choice_id, $order_update_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'][0])
    {
        return $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutAsyncWithHttpInfo($custom_field_id, $custom_field_choice_id, $order_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutAsyncWithHttpInfo
     *
     * Update Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  \LightspeedV3\Model\OrderUpdateRequest $order_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutAsyncWithHttpInfo($custom_field_id, $custom_field_choice_id, $order_update_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'][0])
    {
        $returnType = '\LightspeedV3\Model\OrderResponse';
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutRequest($custom_field_id, $custom_field_choice_id, $order_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  int $custom_field_choice_id The customFieldChoiceID identifier (required)
     * @param  \LightspeedV3\Model\OrderUpdateRequest $order_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPutRequest($custom_field_id, $custom_field_choice_id, $order_update_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'][0])
    {

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'
            );
        }

        // verify the required parameter 'custom_field_choice_id' is set
        if ($custom_field_choice_id === null || (is_array($custom_field_choice_id) && count($custom_field_choice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_choice_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'
            );
        }

        // verify the required parameter 'order_update_request' is set
        if ($order_update_request === null || (is_array($order_update_request) && count($order_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_update_request when calling orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut'
            );
        }


        $resourcePath = '/Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldID' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_choice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldChoiceID' . '}',
                ObjectSerializer::toPathValue($custom_field_choice_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_update_request));
            } else {
                $httpBody = $order_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceGet
     *
     * Get Order.CustomField.CustomFieldChoice list
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\OrderListResponse
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceGet($custom_field_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'][0])
    {
        list($response) = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceGetWithHttpInfo($custom_field_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);
        return $response;
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceGetWithHttpInfo
     *
     * Get Order.CustomField.CustomFieldChoice list
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\OrderListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceGetWithHttpInfo($custom_field_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'][0])
    {
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceGetRequest($custom_field_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\OrderListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\OrderListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\OrderListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceGetAsync
     *
     * Get Order.CustomField.CustomFieldChoice list
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceGetAsync($custom_field_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'][0])
    {
        return $this->orderCustomFieldCustomFieldIDCustomFieldChoiceGetAsyncWithHttpInfo($custom_field_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoiceGetAsyncWithHttpInfo
     *
     * Get Order.CustomField.CustomFieldChoice list
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceGetAsyncWithHttpInfo($custom_field_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'][0])
    {
        $returnType = '\LightspeedV3\Model\OrderListResponse';
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoiceGetRequest($custom_field_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCustomFieldCustomFieldIDCustomFieldChoiceGet'
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoiceGetRequest($custom_field_id, $after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoiceGet'][0])
    {

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling orderCustomFieldCustomFieldIDCustomFieldChoiceGet'
            );
        }




        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling OrderOrderCustomFieldCustomFieldChoiceApi.orderCustomFieldCustomFieldIDCustomFieldChoiceGet, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 0) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling OrderOrderCustomFieldCustomFieldChoiceApi.orderCustomFieldCustomFieldIDCustomFieldChoiceGet, must be bigger than or equal to 0.');
        }
        






        $resourcePath = '/Order/CustomField/{customFieldID}/CustomFieldChoice';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $count,
            'count', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $time_stamp,
            'timeStamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldID' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoicePost
     *
     * Create Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  \LightspeedV3\Model\OrderCreateRequest $order_create_request order_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object|\LightspeedV3\Model\CategoryPost400Response
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoicePost($custom_field_id, $order_create_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'][0])
    {
        list($response) = $this->orderCustomFieldCustomFieldIDCustomFieldChoicePostWithHttpInfo($custom_field_id, $order_create_request, $contentType);
        return $response;
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoicePostWithHttpInfo
     *
     * Create Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  \LightspeedV3\Model\OrderCreateRequest $order_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object|\LightspeedV3\Model\CategoryPost400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoicePostWithHttpInfo($custom_field_id, $order_create_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'][0])
    {
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoicePostRequest($custom_field_id, $order_create_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoicePostAsync
     *
     * Create Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  \LightspeedV3\Model\OrderCreateRequest $order_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoicePostAsync($custom_field_id, $order_create_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'][0])
    {
        return $this->orderCustomFieldCustomFieldIDCustomFieldChoicePostAsyncWithHttpInfo($custom_field_id, $order_create_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCustomFieldCustomFieldIDCustomFieldChoicePostAsyncWithHttpInfo
     *
     * Create Order.CustomField.CustomFieldChoice
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  \LightspeedV3\Model\OrderCreateRequest $order_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoicePostAsyncWithHttpInfo($custom_field_id, $order_create_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'][0])
    {
        $returnType = 'object';
        $request = $this->orderCustomFieldCustomFieldIDCustomFieldChoicePostRequest($custom_field_id, $order_create_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCustomFieldCustomFieldIDCustomFieldChoicePost'
     *
     * @param  int $custom_field_id The customFieldID identifier (required)
     * @param  \LightspeedV3\Model\OrderCreateRequest $order_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCustomFieldCustomFieldIDCustomFieldChoicePostRequest($custom_field_id, $order_create_request, string $contentType = self::contentTypes['orderCustomFieldCustomFieldIDCustomFieldChoicePost'][0])
    {

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling orderCustomFieldCustomFieldIDCustomFieldChoicePost'
            );
        }

        // verify the required parameter 'order_create_request' is set
        if ($order_create_request === null || (is_array($order_create_request) && count($order_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_create_request when calling orderCustomFieldCustomFieldIDCustomFieldChoicePost'
            );
        }


        $resourcePath = '/Order/CustomField/{customFieldID}/CustomFieldChoice';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customFieldID' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_create_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_create_request));
            } else {
                $httpBody = $order_create_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
