<?php
/**
 * ItemItemApi
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use LightspeedV3\ApiException;
use LightspeedV3\Configuration;
use LightspeedV3\FormDataProcessor;
use LightspeedV3\HeaderSelector;
use LightspeedV3\ObjectSerializer;

/**
 * ItemItemApi Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemItemApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'itemGet' => [
            'application/json',
        ],
        'itemItemIDDelete' => [
            'application/json',
        ],
        'itemItemIDGet' => [
            'application/json',
        ],
        'itemItemIDPut' => [
            'application/json',
        ],
        'itemPost' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation itemGet
     *
     * Get Items list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\ItemListResponse
     */
    public function itemGet($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['itemGet'][0])
    {
        list($response) = $this->itemGetWithHttpInfo($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);
        return $response;
    }

    /**
     * Operation itemGetWithHttpInfo
     *
     * Get Items list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\ItemListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function itemGetWithHttpInfo($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['itemGet'][0])
    {
        $request = $this->itemGetRequest($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\ItemListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\ItemListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\ItemListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation itemGetAsync
     *
     * Get Items list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemGetAsync($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['itemGet'][0])
    {
        return $this->itemGetAsyncWithHttpInfo($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation itemGetAsyncWithHttpInfo
     *
     * Get Items list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemGetAsyncWithHttpInfo($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['itemGet'][0])
    {
        $returnType = '\LightspeedV3\Model\ItemListResponse';
        $request = $this->itemGetRequest($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'itemGet'
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function itemGetRequest($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['itemGet'][0])
    {




        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ItemItemApi.itemGet, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 0) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ItemItemApi.itemGet, must be bigger than or equal to 0.');
        }
        






        $resourcePath = '/Item';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $count,
            'count', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $time_stamp,
            'timeStamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation itemItemIDDelete
     *
     * Delete Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function itemItemIDDelete($item_id, string $contentType = self::contentTypes['itemItemIDDelete'][0])
    {
        $this->itemItemIDDeleteWithHttpInfo($item_id, $contentType);
    }

    /**
     * Operation itemItemIDDeleteWithHttpInfo
     *
     * Delete Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function itemItemIDDeleteWithHttpInfo($item_id, string $contentType = self::contentTypes['itemItemIDDelete'][0])
    {
        $request = $this->itemItemIDDeleteRequest($item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation itemItemIDDeleteAsync
     *
     * Delete Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemItemIDDeleteAsync($item_id, string $contentType = self::contentTypes['itemItemIDDelete'][0])
    {
        return $this->itemItemIDDeleteAsyncWithHttpInfo($item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation itemItemIDDeleteAsyncWithHttpInfo
     *
     * Delete Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemItemIDDeleteAsyncWithHttpInfo($item_id, string $contentType = self::contentTypes['itemItemIDDelete'][0])
    {
        $returnType = '';
        $request = $this->itemItemIDDeleteRequest($item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'itemItemIDDelete'
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function itemItemIDDeleteRequest($item_id, string $contentType = self::contentTypes['itemItemIDDelete'][0])
    {

        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling itemItemIDDelete'
            );
        }


        $resourcePath = '/Item/{itemID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation itemItemIDGet
     *
     * Get Item by ID
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\ItemResponse
     */
    public function itemItemIDGet($item_id, $load_relations = null, string $contentType = self::contentTypes['itemItemIDGet'][0])
    {
        list($response) = $this->itemItemIDGetWithHttpInfo($item_id, $load_relations, $contentType);
        return $response;
    }

    /**
     * Operation itemItemIDGetWithHttpInfo
     *
     * Get Item by ID
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\ItemResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function itemItemIDGetWithHttpInfo($item_id, $load_relations = null, string $contentType = self::contentTypes['itemItemIDGet'][0])
    {
        $request = $this->itemItemIDGetRequest($item_id, $load_relations, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\ItemResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\ItemResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\ItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation itemItemIDGetAsync
     *
     * Get Item by ID
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemItemIDGetAsync($item_id, $load_relations = null, string $contentType = self::contentTypes['itemItemIDGet'][0])
    {
        return $this->itemItemIDGetAsyncWithHttpInfo($item_id, $load_relations, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation itemItemIDGetAsyncWithHttpInfo
     *
     * Get Item by ID
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemItemIDGetAsyncWithHttpInfo($item_id, $load_relations = null, string $contentType = self::contentTypes['itemItemIDGet'][0])
    {
        $returnType = '\LightspeedV3\Model\ItemResponse';
        $request = $this->itemItemIDGetRequest($item_id, $load_relations, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'itemItemIDGet'
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function itemItemIDGetRequest($item_id, $load_relations = null, string $contentType = self::contentTypes['itemItemIDGet'][0])
    {

        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling itemItemIDGet'
            );
        }



        $resourcePath = '/Item/{itemID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation itemItemIDPut
     *
     * Update Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  \LightspeedV3\Model\ItemUpdateRequest $item_update_request item_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\ItemResponse
     */
    public function itemItemIDPut($item_id, $item_update_request, string $contentType = self::contentTypes['itemItemIDPut'][0])
    {
        list($response) = $this->itemItemIDPutWithHttpInfo($item_id, $item_update_request, $contentType);
        return $response;
    }

    /**
     * Operation itemItemIDPutWithHttpInfo
     *
     * Update Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  \LightspeedV3\Model\ItemUpdateRequest $item_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\ItemResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function itemItemIDPutWithHttpInfo($item_id, $item_update_request, string $contentType = self::contentTypes['itemItemIDPut'][0])
    {
        $request = $this->itemItemIDPutRequest($item_id, $item_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\ItemResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\ItemResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\ItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation itemItemIDPutAsync
     *
     * Update Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  \LightspeedV3\Model\ItemUpdateRequest $item_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemItemIDPutAsync($item_id, $item_update_request, string $contentType = self::contentTypes['itemItemIDPut'][0])
    {
        return $this->itemItemIDPutAsyncWithHttpInfo($item_id, $item_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation itemItemIDPutAsyncWithHttpInfo
     *
     * Update Item
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  \LightspeedV3\Model\ItemUpdateRequest $item_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemItemIDPutAsyncWithHttpInfo($item_id, $item_update_request, string $contentType = self::contentTypes['itemItemIDPut'][0])
    {
        $returnType = '\LightspeedV3\Model\ItemResponse';
        $request = $this->itemItemIDPutRequest($item_id, $item_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'itemItemIDPut'
     *
     * @param  int $item_id The itemID identifier (required)
     * @param  \LightspeedV3\Model\ItemUpdateRequest $item_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemItemIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function itemItemIDPutRequest($item_id, $item_update_request, string $contentType = self::contentTypes['itemItemIDPut'][0])
    {

        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling itemItemIDPut'
            );
        }

        // verify the required parameter 'item_update_request' is set
        if ($item_update_request === null || (is_array($item_update_request) && count($item_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_update_request when calling itemItemIDPut'
            );
        }


        $resourcePath = '/Item/{itemID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item_update_request));
            } else {
                $httpBody = $item_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation itemPost
     *
     * Create Item
     *
     * @param  \LightspeedV3\Model\ItemMatrix $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemPost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object|\LightspeedV3\Model\CategoryPost400Response
     */
    public function itemPost($body, string $contentType = self::contentTypes['itemPost'][0])
    {
        list($response) = $this->itemPostWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation itemPostWithHttpInfo
     *
     * Create Item
     *
     * @param  \LightspeedV3\Model\ItemMatrix $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemPost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object|\LightspeedV3\Model\CategoryPost400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function itemPostWithHttpInfo($body, string $contentType = self::contentTypes['itemPost'][0])
    {
        $request = $this->itemPostRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation itemPostAsync
     *
     * Create Item
     *
     * @param  \LightspeedV3\Model\ItemMatrix $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemPostAsync($body, string $contentType = self::contentTypes['itemPost'][0])
    {
        return $this->itemPostAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation itemPostAsyncWithHttpInfo
     *
     * Create Item
     *
     * @param  \LightspeedV3\Model\ItemMatrix $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function itemPostAsyncWithHttpInfo($body, string $contentType = self::contentTypes['itemPost'][0])
    {
        $returnType = 'object';
        $request = $this->itemPostRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'itemPost'
     *
     * @param  \LightspeedV3\Model\ItemMatrix $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['itemPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function itemPostRequest($body, string $contentType = self::contentTypes['itemPost'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling itemPost'
            );
        }


        $resourcePath = '/Item';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
