<?php
/**
 * CreditAccountApi
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use LightspeedV3\ApiException;
use LightspeedV3\Configuration;
use LightspeedV3\FormDataProcessor;
use LightspeedV3\HeaderSelector;
use LightspeedV3\ObjectSerializer;

/**
 * CreditAccountApi Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CreditAccountApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'creditAccountCreditAccountIDDelete' => [
            'application/json',
        ],
        'creditAccountCreditAccountIDGet' => [
            'application/json',
        ],
        'creditAccountCreditAccountIDPut' => [
            'application/json',
        ],
        'creditAccountGet' => [
            'application/json',
        ],
        'creditAccountPost' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation creditAccountCreditAccountIDDelete
     *
     * Delete CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function creditAccountCreditAccountIDDelete($credit_account_id, string $contentType = self::contentTypes['creditAccountCreditAccountIDDelete'][0])
    {
        $this->creditAccountCreditAccountIDDeleteWithHttpInfo($credit_account_id, $contentType);
    }

    /**
     * Operation creditAccountCreditAccountIDDeleteWithHttpInfo
     *
     * Delete CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDDelete'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function creditAccountCreditAccountIDDeleteWithHttpInfo($credit_account_id, string $contentType = self::contentTypes['creditAccountCreditAccountIDDelete'][0])
    {
        $request = $this->creditAccountCreditAccountIDDeleteRequest($credit_account_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation creditAccountCreditAccountIDDeleteAsync
     *
     * Delete CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountCreditAccountIDDeleteAsync($credit_account_id, string $contentType = self::contentTypes['creditAccountCreditAccountIDDelete'][0])
    {
        return $this->creditAccountCreditAccountIDDeleteAsyncWithHttpInfo($credit_account_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation creditAccountCreditAccountIDDeleteAsyncWithHttpInfo
     *
     * Delete CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountCreditAccountIDDeleteAsyncWithHttpInfo($credit_account_id, string $contentType = self::contentTypes['creditAccountCreditAccountIDDelete'][0])
    {
        $returnType = '';
        $request = $this->creditAccountCreditAccountIDDeleteRequest($credit_account_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'creditAccountCreditAccountIDDelete'
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function creditAccountCreditAccountIDDeleteRequest($credit_account_id, string $contentType = self::contentTypes['creditAccountCreditAccountIDDelete'][0])
    {

        // verify the required parameter 'credit_account_id' is set
        if ($credit_account_id === null || (is_array($credit_account_id) && count($credit_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_account_id when calling creditAccountCreditAccountIDDelete'
            );
        }


        $resourcePath = '/CreditAccount/{creditAccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($credit_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'creditAccountID' . '}',
                ObjectSerializer::toPathValue($credit_account_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation creditAccountCreditAccountIDGet
     *
     * Get CreditAccount by ID
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\CreditAccountListResponse
     */
    public function creditAccountCreditAccountIDGet($credit_account_id, $load_relations = null, string $contentType = self::contentTypes['creditAccountCreditAccountIDGet'][0])
    {
        list($response) = $this->creditAccountCreditAccountIDGetWithHttpInfo($credit_account_id, $load_relations, $contentType);
        return $response;
    }

    /**
     * Operation creditAccountCreditAccountIDGetWithHttpInfo
     *
     * Get CreditAccount by ID
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\CreditAccountListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function creditAccountCreditAccountIDGetWithHttpInfo($credit_account_id, $load_relations = null, string $contentType = self::contentTypes['creditAccountCreditAccountIDGet'][0])
    {
        $request = $this->creditAccountCreditAccountIDGetRequest($credit_account_id, $load_relations, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CreditAccountListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\CreditAccountListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CreditAccountListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation creditAccountCreditAccountIDGetAsync
     *
     * Get CreditAccount by ID
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountCreditAccountIDGetAsync($credit_account_id, $load_relations = null, string $contentType = self::contentTypes['creditAccountCreditAccountIDGet'][0])
    {
        return $this->creditAccountCreditAccountIDGetAsyncWithHttpInfo($credit_account_id, $load_relations, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation creditAccountCreditAccountIDGetAsyncWithHttpInfo
     *
     * Get CreditAccount by ID
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountCreditAccountIDGetAsyncWithHttpInfo($credit_account_id, $load_relations = null, string $contentType = self::contentTypes['creditAccountCreditAccountIDGet'][0])
    {
        $returnType = '\LightspeedV3\Model\CreditAccountListResponse';
        $request = $this->creditAccountCreditAccountIDGetRequest($credit_account_id, $load_relations, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'creditAccountCreditAccountIDGet'
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function creditAccountCreditAccountIDGetRequest($credit_account_id, $load_relations = null, string $contentType = self::contentTypes['creditAccountCreditAccountIDGet'][0])
    {

        // verify the required parameter 'credit_account_id' is set
        if ($credit_account_id === null || (is_array($credit_account_id) && count($credit_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_account_id when calling creditAccountCreditAccountIDGet'
            );
        }



        $resourcePath = '/CreditAccount/{creditAccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($credit_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'creditAccountID' . '}',
                ObjectSerializer::toPathValue($credit_account_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation creditAccountCreditAccountIDPut
     *
     * Update CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  \LightspeedV3\Model\CreditAccount $credit_account credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\CreditAccountResponse
     */
    public function creditAccountCreditAccountIDPut($credit_account_id, $credit_account, string $contentType = self::contentTypes['creditAccountCreditAccountIDPut'][0])
    {
        list($response) = $this->creditAccountCreditAccountIDPutWithHttpInfo($credit_account_id, $credit_account, $contentType);
        return $response;
    }

    /**
     * Operation creditAccountCreditAccountIDPutWithHttpInfo
     *
     * Update CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDPut'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\CreditAccountResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function creditAccountCreditAccountIDPutWithHttpInfo($credit_account_id, $credit_account, string $contentType = self::contentTypes['creditAccountCreditAccountIDPut'][0])
    {
        $request = $this->creditAccountCreditAccountIDPutRequest($credit_account_id, $credit_account, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CreditAccountResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\CreditAccountResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CreditAccountResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation creditAccountCreditAccountIDPutAsync
     *
     * Update CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountCreditAccountIDPutAsync($credit_account_id, $credit_account, string $contentType = self::contentTypes['creditAccountCreditAccountIDPut'][0])
    {
        return $this->creditAccountCreditAccountIDPutAsyncWithHttpInfo($credit_account_id, $credit_account, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation creditAccountCreditAccountIDPutAsyncWithHttpInfo
     *
     * Update CreditAccount
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountCreditAccountIDPutAsyncWithHttpInfo($credit_account_id, $credit_account, string $contentType = self::contentTypes['creditAccountCreditAccountIDPut'][0])
    {
        $returnType = '\LightspeedV3\Model\CreditAccountResponse';
        $request = $this->creditAccountCreditAccountIDPutRequest($credit_account_id, $credit_account, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'creditAccountCreditAccountIDPut'
     *
     * @param  int $credit_account_id The creditAccountID identifier (required)
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountCreditAccountIDPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function creditAccountCreditAccountIDPutRequest($credit_account_id, $credit_account, string $contentType = self::contentTypes['creditAccountCreditAccountIDPut'][0])
    {

        // verify the required parameter 'credit_account_id' is set
        if ($credit_account_id === null || (is_array($credit_account_id) && count($credit_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_account_id when calling creditAccountCreditAccountIDPut'
            );
        }

        // verify the required parameter 'credit_account' is set
        if ($credit_account === null || (is_array($credit_account) && count($credit_account) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_account when calling creditAccountCreditAccountIDPut'
            );
        }


        $resourcePath = '/CreditAccount/{creditAccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($credit_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'creditAccountID' . '}',
                ObjectSerializer::toPathValue($credit_account_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($credit_account)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($credit_account));
            } else {
                $httpBody = $credit_account;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation creditAccountGet
     *
     * Get CreditAccount list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \LightspeedV3\Model\CreditAccountListResponse
     */
    public function creditAccountGet($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['creditAccountGet'][0])
    {
        list($response) = $this->creditAccountGetWithHttpInfo($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);
        return $response;
    }

    /**
     * Operation creditAccountGetWithHttpInfo
     *
     * Get CreditAccount list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountGet'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \LightspeedV3\Model\CreditAccountListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function creditAccountGetWithHttpInfo($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['creditAccountGet'][0])
    {
        $request = $this->creditAccountGetRequest($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CreditAccountListResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\LightspeedV3\Model\CreditAccountListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CreditAccountListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation creditAccountGetAsync
     *
     * Get CreditAccount list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountGetAsync($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['creditAccountGet'][0])
    {
        return $this->creditAccountGetAsyncWithHttpInfo($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation creditAccountGetAsyncWithHttpInfo
     *
     * Get CreditAccount list
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountGetAsyncWithHttpInfo($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['creditAccountGet'][0])
    {
        $returnType = '\LightspeedV3\Model\CreditAccountListResponse';
        $request = $this->creditAccountGetRequest($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'creditAccountGet'
     *
     * @param  string|null $after Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. (optional)
     * @param  string|null $before Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. (optional)
     * @param  bool|null $count Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. (optional)
     * @param  int|null $limit Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. (optional, default to 100)
     * @param  string|null $load_relations Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). (optional)
     * @param  string|null $sort Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). (optional)
     * @param  \DateTime|null $time_stamp Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. (optional)
     * @param  string|null $archived Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. (optional)
     * @param  object|null $query Query the endpoint using query operators (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function creditAccountGetRequest($after = null, $before = null, $count = null, $limit = 100, $load_relations = null, $sort = null, $time_stamp = null, $archived = null, $query = null, string $contentType = self::contentTypes['creditAccountGet'][0])
    {




        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling CreditAccountApi.creditAccountGet, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 0) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling CreditAccountApi.creditAccountGet, must be bigger than or equal to 0.');
        }
        






        $resourcePath = '/CreditAccount';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $count,
            'count', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $load_relations,
            'load_relations', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $time_stamp,
            'timeStamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation creditAccountPost
     *
     * Create CreditAccount
     *
     * @param  \LightspeedV3\Model\CreditAccount $credit_account credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountPost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object|\LightspeedV3\Model\CategoryPost400Response
     */
    public function creditAccountPost($credit_account, string $contentType = self::contentTypes['creditAccountPost'][0])
    {
        list($response) = $this->creditAccountPostWithHttpInfo($credit_account, $contentType);
        return $response;
    }

    /**
     * Operation creditAccountPostWithHttpInfo
     *
     * Create CreditAccount
     *
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountPost'] to see the possible values for this operation
     *
     * @throws \LightspeedV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object|\LightspeedV3\Model\CategoryPost400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function creditAccountPostWithHttpInfo($credit_account, string $contentType = self::contentTypes['creditAccountPost'][0])
    {
        $request = $this->creditAccountPostRequest($credit_account, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\LightspeedV3\Model\CategoryPost400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation creditAccountPostAsync
     *
     * Create CreditAccount
     *
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountPostAsync($credit_account, string $contentType = self::contentTypes['creditAccountPost'][0])
    {
        return $this->creditAccountPostAsyncWithHttpInfo($credit_account, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation creditAccountPostAsyncWithHttpInfo
     *
     * Create CreditAccount
     *
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function creditAccountPostAsyncWithHttpInfo($credit_account, string $contentType = self::contentTypes['creditAccountPost'][0])
    {
        $returnType = 'object';
        $request = $this->creditAccountPostRequest($credit_account, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'creditAccountPost'
     *
     * @param  \LightspeedV3\Model\CreditAccount $credit_account (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['creditAccountPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function creditAccountPostRequest($credit_account, string $contentType = self::contentTypes['creditAccountPost'][0])
    {

        // verify the required parameter 'credit_account' is set
        if ($credit_account === null || (is_array($credit_account) && count($credit_account) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_account when calling creditAccountPost'
            );
        }


        $resourcePath = '/CreditAccount';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($credit_account)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($credit_account));
            } else {
                $httpBody = $credit_account;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
