# # Sale

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**sale_id** | **int** | Unique sale identifier |
**time_stamp** | **\DateTime** | Sale timestamp | [optional]
**discount_percent** | **float** | Discount percentage applied | [optional]
**completed** | **bool** | Whether sale is completed | [optional] [default to false]
**archived** | **bool** | Whether sale is archived | [optional] [default to false]
**voided** | **bool** | Whether sale is voided | [optional] [default to false]
**enable_promotions** | **bool** | Whether promotions are enabled | [optional] [default to true]
**is_tax_inclusive** | **bool** | Whether tax is inclusive | [optional] [default to false]
**create_time** | **\DateTime** | Sale creation time | [optional]
**update_time** | **\DateTime** | Sale last update time | [optional]
**complete_time** | **\DateTime** | Sale completion time | [optional]
**reference_number** | **string** | Reference number for the sale | [optional]
**reference_number_source** | **string** | Source of reference number | [optional]
**tax1_rate** | **float** | Tax 1 rate | [optional]
**tax2_rate** | **float** | Tax 2 rate | [optional]
**change** | **float** | Change given | [optional]
**receipt_preference** | **string** | Receipt preference (printed, email, etc) | [optional]
**displayable_subtotal** | **float** | Displayable subtotal amount | [optional]
**ticket_number** | **string** | Ticket number for the sale | [optional]
**calc_discount** | **float** | Calculated discount amount | [optional]
**total** | **float** | Total sale amount |
**calc_total** | **float** | Calculated total amount | [optional]
**calc_subtotal** | **float** | Calculated subtotal amount | [optional]
**calc_taxable** | **float** | Calculated taxable amount | [optional]
**calc_non_taxable** | **float** | Calculated non-taxable amount | [optional]
**calc_avg_cost** | **float** | Calculated average cost | [optional]
**calc_fifo_cost** | **float** | Calculated FIFO cost | [optional]
**calc_tax1** | **float** | Calculated tax 1 amount | [optional]
**calc_tax2** | **float** | Calculated tax 2 amount | [optional]
**calc_payments** | **float** | Calculated payments amount | [optional]
**calc_item_fees** | **float** | Calculated item fees | [optional]
**total_due** | **float** | Total amount due | [optional]
**displayable_total** | **float** | Displayable total amount | [optional]
**balance** | **float** | Balance remaining | [optional]
**customer_id** | **int** | Associated customer ID | [optional]
**discount_id** | **int** | Associated discount ID | [optional]
**employee_id** | **int** | Associated employee ID | [optional]
**quote_id** | **int** | Associated quote ID | [optional]
**register_id** | **int** | Register used for sale | [optional]
**ship_to_id** | **int** | Ship to ID | [optional]
**shop_id** | **int** | Shop where sale occurred | [optional]
**tax_category_id** | **int** | Tax category applied | [optional]
**tippable_amount** | **float** | Tippable amount | [optional]
**tax_total** | **float** | Total tax amount | [optional]
**sale_lines** | [**\LightspeedV3\Model\SaleLinesWrapper**](SaleLinesWrapper.md) |  | [optional]
**sale_payments** | [**\LightspeedV3\Model\SalePaymentsWrapper**](SalePaymentsWrapper.md) |  | [optional]
**sale_notes** | [**\LightspeedV3\Model\SaleNotesWrapper**](SaleNotesWrapper.md) |  | [optional]
**customer** | [**\LightspeedV3\Model\Customer**](Customer.md) |  | [optional]
**shop** | [**\LightspeedV3\Model\Shop**](Shop.md) |  | [optional]
**tax_category** | [**\LightspeedV3\Model\TaxCategory**](TaxCategory.md) |  | [optional]
**tax_class_totals** | [**\LightspeedV3\Model\TaxClassTotals**](TaxClassTotals.md) |  | [optional]
**discount** | [**\LightspeedV3\Model\Discount**](Discount.md) |  | [optional]
**quote** | [**\LightspeedV3\Model\Quote**](Quote.md) |  | [optional]
**ship_to** | [**\LightspeedV3\Model\ShipTo**](ShipTo.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
