# LightspeedV3\WorkorderWorkorderWorkorderLineApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**workorderWorkorderIDWorkorderLineGet()**](WorkorderWorkorderWorkorderLineApi.md#workorderWorkorderIDWorkorderLineGet) | **GET** /Workorder/{workorderID}/WorkorderLine | Get Workorder.WorkorderLine list |
| [**workorderWorkorderIDWorkorderLinePost()**](WorkorderWorkorderWorkorderLineApi.md#workorderWorkorderIDWorkorderLinePost) | **POST** /Workorder/{workorderID}/WorkorderLine | Create Workorder.WorkorderLine |
| [**workorderWorkorderIDWorkorderLineWorkorderLineIDDelete()**](WorkorderWorkorderWorkorderLineApi.md#workorderWorkorderIDWorkorderLineWorkorderLineIDDelete) | **DELETE** /Workorder/{workorderID}/WorkorderLine/{workorderLineID} | Delete Workorder.WorkorderLine |
| [**workorderWorkorderIDWorkorderLineWorkorderLineIDGet()**](WorkorderWorkorderWorkorderLineApi.md#workorderWorkorderIDWorkorderLineWorkorderLineIDGet) | **GET** /Workorder/{workorderID}/WorkorderLine/{workorderLineID} | Get Workorder.WorkorderLine by ID |
| [**workorderWorkorderIDWorkorderLineWorkorderLineIDPut()**](WorkorderWorkorderWorkorderLineApi.md#workorderWorkorderIDWorkorderLineWorkorderLineIDPut) | **PUT** /Workorder/{workorderID}/WorkorderLine/{workorderLineID} | Update Workorder.WorkorderLine |


## `workorderWorkorderIDWorkorderLineGet()`

```php
workorderWorkorderIDWorkorderLineGet($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\WorkorderListResponse
```

Get Workorder.WorkorderLine list

Retrieve a list of Workorder.WorkorderLine resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\WorkorderWorkorderWorkorderLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$workorder_id = 56; // int | The workorderID identifier
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->workorderWorkorderIDWorkorderLineGet($workorder_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkorderWorkorderWorkorderLineApi->workorderWorkorderIDWorkorderLineGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **workorder_id** | **int**| The workorderID identifier | |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\WorkorderListResponse**](../Model/WorkorderListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `workorderWorkorderIDWorkorderLinePost()`

```php
workorderWorkorderIDWorkorderLinePost($workorder_id, $workorder_create_request): object
```

Create Workorder.WorkorderLine

Create a new Workorder.WorkorderLine resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\WorkorderWorkorderWorkorderLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$workorder_id = 56; // int | The workorderID identifier
$workorder_create_request = new \LightspeedV3\Model\WorkorderCreateRequest(); // \LightspeedV3\Model\WorkorderCreateRequest

try {
    $result = $apiInstance->workorderWorkorderIDWorkorderLinePost($workorder_id, $workorder_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkorderWorkorderWorkorderLineApi->workorderWorkorderIDWorkorderLinePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **workorder_id** | **int**| The workorderID identifier | |
| **workorder_create_request** | [**\LightspeedV3\Model\WorkorderCreateRequest**](../Model/WorkorderCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `workorderWorkorderIDWorkorderLineWorkorderLineIDDelete()`

```php
workorderWorkorderIDWorkorderLineWorkorderLineIDDelete($workorder_id, $workorder_line_id)
```

Delete Workorder.WorkorderLine

Delete a Workorder.WorkorderLine resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\WorkorderWorkorderWorkorderLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$workorder_id = 56; // int | The workorderID identifier
$workorder_line_id = 56; // int | The workorderLineID identifier

try {
    $apiInstance->workorderWorkorderIDWorkorderLineWorkorderLineIDDelete($workorder_id, $workorder_line_id);
} catch (Exception $e) {
    echo 'Exception when calling WorkorderWorkorderWorkorderLineApi->workorderWorkorderIDWorkorderLineWorkorderLineIDDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **workorder_id** | **int**| The workorderID identifier | |
| **workorder_line_id** | **int**| The workorderLineID identifier | |

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `workorderWorkorderIDWorkorderLineWorkorderLineIDGet()`

```php
workorderWorkorderIDWorkorderLineWorkorderLineIDGet($workorder_id, $workorder_line_id): \LightspeedV3\Model\WorkorderListResponse
```

Get Workorder.WorkorderLine by ID

Retrieve a specific Workorder.WorkorderLine resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\WorkorderWorkorderWorkorderLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$workorder_id = 56; // int | The workorderID identifier
$workorder_line_id = 56; // int | The workorderLineID identifier

try {
    $result = $apiInstance->workorderWorkorderIDWorkorderLineWorkorderLineIDGet($workorder_id, $workorder_line_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkorderWorkorderWorkorderLineApi->workorderWorkorderIDWorkorderLineWorkorderLineIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **workorder_id** | **int**| The workorderID identifier | |
| **workorder_line_id** | **int**| The workorderLineID identifier | |

### Return type

[**\LightspeedV3\Model\WorkorderListResponse**](../Model/WorkorderListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `workorderWorkorderIDWorkorderLineWorkorderLineIDPut()`

```php
workorderWorkorderIDWorkorderLineWorkorderLineIDPut($workorder_id, $workorder_line_id, $workorder_update_request): \LightspeedV3\Model\WorkorderResponse
```

Update Workorder.WorkorderLine

Update an existing Workorder.WorkorderLine resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\WorkorderWorkorderWorkorderLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$workorder_id = 56; // int | The workorderID identifier
$workorder_line_id = 56; // int | The workorderLineID identifier
$workorder_update_request = new \LightspeedV3\Model\WorkorderUpdateRequest(); // \LightspeedV3\Model\WorkorderUpdateRequest

try {
    $result = $apiInstance->workorderWorkorderIDWorkorderLineWorkorderLineIDPut($workorder_id, $workorder_line_id, $workorder_update_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkorderWorkorderWorkorderLineApi->workorderWorkorderIDWorkorderLineWorkorderLineIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **workorder_id** | **int**| The workorderID identifier | |
| **workorder_line_id** | **int**| The workorderLineID identifier | |
| **workorder_update_request** | [**\LightspeedV3\Model\WorkorderUpdateRequest**](../Model/WorkorderUpdateRequest.md)|  | |

### Return type

[**\LightspeedV3\Model\WorkorderResponse**](../Model/WorkorderResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
