# LightspeedV3\SaleSaleSaleLineApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**saleSaleIDSaleLineGet()**](SaleSaleSaleLineApi.md#saleSaleIDSaleLineGet) | **GET** /Sale/{saleID}/SaleLine | Get Sale.SaleLine list |
| [**saleSaleIDSaleLinePost()**](SaleSaleSaleLineApi.md#saleSaleIDSaleLinePost) | **POST** /Sale/{saleID}/SaleLine | Create Sale.SaleLine |
| [**saleSaleIDSaleLineSaleLineIDDelete()**](SaleSaleSaleLineApi.md#saleSaleIDSaleLineSaleLineIDDelete) | **DELETE** /Sale/{saleID}/SaleLine/{saleLineID} | Delete Sale.SaleLine |
| [**saleSaleIDSaleLineSaleLineIDGet()**](SaleSaleSaleLineApi.md#saleSaleIDSaleLineSaleLineIDGet) | **GET** /Sale/{saleID}/SaleLine/{saleLineID} | Get Sale.SaleLine by ID |
| [**saleSaleIDSaleLineSaleLineIDPut()**](SaleSaleSaleLineApi.md#saleSaleIDSaleLineSaleLineIDPut) | **PUT** /Sale/{saleID}/SaleLine/{saleLineID} | Update Sale.SaleLine |


## `saleSaleIDSaleLineGet()`

```php
saleSaleIDSaleLineGet($sale_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\SaleListResponse
```

Get Sale.SaleLine list

Retrieve a list of Sale.SaleLine resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\SaleSaleSaleLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 56; // int | The saleID identifier
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->saleSaleIDSaleLineGet($sale_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleSaleSaleLineApi->saleSaleIDSaleLineGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **int**| The saleID identifier | |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\SaleListResponse**](../Model/SaleListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `saleSaleIDSaleLinePost()`

```php
saleSaleIDSaleLinePost($sale_id, $sale_create_request): object
```

Create Sale.SaleLine

Create a new Sale.SaleLine resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\SaleSaleSaleLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 56; // int | The saleID identifier
$sale_create_request = new \LightspeedV3\Model\SaleCreateRequest(); // \LightspeedV3\Model\SaleCreateRequest

try {
    $result = $apiInstance->saleSaleIDSaleLinePost($sale_id, $sale_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleSaleSaleLineApi->saleSaleIDSaleLinePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **int**| The saleID identifier | |
| **sale_create_request** | [**\LightspeedV3\Model\SaleCreateRequest**](../Model/SaleCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `saleSaleIDSaleLineSaleLineIDDelete()`

```php
saleSaleIDSaleLineSaleLineIDDelete($sale_id, $sale_line_id)
```

Delete Sale.SaleLine

Delete a Sale.SaleLine resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\SaleSaleSaleLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 56; // int | The saleID identifier
$sale_line_id = 56; // int | The saleLineID identifier

try {
    $apiInstance->saleSaleIDSaleLineSaleLineIDDelete($sale_id, $sale_line_id);
} catch (Exception $e) {
    echo 'Exception when calling SaleSaleSaleLineApi->saleSaleIDSaleLineSaleLineIDDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **int**| The saleID identifier | |
| **sale_line_id** | **int**| The saleLineID identifier | |

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `saleSaleIDSaleLineSaleLineIDGet()`

```php
saleSaleIDSaleLineSaleLineIDGet($sale_id, $sale_line_id): \LightspeedV3\Model\SaleListResponse
```

Get Sale.SaleLine by ID

Retrieve a specific Sale.SaleLine resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\SaleSaleSaleLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 56; // int | The saleID identifier
$sale_line_id = 56; // int | The saleLineID identifier

try {
    $result = $apiInstance->saleSaleIDSaleLineSaleLineIDGet($sale_id, $sale_line_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleSaleSaleLineApi->saleSaleIDSaleLineSaleLineIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **int**| The saleID identifier | |
| **sale_line_id** | **int**| The saleLineID identifier | |

### Return type

[**\LightspeedV3\Model\SaleListResponse**](../Model/SaleListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `saleSaleIDSaleLineSaleLineIDPut()`

```php
saleSaleIDSaleLineSaleLineIDPut($sale_id, $sale_line_id, $sale): \LightspeedV3\Model\SaleResponse
```

Update Sale.SaleLine

Update an existing Sale.SaleLine resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\SaleSaleSaleLineApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 56; // int | The saleID identifier
$sale_line_id = 56; // int | The saleLineID identifier
$sale = new \LightspeedV3\Model\Sale(); // \LightspeedV3\Model\Sale

try {
    $result = $apiInstance->saleSaleIDSaleLineSaleLineIDPut($sale_id, $sale_line_id, $sale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleSaleSaleLineApi->saleSaleIDSaleLineSaleLineIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **int**| The saleID identifier | |
| **sale_line_id** | **int**| The saleLineID identifier | |
| **sale** | [**\LightspeedV3\Model\Sale**](../Model/Sale.md)|  | |

### Return type

[**\LightspeedV3\Model\SaleResponse**](../Model/SaleResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
