# LightspeedV3\SaleSaleRefundApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**saleSaleIDRefundPost()**](SaleSaleRefundApi.md#saleSaleIDRefundPost) | **POST** /Sale/{saleID}/refund | Create Sale.Refund |


## `saleSaleIDRefundPost()`

```php
saleSaleIDRefundPost($sale_id, $sale_create_request): object
```

Create Sale.Refund

Create a new Sale.Refund resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\SaleSaleRefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 56; // int | The saleID identifier
$sale_create_request = new \LightspeedV3\Model\SaleCreateRequest(); // \LightspeedV3\Model\SaleCreateRequest

try {
    $result = $apiInstance->saleSaleIDRefundPost($sale_id, $sale_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleSaleRefundApi->saleSaleIDRefundPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **int**| The saleID identifier | |
| **sale_create_request** | [**\LightspeedV3\Model\SaleCreateRequest**](../Model/SaleCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
