# LightspeedV3\ReportsApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**reportsAccountingDiscountsByDayGet()**](ReportsApi.md#reportsAccountingDiscountsByDayGet) | **GET** /Reports/Accounting/DiscountsByDay | Reports.Accounting.DiscountsByDay |
| [**reportsAccountingOrdersByTaxClassGet()**](ReportsApi.md#reportsAccountingOrdersByTaxClassGet) | **GET** /Reports/Accounting/OrdersByTaxClass | Reports.Accounting.OrdersByTaxClass |
| [**reportsAccountingPaymentsByDayGet()**](ReportsApi.md#reportsAccountingPaymentsByDayGet) | **GET** /Reports/Accounting/PaymentsByDay | Reports.Accounting.PaymentsByDay |
| [**reportsAccountingTaxClassSalesByDayGet()**](ReportsApi.md#reportsAccountingTaxClassSalesByDayGet) | **GET** /Reports/Accounting/TaxClassSalesByDay | Reports.Accounting.TaxClassSalesByDay |
| [**reportsAccountingTaxesByDayGet()**](ReportsApi.md#reportsAccountingTaxesByDayGet) | **GET** /Reports/Accounting/TaxesByDay | Reports.Accounting.TaxesByDay |


## `reportsAccountingDiscountsByDayGet()`

```php
reportsAccountingDiscountsByDayGet($start_date, $end_date): \LightspeedV3\Model\GenericResponse
```

Reports.Accounting.DiscountsByDay

Perform GET operation on Reports.Accounting.DiscountsByDay

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\ReportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$start_date = {startDate}; // string
$end_date = {endDate}; // string

try {
    $result = $apiInstance->reportsAccountingDiscountsByDayGet($start_date, $end_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReportsApi->reportsAccountingDiscountsByDayGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `reportsAccountingOrdersByTaxClassGet()`

```php
reportsAccountingOrdersByTaxClassGet($start_date, $end_date): \LightspeedV3\Model\GenericResponse
```

Reports.Accounting.OrdersByTaxClass

Perform GET operation on Reports.Accounting.OrdersByTaxClass

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\ReportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$start_date = {startDate}; // string
$end_date = {endDate}; // string

try {
    $result = $apiInstance->reportsAccountingOrdersByTaxClassGet($start_date, $end_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReportsApi->reportsAccountingOrdersByTaxClassGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `reportsAccountingPaymentsByDayGet()`

```php
reportsAccountingPaymentsByDayGet($start_date, $end_date): \LightspeedV3\Model\GenericResponse
```

Reports.Accounting.PaymentsByDay

Perform GET operation on Reports.Accounting.PaymentsByDay

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\ReportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$start_date = {startDate}; // string
$end_date = {endDate}; // string

try {
    $result = $apiInstance->reportsAccountingPaymentsByDayGet($start_date, $end_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReportsApi->reportsAccountingPaymentsByDayGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `reportsAccountingTaxClassSalesByDayGet()`

```php
reportsAccountingTaxClassSalesByDayGet($start_date, $end_date): \LightspeedV3\Model\GenericResponse
```

Reports.Accounting.TaxClassSalesByDay

Perform GET operation on Reports.Accounting.TaxClassSalesByDay

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\ReportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$start_date = {startDate}; // string
$end_date = {endDate}; // string

try {
    $result = $apiInstance->reportsAccountingTaxClassSalesByDayGet($start_date, $end_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReportsApi->reportsAccountingTaxClassSalesByDayGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `reportsAccountingTaxesByDayGet()`

```php
reportsAccountingTaxesByDayGet($start_date, $end_date): \LightspeedV3\Model\GenericResponse
```

Reports.Accounting.TaxesByDay

Perform GET operation on Reports.Accounting.TaxesByDay

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\ReportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$start_date = {startDate}; // string
$end_date = {endDate}; // string

try {
    $result = $apiInstance->reportsAccountingTaxesByDayGet($start_date, $end_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReportsApi->reportsAccountingTaxesByDayGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
