# LightspeedV3\RegisterRegisterCalculatedApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**registerRegisterIDCalculatedGet()**](RegisterRegisterCalculatedApi.md#registerRegisterIDCalculatedGet) | **GET** /Register/{registerID}/calculated | Register.Calculated |


## `registerRegisterIDCalculatedGet()`

```php
registerRegisterIDCalculatedGet($register_id): \LightspeedV3\Model\RegisterListResponse
```

Register.Calculated

Perform GET operation on Register.Calculated

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\RegisterRegisterCalculatedApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_id = 56; // int | The registerID identifier

try {
    $result = $apiInstance->registerRegisterIDCalculatedGet($register_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegisterRegisterCalculatedApi->registerRegisterIDCalculatedGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **register_id** | **int**| The registerID identifier | |

### Return type

[**\LightspeedV3\Model\RegisterListResponse**](../Model/RegisterListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
