# LightspeedV3\OrderOrderCustomFieldCustomFieldChoiceApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete()**](OrderOrderCustomFieldCustomFieldChoiceApi.md#orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete) | **DELETE** /Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Delete Order.CustomField.CustomFieldChoice |
| [**orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet()**](OrderOrderCustomFieldCustomFieldChoiceApi.md#orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet) | **GET** /Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Get Order.CustomField.CustomFieldChoice by ID |
| [**orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut()**](OrderOrderCustomFieldCustomFieldChoiceApi.md#orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut) | **PUT** /Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Update Order.CustomField.CustomFieldChoice |
| [**orderCustomFieldCustomFieldIDCustomFieldChoiceGet()**](OrderOrderCustomFieldCustomFieldChoiceApi.md#orderCustomFieldCustomFieldIDCustomFieldChoiceGet) | **GET** /Order/CustomField/{customFieldID}/CustomFieldChoice | Get Order.CustomField.CustomFieldChoice list |
| [**orderCustomFieldCustomFieldIDCustomFieldChoicePost()**](OrderOrderCustomFieldCustomFieldChoiceApi.md#orderCustomFieldCustomFieldIDCustomFieldChoicePost) | **POST** /Order/CustomField/{customFieldID}/CustomFieldChoice | Create Order.CustomField.CustomFieldChoice |


## `orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete()`

```php
orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete($custom_field_id, $custom_field_choice_id)
```

Delete Order.CustomField.CustomFieldChoice

Delete a Order.CustomField.CustomFieldChoice resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldCustomFieldChoiceApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$custom_field_choice_id = 56; // int | The customFieldChoiceID identifier

try {
    $apiInstance->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete($custom_field_id, $custom_field_choice_id);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldCustomFieldChoiceApi->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **custom_field_choice_id** | **int**| The customFieldChoiceID identifier | |

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet()`

```php
orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet($custom_field_id, $custom_field_choice_id): \LightspeedV3\Model\OrderListResponse
```

Get Order.CustomField.CustomFieldChoice by ID

Retrieve a specific Order.CustomField.CustomFieldChoice resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldCustomFieldChoiceApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$custom_field_choice_id = 56; // int | The customFieldChoiceID identifier

try {
    $result = $apiInstance->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet($custom_field_id, $custom_field_choice_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldCustomFieldChoiceApi->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **custom_field_choice_id** | **int**| The customFieldChoiceID identifier | |

### Return type

[**\LightspeedV3\Model\OrderListResponse**](../Model/OrderListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut()`

```php
orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut($custom_field_id, $custom_field_choice_id, $order_update_request): \LightspeedV3\Model\OrderResponse
```

Update Order.CustomField.CustomFieldChoice

Update an existing Order.CustomField.CustomFieldChoice resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldCustomFieldChoiceApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$custom_field_choice_id = 56; // int | The customFieldChoiceID identifier
$order_update_request = new \LightspeedV3\Model\OrderUpdateRequest(); // \LightspeedV3\Model\OrderUpdateRequest

try {
    $result = $apiInstance->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut($custom_field_id, $custom_field_choice_id, $order_update_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldCustomFieldChoiceApi->orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **custom_field_choice_id** | **int**| The customFieldChoiceID identifier | |
| **order_update_request** | [**\LightspeedV3\Model\OrderUpdateRequest**](../Model/OrderUpdateRequest.md)|  | |

### Return type

[**\LightspeedV3\Model\OrderResponse**](../Model/OrderResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldCustomFieldIDCustomFieldChoiceGet()`

```php
orderCustomFieldCustomFieldIDCustomFieldChoiceGet($custom_field_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\OrderListResponse
```

Get Order.CustomField.CustomFieldChoice list

Retrieve a list of Order.CustomField.CustomFieldChoice resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldCustomFieldChoiceApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->orderCustomFieldCustomFieldIDCustomFieldChoiceGet($custom_field_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldCustomFieldChoiceApi->orderCustomFieldCustomFieldIDCustomFieldChoiceGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\OrderListResponse**](../Model/OrderListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldCustomFieldIDCustomFieldChoicePost()`

```php
orderCustomFieldCustomFieldIDCustomFieldChoicePost($custom_field_id, $order_create_request): object
```

Create Order.CustomField.CustomFieldChoice

Create a new Order.CustomField.CustomFieldChoice resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldCustomFieldChoiceApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$order_create_request = new \LightspeedV3\Model\OrderCreateRequest(); // \LightspeedV3\Model\OrderCreateRequest

try {
    $result = $apiInstance->orderCustomFieldCustomFieldIDCustomFieldChoicePost($custom_field_id, $order_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldCustomFieldChoiceApi->orderCustomFieldCustomFieldIDCustomFieldChoicePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **order_create_request** | [**\LightspeedV3\Model\OrderCreateRequest**](../Model/OrderCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
