# LightspeedV3\OrderOrderCustomFieldApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**orderCustomFieldCustomFieldIDDelete()**](OrderOrderCustomFieldApi.md#orderCustomFieldCustomFieldIDDelete) | **DELETE** /Order/CustomField/{customFieldID} | Delete Order.CustomField |
| [**orderCustomFieldCustomFieldIDGet()**](OrderOrderCustomFieldApi.md#orderCustomFieldCustomFieldIDGet) | **GET** /Order/CustomField/{customFieldID} | Get Order.CustomField by ID |
| [**orderCustomFieldCustomFieldIDPut()**](OrderOrderCustomFieldApi.md#orderCustomFieldCustomFieldIDPut) | **PUT** /Order/CustomField/{customFieldID} | Update Order.CustomField |
| [**orderCustomFieldGet()**](OrderOrderCustomFieldApi.md#orderCustomFieldGet) | **GET** /Order/CustomField | Get Order.CustomField list |
| [**orderCustomFieldPost()**](OrderOrderCustomFieldApi.md#orderCustomFieldPost) | **POST** /Order/CustomField | Create Order.CustomField |


## `orderCustomFieldCustomFieldIDDelete()`

```php
orderCustomFieldCustomFieldIDDelete($custom_field_id)
```

Delete Order.CustomField

Delete a Order.CustomField resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier

try {
    $apiInstance->orderCustomFieldCustomFieldIDDelete($custom_field_id);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldApi->orderCustomFieldCustomFieldIDDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldCustomFieldIDGet()`

```php
orderCustomFieldCustomFieldIDGet($custom_field_id): \LightspeedV3\Model\OrderListResponse
```

Get Order.CustomField by ID

Retrieve a specific Order.CustomField resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier

try {
    $result = $apiInstance->orderCustomFieldCustomFieldIDGet($custom_field_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldApi->orderCustomFieldCustomFieldIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |

### Return type

[**\LightspeedV3\Model\OrderListResponse**](../Model/OrderListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldCustomFieldIDPut()`

```php
orderCustomFieldCustomFieldIDPut($custom_field_id, $order_update_request): \LightspeedV3\Model\OrderResponse
```

Update Order.CustomField

Update an existing Order.CustomField resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$order_update_request = new \LightspeedV3\Model\OrderUpdateRequest(); // \LightspeedV3\Model\OrderUpdateRequest

try {
    $result = $apiInstance->orderCustomFieldCustomFieldIDPut($custom_field_id, $order_update_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldApi->orderCustomFieldCustomFieldIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **order_update_request** | [**\LightspeedV3\Model\OrderUpdateRequest**](../Model/OrderUpdateRequest.md)|  | |

### Return type

[**\LightspeedV3\Model\OrderResponse**](../Model/OrderResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldGet()`

```php
orderCustomFieldGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\OrderListResponse
```

Get Order.CustomField list

Retrieve a list of Order.CustomField resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->orderCustomFieldGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldApi->orderCustomFieldGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\OrderListResponse**](../Model/OrderListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCustomFieldPost()`

```php
orderCustomFieldPost($order_create_request): object
```

Create Order.CustomField

Create a new Order.CustomField resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\OrderOrderCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_create_request = new \LightspeedV3\Model\OrderCreateRequest(); // \LightspeedV3\Model\OrderCreateRequest

try {
    $result = $apiInstance->orderCustomFieldPost($order_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderOrderCustomFieldApi->orderCustomFieldPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_create_request** | [**\LightspeedV3\Model\OrderCreateRequest**](../Model/OrderCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
