# LightspeedV3\InventoryInventoryTransferTransferItemsApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**inventoryTransferTransferIDAddItemsPost()**](InventoryInventoryTransferTransferItemsApi.md#inventoryTransferTransferIDAddItemsPost) | **POST** /Inventory/Transfer/{transferID}/AddItems | Create Add Items to a Transfer |
| [**inventoryTransferTransferIDDeleteItemsPost()**](InventoryInventoryTransferTransferItemsApi.md#inventoryTransferTransferIDDeleteItemsPost) | **POST** /Inventory/Transfer/{transferID}/DeleteItems | Create Delete TransferItems |
| [**inventoryTransferTransferIDTransferItemsGet()**](InventoryInventoryTransferTransferItemsApi.md#inventoryTransferTransferIDTransferItemsGet) | **GET** /Inventory/Transfer/{transferID}/TransferItems | Get TransfersItems on a Transfer list |
| [**inventoryTransferTransferIDTransferItemsTransferItemIDGet()**](InventoryInventoryTransferTransferItemsApi.md#inventoryTransferTransferIDTransferItemsTransferItemIDGet) | **GET** /Inventory/Transfer/{transferID}/TransferItems/{transferItemID} | Get TransferItem by ID |
| [**inventoryTransferTransferIDUpdateItemsPost()**](InventoryInventoryTransferTransferItemsApi.md#inventoryTransferTransferIDUpdateItemsPost) | **POST** /Inventory/Transfer/{transferID}/UpdateItems | Create Update TransferItems |


## `inventoryTransferTransferIDAddItemsPost()`

```php
inventoryTransferTransferIDAddItemsPost($transfer_id, $transfer): object
```

Create Add Items to a Transfer

Create a new Add Items to a Transfer resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferTransferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDAddItemsPost($transfer_id, $transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferTransferItemsApi->inventoryTransferTransferIDAddItemsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDDeleteItemsPost()`

```php
inventoryTransferTransferIDDeleteItemsPost($transfer_id, $transfer): object
```

Create Delete TransferItems

Create a new Delete TransferItems resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferTransferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDDeleteItemsPost($transfer_id, $transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferTransferItemsApi->inventoryTransferTransferIDDeleteItemsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDTransferItemsGet()`

```php
inventoryTransferTransferIDTransferItemsGet($transfer_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\GenericResponse
```

Get TransfersItems on a Transfer list

Retrieve a list of TransfersItems on a Transfer resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferTransferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->inventoryTransferTransferIDTransferItemsGet($transfer_id, $after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferTransferItemsApi->inventoryTransferTransferIDTransferItemsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDTransferItemsTransferItemIDGet()`

```php
inventoryTransferTransferIDTransferItemsTransferItemIDGet($transfer_id, $transfer_item_id): \LightspeedV3\Model\GenericResponse
```

Get TransferItem by ID

Retrieve a specific TransferItem resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferTransferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer_item_id = 56; // int | The transferItemID identifier

try {
    $result = $apiInstance->inventoryTransferTransferIDTransferItemsTransferItemIDGet($transfer_id, $transfer_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferTransferItemsApi->inventoryTransferTransferIDTransferItemsTransferItemIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer_item_id** | **int**| The transferItemID identifier | |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDUpdateItemsPost()`

```php
inventoryTransferTransferIDUpdateItemsPost($transfer_id, $transfer): object
```

Create Update TransferItems

Create a new Update TransferItems resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferTransferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDUpdateItemsPost($transfer_id, $transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferTransferItemsApi->inventoryTransferTransferIDUpdateItemsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
