# LightspeedV3\InventoryInventoryTransferApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**inventoryTransferGet()**](InventoryInventoryTransferApi.md#inventoryTransferGet) | **GET** /Inventory/Transfer | Get Inventory Transfer list |
| [**inventoryTransferPost()**](InventoryInventoryTransferApi.md#inventoryTransferPost) | **POST** /Inventory/Transfer | Create Create a Transfer |
| [**inventoryTransferTransferIDArchivePost()**](InventoryInventoryTransferApi.md#inventoryTransferTransferIDArchivePost) | **POST** /Inventory/Transfer/{transferID}/Archive | Create Archive a Transfer |
| [**inventoryTransferTransferIDGet()**](InventoryInventoryTransferApi.md#inventoryTransferTransferIDGet) | **GET** /Inventory/Transfer/{transferID} | Get Inventory Transfer by ID |
| [**inventoryTransferTransferIDPut()**](InventoryInventoryTransferApi.md#inventoryTransferTransferIDPut) | **PUT** /Inventory/Transfer/[transferID} | Update Update a Transfer |
| [**inventoryTransferTransferIDRestorePost()**](InventoryInventoryTransferApi.md#inventoryTransferTransferIDRestorePost) | **POST** /Inventory/Transfer/{transferID}/Restore | Create Restore a Transfer |
| [**inventoryTransferTransferIDSendPost()**](InventoryInventoryTransferApi.md#inventoryTransferTransferIDSendPost) | **POST** /Inventory/Transfer/{transferID}/Send | Create Send a Transfer |


## `inventoryTransferGet()`

```php
inventoryTransferGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\GenericResponse
```

Get Inventory Transfer list

Retrieve a list of Inventory Transfer resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->inventoryTransferGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferPost()`

```php
inventoryTransferPost($transfer): object
```

Create Create a Transfer

Create a new Create a Transfer resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferPost($transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDArchivePost()`

```php
inventoryTransferTransferIDArchivePost($transfer_id, $transfer): object
```

Create Archive a Transfer

Create a new Archive a Transfer resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDArchivePost($transfer_id, $transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferTransferIDArchivePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDGet()`

```php
inventoryTransferTransferIDGet($transfer_id): \LightspeedV3\Model\GenericResponse
```

Get Inventory Transfer by ID

Retrieve a specific Inventory Transfer resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier

try {
    $result = $apiInstance->inventoryTransferTransferIDGet($transfer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferTransferIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDPut()`

```php
inventoryTransferTransferIDPut($transfer): \LightspeedV3\Model\GenericResponse
```

Update Update a Transfer

Update an existing Update a Transfer resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDPut($transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferTransferIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDRestorePost()`

```php
inventoryTransferTransferIDRestorePost($transfer_id, $transfer): object
```

Create Restore a Transfer

Create a new Restore a Transfer resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDRestorePost($transfer_id, $transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferTransferIDRestorePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryTransferTransferIDSendPost()`

```php
inventoryTransferTransferIDSendPost($transfer_id, $transfer): object
```

Create Send a Transfer

Create a new Send a Transfer resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryTransferApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_id = 56; // int | The transferID identifier
$transfer = new \LightspeedV3\Model\Transfer(); // \LightspeedV3\Model\Transfer

try {
    $result = $apiInstance->inventoryTransferTransferIDSendPost($transfer_id, $transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryTransferApi->inventoryTransferTransferIDSendPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_id** | **int**| The transferID identifier | |
| **transfer** | [**\LightspeedV3\Model\Transfer**](../Model/Transfer.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
