# LightspeedV3\InventoryInventoryCountItemApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**inventoryCountItemDelete()**](InventoryInventoryCountItemApi.md#inventoryCountItemDelete) | **DELETE** /InventoryCountItem | Delete InventoryCountItem |
| [**inventoryCountItemGet()**](InventoryInventoryCountItemApi.md#inventoryCountItemGet) | **GET** /InventoryCountItem | Get InventoryCountItem list |
| [**inventoryCountItemInventoryCountItemIDGet()**](InventoryInventoryCountItemApi.md#inventoryCountItemInventoryCountItemIDGet) | **GET** /InventoryCountItem/{inventoryCountItemID} | Get InventoryCountItem by ID |
| [**inventoryCountItemInventoryCountItemIDPut()**](InventoryInventoryCountItemApi.md#inventoryCountItemInventoryCountItemIDPut) | **PUT** /InventoryCountItem/{inventoryCountItemID} | Update InventoryCountItem |
| [**inventoryCountItemPost()**](InventoryInventoryCountItemApi.md#inventoryCountItemPost) | **POST** /InventoryCountItem | Create InventoryCountItem |


## `inventoryCountItemDelete()`

```php
inventoryCountItemDelete()
```

Delete InventoryCountItem

Delete a InventoryCountItem resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryCountItemApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $apiInstance->inventoryCountItemDelete();
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryCountItemApi->inventoryCountItemDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryCountItemGet()`

```php
inventoryCountItemGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\InventoryCountItemListResponse
```

Get InventoryCountItem list

Retrieve a list of InventoryCountItem resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryCountItemApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->inventoryCountItemGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryCountItemApi->inventoryCountItemGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\InventoryCountItemListResponse**](../Model/InventoryCountItemListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryCountItemInventoryCountItemIDGet()`

```php
inventoryCountItemInventoryCountItemIDGet($inventory_count_item_id, $load_relations): \LightspeedV3\Model\InventoryCountItem
```

Get InventoryCountItem by ID

Retrieve a specific InventoryCountItem resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryCountItemApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_count_item_id = 56; // int | The inventoryCountItemID identifier
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").

try {
    $result = $apiInstance->inventoryCountItemInventoryCountItemIDGet($inventory_count_item_id, $load_relations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryCountItemApi->inventoryCountItemInventoryCountItemIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_count_item_id** | **int**| The inventoryCountItemID identifier | |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |

### Return type

[**\LightspeedV3\Model\InventoryCountItem**](../Model/InventoryCountItem.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryCountItemInventoryCountItemIDPut()`

```php
inventoryCountItemInventoryCountItemIDPut($inventory_count_item_id, $inventory_count_item): \LightspeedV3\Model\GenericResponse
```

Update InventoryCountItem

Update an existing InventoryCountItem resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryCountItemApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_count_item_id = 56; // int | The inventoryCountItemID identifier
$inventory_count_item = new \LightspeedV3\Model\InventoryCountItem(); // \LightspeedV3\Model\InventoryCountItem

try {
    $result = $apiInstance->inventoryCountItemInventoryCountItemIDPut($inventory_count_item_id, $inventory_count_item);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryCountItemApi->inventoryCountItemInventoryCountItemIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_count_item_id** | **int**| The inventoryCountItemID identifier | |
| **inventory_count_item** | [**\LightspeedV3\Model\InventoryCountItem**](../Model/InventoryCountItem.md)|  | |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryCountItemPost()`

```php
inventoryCountItemPost($inventory_count_item): object
```

Create InventoryCountItem

Create a new InventoryCountItem resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\InventoryInventoryCountItemApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_count_item = new \LightspeedV3\Model\InventoryCountItem(); // \LightspeedV3\Model\InventoryCountItem

try {
    $result = $apiInstance->inventoryCountItemPost($inventory_count_item);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryInventoryCountItemApi->inventoryCountItemPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_count_item** | [**\LightspeedV3\Model\InventoryCountItem**](../Model/InventoryCountItem.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
