# LightspeedV3\CustomerTypeApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customerTypeCustomerTypeIDDelete()**](CustomerTypeApi.md#customerTypeCustomerTypeIDDelete) | **DELETE** /CustomerType/{customerTypeID} | Delete CustomerType |
| [**customerTypeCustomerTypeIDGet()**](CustomerTypeApi.md#customerTypeCustomerTypeIDGet) | **GET** /CustomerType/{customerTypeID} | Get CustomerType by ID |
| [**customerTypeCustomerTypeIDPut()**](CustomerTypeApi.md#customerTypeCustomerTypeIDPut) | **PUT** /CustomerType/{customerTypeID} | Update CustomerType |
| [**customerTypeGet()**](CustomerTypeApi.md#customerTypeGet) | **GET** /CustomerType | Get CustomerType list |
| [**customerTypePost()**](CustomerTypeApi.md#customerTypePost) | **POST** /CustomerType | Create CustomerType |


## `customerTypeCustomerTypeIDDelete()`

```php
customerTypeCustomerTypeIDDelete($customer_type_id)
```

Delete CustomerType

Delete a CustomerType resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerTypeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_type_id = 56; // int | The customerTypeID identifier

try {
    $apiInstance->customerTypeCustomerTypeIDDelete($customer_type_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomerTypeApi->customerTypeCustomerTypeIDDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_type_id** | **int**| The customerTypeID identifier | |

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerTypeCustomerTypeIDGet()`

```php
customerTypeCustomerTypeIDGet($customer_type_id, $load_relations): \LightspeedV3\Model\CustomerTypeListResponse
```

Get CustomerType by ID

Retrieve a specific CustomerType resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerTypeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_type_id = 56; // int | The customerTypeID identifier
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").

try {
    $result = $apiInstance->customerTypeCustomerTypeIDGet($customer_type_id, $load_relations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerTypeApi->customerTypeCustomerTypeIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_type_id** | **int**| The customerTypeID identifier | |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |

### Return type

[**\LightspeedV3\Model\CustomerTypeListResponse**](../Model/CustomerTypeListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerTypeCustomerTypeIDPut()`

```php
customerTypeCustomerTypeIDPut($customer_type_id, $customer_type): \LightspeedV3\Model\CustomerTypeResponse
```

Update CustomerType

Update an existing CustomerType resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerTypeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_type_id = 56; // int | The customerTypeID identifier
$customer_type = new \LightspeedV3\Model\CustomerType(); // \LightspeedV3\Model\CustomerType

try {
    $result = $apiInstance->customerTypeCustomerTypeIDPut($customer_type_id, $customer_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerTypeApi->customerTypeCustomerTypeIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_type_id** | **int**| The customerTypeID identifier | |
| **customer_type** | [**\LightspeedV3\Model\CustomerType**](../Model/CustomerType.md)|  | |

### Return type

[**\LightspeedV3\Model\CustomerTypeResponse**](../Model/CustomerTypeResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerTypeGet()`

```php
customerTypeGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\CustomerTypeListResponse
```

Get CustomerType list

Retrieve a list of CustomerType resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerTypeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->customerTypeGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerTypeApi->customerTypeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\CustomerTypeListResponse**](../Model/CustomerTypeListResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerTypePost()`

```php
customerTypePost($customer_create_request): object
```

Create CustomerType

Create a new CustomerType resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerTypeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_create_request = new \LightspeedV3\Model\CustomerCreateRequest(); // \LightspeedV3\Model\CustomerCreateRequest

try {
    $result = $apiInstance->customerTypePost($customer_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerTypeApi->customerTypePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_create_request** | [**\LightspeedV3\Model\CustomerCreateRequest**](../Model/CustomerCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
