# LightspeedV3\CustomerCustomerCustomFieldApi

All URIs are relative to https://api.lightspeedapp.com/API/V3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customerCustomFieldCustomFieldIDDelete()**](CustomerCustomerCustomFieldApi.md#customerCustomFieldCustomFieldIDDelete) | **DELETE** /Customer/CustomField/{customFieldID} | Delete CustomField |
| [**customerCustomFieldCustomFieldIDGet()**](CustomerCustomerCustomFieldApi.md#customerCustomFieldCustomFieldIDGet) | **GET** /Customer/CustomField/{customFieldID} | Get CustomField by ID |
| [**customerCustomFieldCustomFieldIDPut()**](CustomerCustomerCustomFieldApi.md#customerCustomFieldCustomFieldIDPut) | **PUT** /Customer/CustomField/{customFieldID} | Update CustomField |
| [**customerCustomFieldGet()**](CustomerCustomerCustomFieldApi.md#customerCustomFieldGet) | **GET** /Customer/CustomField | Get CustomField list |
| [**customerCustomFieldPost()**](CustomerCustomerCustomFieldApi.md#customerCustomFieldPost) | **POST** /Customer/CustomField | Create CustomField |


## `customerCustomFieldCustomFieldIDDelete()`

```php
customerCustomFieldCustomFieldIDDelete($custom_field_id)
```

Delete CustomField

Delete a CustomField resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerCustomerCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier

try {
    $apiInstance->customerCustomFieldCustomFieldIDDelete($custom_field_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomerCustomerCustomFieldApi->customerCustomFieldCustomFieldIDDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |

### Return type

void (empty response body)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerCustomFieldCustomFieldIDGet()`

```php
customerCustomFieldCustomFieldIDGet($custom_field_id): \LightspeedV3\Model\GenericResponse
```

Get CustomField by ID

Retrieve a specific CustomField resource by its ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerCustomerCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier

try {
    $result = $apiInstance->customerCustomFieldCustomFieldIDGet($custom_field_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerCustomerCustomFieldApi->customerCustomFieldCustomFieldIDGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerCustomFieldCustomFieldIDPut()`

```php
customerCustomFieldCustomFieldIDPut($custom_field_id, $customer_update_request): \LightspeedV3\Model\CustomerResponse
```

Update CustomField

Update an existing CustomField resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerCustomerCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$custom_field_id = 56; // int | The customFieldID identifier
$customer_update_request = new \LightspeedV3\Model\CustomerUpdateRequest(); // \LightspeedV3\Model\CustomerUpdateRequest

try {
    $result = $apiInstance->customerCustomFieldCustomFieldIDPut($custom_field_id, $customer_update_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerCustomerCustomFieldApi->customerCustomFieldCustomFieldIDPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **custom_field_id** | **int**| The customFieldID identifier | |
| **customer_update_request** | [**\LightspeedV3\Model\CustomerUpdateRequest**](../Model/CustomerUpdateRequest.md)|  | |

### Return type

[**\LightspeedV3\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerCustomFieldGet()`

```php
customerCustomFieldGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query): \LightspeedV3\Model\GenericResponse
```

Get CustomField list

Retrieve a list of CustomField resources

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerCustomerCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->customerCustomFieldGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerCustomerCustomFieldApi->customerCustomFieldGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **after** | **string**| Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page. | [optional] |
| **before** | **string**| Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page. | [optional] |
| **count** | **bool**| Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters. | [optional] |
| **limit** | **int**| Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100. | [optional] [default to 100] |
| **load_relations** | **string**| Comma-separated list of relations to load with the primary resource (e.g., \&quot;Customer,Items\&quot;). | [optional] |
| **sort** | **string**| Determine the sort order of the records by field name. Prefix with \&quot;-\&quot; for descending order (e.g., \&quot;-customerID\&quot; for descending, \&quot;firstName\&quot; for ascending). | [optional] |
| **time_stamp** | **\DateTime**| Search by specific timestamp in ISO 8601 format (e.g., \&quot;2024-01-15T14:30:00-05:00\&quot;). Times are stored in UTC. | [optional] |
| **archived** | **string**| Controls return of archived results. \&quot;true\&quot; includes archived, \&quot;false\&quot; excludes archived (default), \&quot;only\&quot; returns only archived results. | [optional] |
| **query** | [**object**](../Model/.md)| Query the endpoint using query operators | [optional] |

### Return type

[**\LightspeedV3\Model\GenericResponse**](../Model/GenericResponse.md)

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerCustomFieldPost()`

```php
customerCustomFieldPost($customer_create_request): object
```

Create CustomField

Create a new CustomField resource

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\CustomerCustomerCustomFieldApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_create_request = new \LightspeedV3\Model\CustomerCreateRequest(); // \LightspeedV3\Model\CustomerCreateRequest

try {
    $result = $apiInstance->customerCustomFieldPost($customer_create_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerCustomerCustomFieldApi->customerCustomFieldPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_create_request** | [**\LightspeedV3\Model\CustomerCreateRequest**](../Model/CustomerCreateRequest.md)|  | |

### Return type

**object**

### Authorization

[BearerAuth](../../README.md#BearerAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
