# OpenAPIClient-php

API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.

NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)


For more information, please visit [https://developers.lightspeedhq.com/retail/](https://developers.lightspeedhq.com/retail/).

## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/lightspeedV3.git"
    }
  ],
  "require": {
    "talisman/lightspeedV3": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure Bearer (JWT) authorization: BearerAuth
$config = LightspeedV3\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new LightspeedV3\Api\AccountApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 'after_example'; // string | Used to paginate forward to subsequent pages. Provide an encoded string representing the last resource ID from the current page.
$before = 'before_example'; // string | Used to paginate backward to previous pages. Provide an encoded string representing the first resource ID from the current page.
$count = True; // bool | Specify that the count of all potential results should be returned. Note: This costs 10 drips and cannot be combined with other pagination parameters.
$limit = 100; // int | Restricts the maximum number of objects returned per GET request. Default is 100, maximum is 100.
$load_relations = 'load_relations_example'; // string | Comma-separated list of relations to load with the primary resource (e.g., \"Customer,Items\").
$sort = 'sort_example'; // string | Determine the sort order of the records by field name. Prefix with \"-\" for descending order (e.g., \"-customerID\" for descending, \"firstName\" for ascending).
$time_stamp = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Search by specific timestamp in ISO 8601 format (e.g., \"2024-01-15T14:30:00-05:00\"). Times are stored in UTC.
$archived = 'archived_example'; // string | Controls return of archived results. \"true\" includes archived, \"false\" excludes archived (default), \"only\" returns only archived results.
$query = array('key' => new \stdClass); // object | Query the endpoint using query operators

try {
    $result = $apiInstance->accountGet($after, $before, $count, $limit, $load_relations, $sort, $time_stamp, $archived, $query);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountApi->accountGet: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.lightspeedapp.com/API/V3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**accountGet**](docs/Api/AccountApi.md#accountget) | **GET** /Account | Get Account list
*CCChargeApi* | [**cCChargeCcChargeIDGet**](docs/Api/CCChargeApi.md#ccchargeccchargeidget) | **GET** /CCCharge/{ccChargeID} | Get CCCharge by ID
*CCChargeApi* | [**cCChargeGet**](docs/Api/CCChargeApi.md#ccchargeget) | **GET** /CCCharge | Get CCCharge list
*CatalogSearchApi* | [**catalogSearchGet**](docs/Api/CatalogSearchApi.md#catalogsearchget) | **GET** /Catalog/Search | Catalog Search
*CatalogVendorItemApi* | [**catalogVendorItemCatalogVendorItemIDGet**](docs/Api/CatalogVendorItemApi.md#catalogvendoritemcatalogvendoritemidget) | **GET** /CatalogVendorItem/{catalogVendorItemID} | Get CatalogVendorItem by ID
*CatalogVendorItemApi* | [**catalogVendorItemGet**](docs/Api/CatalogVendorItemApi.md#catalogvendoritemget) | **GET** /CatalogVendorItem | Get CatalogVendorItem list
*CategoryApi* | [**categoryCategoryIDDelete**](docs/Api/CategoryApi.md#categorycategoryiddelete) | **DELETE** /Category/{categoryID} | Delete Category
*CategoryApi* | [**categoryCategoryIDGet**](docs/Api/CategoryApi.md#categorycategoryidget) | **GET** /Category/{categoryID} | Get Category by ID
*CategoryApi* | [**categoryCategoryIDPut**](docs/Api/CategoryApi.md#categorycategoryidput) | **PUT** /Category/{categoryID} | Update Category
*CategoryApi* | [**categoryGet**](docs/Api/CategoryApi.md#categoryget) | **GET** /Category | Get Category list
*CategoryApi* | [**categoryPost**](docs/Api/CategoryApi.md#categorypost) | **POST** /Category | Create Category
*CreditAccountApi* | [**creditAccountCreditAccountIDDelete**](docs/Api/CreditAccountApi.md#creditaccountcreditaccountiddelete) | **DELETE** /CreditAccount/{creditAccountID} | Delete CreditAccount
*CreditAccountApi* | [**creditAccountCreditAccountIDGet**](docs/Api/CreditAccountApi.md#creditaccountcreditaccountidget) | **GET** /CreditAccount/{creditAccountID} | Get CreditAccount by ID
*CreditAccountApi* | [**creditAccountCreditAccountIDPut**](docs/Api/CreditAccountApi.md#creditaccountcreditaccountidput) | **PUT** /CreditAccount/{creditAccountID} | Update CreditAccount
*CreditAccountApi* | [**creditAccountGet**](docs/Api/CreditAccountApi.md#creditaccountget) | **GET** /CreditAccount | Get CreditAccount list
*CreditAccountApi* | [**creditAccountPost**](docs/Api/CreditAccountApi.md#creditaccountpost) | **POST** /CreditAccount | Create CreditAccount
*CustomerCustomerApi* | [**customerCustomerIDDelete**](docs/Api/CustomerCustomerApi.md#customercustomeriddelete) | **DELETE** /Customer/{customerID} | Delete Customer
*CustomerCustomerApi* | [**customerCustomerIDGet**](docs/Api/CustomerCustomerApi.md#customercustomeridget) | **GET** /Customer/{customerID} | Get Customer by ID
*CustomerCustomerApi* | [**customerCustomerIDPut**](docs/Api/CustomerCustomerApi.md#customercustomeridput) | **PUT** /Customer/{customerID} | Update Customer
*CustomerCustomerApi* | [**customerGet**](docs/Api/CustomerCustomerApi.md#customerget) | **GET** /Customer | Get Customer list
*CustomerCustomerApi* | [**customerPost**](docs/Api/CustomerCustomerApi.md#customerpost) | **POST** /Customer | Create Customer
*CustomerCustomerCustomFieldApi* | [**customerCustomFieldCustomFieldIDDelete**](docs/Api/CustomerCustomerCustomFieldApi.md#customercustomfieldcustomfieldiddelete) | **DELETE** /Customer/CustomField/{customFieldID} | Delete CustomField
*CustomerCustomerCustomFieldApi* | [**customerCustomFieldCustomFieldIDGet**](docs/Api/CustomerCustomerCustomFieldApi.md#customercustomfieldcustomfieldidget) | **GET** /Customer/CustomField/{customFieldID} | Get CustomField by ID
*CustomerCustomerCustomFieldApi* | [**customerCustomFieldCustomFieldIDPut**](docs/Api/CustomerCustomerCustomFieldApi.md#customercustomfieldcustomfieldidput) | **PUT** /Customer/CustomField/{customFieldID} | Update CustomField
*CustomerCustomerCustomFieldApi* | [**customerCustomFieldGet**](docs/Api/CustomerCustomerCustomFieldApi.md#customercustomfieldget) | **GET** /Customer/CustomField | Get CustomField list
*CustomerCustomerCustomFieldApi* | [**customerCustomFieldPost**](docs/Api/CustomerCustomerCustomFieldApi.md#customercustomfieldpost) | **POST** /Customer/CustomField | Create CustomField
*CustomerCustomerCustomFieldCustomerFieldChoiceApi* | [**customerCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete**](docs/Api/CustomerCustomerCustomFieldCustomerFieldChoiceApi.md#customercustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceiddelete) | **DELETE** /Customer/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Delete CustomFieldChoice
*CustomerCustomerCustomFieldCustomerFieldChoiceApi* | [**customerCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet**](docs/Api/CustomerCustomerCustomFieldCustomerFieldChoiceApi.md#customercustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceidget) | **GET** /Customer/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Get CustomFieldChoice by ID
*CustomerCustomerCustomFieldCustomerFieldChoiceApi* | [**customerCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut**](docs/Api/CustomerCustomerCustomFieldCustomerFieldChoiceApi.md#customercustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceidput) | **PUT** /Customer/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Update CustomFieldChoice
*CustomerCustomerCustomFieldCustomerFieldChoiceApi* | [**customerCustomFieldCustomFieldIDCustomFieldChoiceGet**](docs/Api/CustomerCustomerCustomFieldCustomerFieldChoiceApi.md#customercustomfieldcustomfieldidcustomfieldchoiceget) | **GET** /Customer/CustomField/{customFieldID}/CustomFieldChoice | Get CustomFieldChoice list
*CustomerCustomerCustomFieldCustomerFieldChoiceApi* | [**customerCustomFieldCustomFieldIDCustomFieldChoicePost**](docs/Api/CustomerCustomerCustomFieldCustomerFieldChoiceApi.md#customercustomfieldcustomfieldidcustomfieldchoicepost) | **POST** /Customer/CustomField/{customFieldID}/CustomFieldChoice | Create CustomFieldChoice
*CustomerTypeApi* | [**customerTypeCustomerTypeIDDelete**](docs/Api/CustomerTypeApi.md#customertypecustomertypeiddelete) | **DELETE** /CustomerType/{customerTypeID} | Delete CustomerType
*CustomerTypeApi* | [**customerTypeCustomerTypeIDGet**](docs/Api/CustomerTypeApi.md#customertypecustomertypeidget) | **GET** /CustomerType/{customerTypeID} | Get CustomerType by ID
*CustomerTypeApi* | [**customerTypeCustomerTypeIDPut**](docs/Api/CustomerTypeApi.md#customertypecustomertypeidput) | **PUT** /CustomerType/{customerTypeID} | Update CustomerType
*CustomerTypeApi* | [**customerTypeGet**](docs/Api/CustomerTypeApi.md#customertypeget) | **GET** /CustomerType | Get CustomerType list
*CustomerTypeApi* | [**customerTypePost**](docs/Api/CustomerTypeApi.md#customertypepost) | **POST** /CustomerType | Create CustomerType
*DiscountApi* | [**discountDiscountIDDelete**](docs/Api/DiscountApi.md#discountdiscountiddelete) | **DELETE** /Discount/{discountID} | Delete Discount
*DiscountApi* | [**discountDiscountIDGet**](docs/Api/DiscountApi.md#discountdiscountidget) | **GET** /Discount/{discountID} | Get Discount by ID
*DiscountApi* | [**discountDiscountIDPut**](docs/Api/DiscountApi.md#discountdiscountidput) | **PUT** /Discount/{discountID} | Update Discount
*DiscountApi* | [**discountGet**](docs/Api/DiscountApi.md#discountget) | **GET** /Discount | Get Discount list
*DiscountApi* | [**discountPost**](docs/Api/DiscountApi.md#discountpost) | **POST** /Discount | Create Discount
*DisplayTemplateDisplayTemplateEmployeeApi* | [**displayTemplateEmployeeEmployeeIDGet**](docs/Api/DisplayTemplateDisplayTemplateEmployeeApi.md#displaytemplateemployeeemployeeidget) | **GET** /DisplayTemplate/Employee/{employeeID} | Get DisplayTemplate.Employee by ID
*DisplayTemplateDisplayTemplateEmployeeApi* | [**displayTemplateEmployeeGet**](docs/Api/DisplayTemplateDisplayTemplateEmployeeApi.md#displaytemplateemployeeget) | **GET** /DisplayTemplate/Employee | Get DisplayTemplate.Employee list
*DisplayTemplateDisplayTemplateItemAsLabelApi* | [**displayTemplateItemAsLabelGet**](docs/Api/DisplayTemplateDisplayTemplateItemAsLabelApi.md#displaytemplateitemaslabelget) | **GET** /DisplayTemplate/ItemAsLabel | Get DisplayTemplate.ItemAsLabel list
*DisplayTemplateDisplayTemplateItemAsLabelApi* | [**displayTemplateItemAsLabelItemIDGet**](docs/Api/DisplayTemplateDisplayTemplateItemAsLabelApi.md#displaytemplateitemaslabelitemidget) | **GET** /DisplayTemplate/ItemAsLabel/{itemID} | Get DisplayTemplate.ItemAsLabel by ID
*DisplayTemplateDisplayTemplateLabelApi* | [**displayTemplateLabelGet**](docs/Api/DisplayTemplateDisplayTemplateLabelApi.md#displaytemplatelabelget) | **GET** /DisplayTemplate/Label | Get DisplayTemplate.Label list
*DisplayTemplateDisplayTemplateLabelApi* | [**displayTemplateLabelLabelIDGet**](docs/Api/DisplayTemplateDisplayTemplateLabelApi.md#displaytemplatelabellabelidget) | **GET** /DisplayTemplate/Label/{labelID} | Get DisplayTemplate.Label by ID
*DisplayTemplateDisplayTemplateOrderApi* | [**displayTemplateOrderGet**](docs/Api/DisplayTemplateDisplayTemplateOrderApi.md#displaytemplateorderget) | **GET** /DisplayTemplate/Order | Get DisplayTemplate.Order list
*DisplayTemplateDisplayTemplateOrderApi* | [**displayTemplateOrderOrderIDGet**](docs/Api/DisplayTemplateDisplayTemplateOrderApi.md#displaytemplateorderorderidget) | **GET** /DisplayTemplate/Order/{orderID} | Get DisplayTemplate.Order by ID
*DisplayTemplateDisplayTemplateOrderLineAsLabelApi* | [**displayTemplateOrderLineAsLabelGet**](docs/Api/DisplayTemplateDisplayTemplateOrderLineAsLabelApi.md#displaytemplateorderlineaslabelget) | **GET** /DisplayTemplate/OrderLineAsLabel | Get DisplayTemplate.OrderLineAsLabel list
*DisplayTemplateDisplayTemplateOrderLineAsLabelApi* | [**displayTemplateOrderLineAsLabelOrderLineIDGet**](docs/Api/DisplayTemplateDisplayTemplateOrderLineAsLabelApi.md#displaytemplateorderlineaslabelorderlineidget) | **GET** /DisplayTemplate/OrderLineAsLabel/{orderLineID} | Get DisplayTemplate.OrderLineAsLabel by ID
*DisplayTemplateDisplayTemplateRegisterCountApi* | [**displayTemplateRegisterCountGet**](docs/Api/DisplayTemplateDisplayTemplateRegisterCountApi.md#displaytemplateregistercountget) | **GET** /DisplayTemplate/RegisterCount | Get DisplayTemplate.RegisterCount list
*DisplayTemplateDisplayTemplateRegisterWithdrawApi* | [**displayTemplateRegisterWithdrawGet**](docs/Api/DisplayTemplateDisplayTemplateRegisterWithdrawApi.md#displaytemplateregisterwithdrawget) | **GET** /DisplayTemplate/RegisterWithdraw | Get DisplayTemplate.RegisterWithdraw list
*DisplayTemplateDisplayTemplateRegisterWithdrawApi* | [**displayTemplateRegisterWithdrawRegisterWithdrawIDGet**](docs/Api/DisplayTemplateDisplayTemplateRegisterWithdrawApi.md#displaytemplateregisterwithdrawregisterwithdrawidget) | **GET** /DisplayTemplate/RegisterWithdraw/{registerWithdrawID} | Get DisplayTemplate.RegisterWithdraw by ID
*DisplayTemplateDisplayTemplateSaleApi* | [**displayTemplateSaleGet**](docs/Api/DisplayTemplateDisplayTemplateSaleApi.md#displaytemplatesaleget) | **GET** /DisplayTemplate/Sale | Get DisplayTemplate.Sale list
*DisplayTemplateDisplayTemplateSaleApi* | [**displayTemplateSaleSaleIDGet**](docs/Api/DisplayTemplateDisplayTemplateSaleApi.md#displaytemplatesalesaleidget) | **GET** /DisplayTemplate/Sale/{saleID} | Get DisplayTemplate.Sale by ID
*DisplayTemplateDisplayTemplateTransferApi* | [**displayTemplateTransferGet**](docs/Api/DisplayTemplateDisplayTemplateTransferApi.md#displaytemplatetransferget) | **GET** /DisplayTemplate/Transfer | Get DisplayTemplate.Transfer list
*DisplayTemplateDisplayTemplateTransferApi* | [**displayTemplateTransferTransferIDGet**](docs/Api/DisplayTemplateDisplayTemplateTransferApi.md#displaytemplatetransfertransferidget) | **GET** /DisplayTemplate/Transfer/{transferID} | Get DisplayTemplate.Transfer by ID
*DisplayTemplateDisplayTemplateTransferItemAsLabelApi* | [**displayTemplateTransferItemAsLabelGet**](docs/Api/DisplayTemplateDisplayTemplateTransferItemAsLabelApi.md#displaytemplatetransferitemaslabelget) | **GET** /DisplayTemplate/TransferItemAsLabel | Get DisplayTemplate.TransferItemAsLabel list
*DisplayTemplateDisplayTemplateTransferItemAsLabelApi* | [**displayTemplateTransferItemAsLabelTransferItemIDGet**](docs/Api/DisplayTemplateDisplayTemplateTransferItemAsLabelApi.md#displaytemplatetransferitemaslabeltransferitemidget) | **GET** /DisplayTemplate/TransferItemAsLabel/{transferItemID} | Get DisplayTemplate.TransferItemAsLabel by ID
*DisplayTemplateDisplayTemplateVendorReturnApi* | [**displayTemplateVendorReturnGet**](docs/Api/DisplayTemplateDisplayTemplateVendorReturnApi.md#displaytemplatevendorreturnget) | **GET** /DisplayTemplate/VendorReturn | Get DisplayTemplate.VendorReturn list
*DisplayTemplateDisplayTemplateVendorReturnApi* | [**displayTemplateVendorReturnVendorReturnIDGet**](docs/Api/DisplayTemplateDisplayTemplateVendorReturnApi.md#displaytemplatevendorreturnvendorreturnidget) | **GET** /DisplayTemplate/VendorReturn/{vendorReturnID} | Get DisplayTemplate.VendorReturn by ID
*DisplayTemplateDisplayTemplateWorkorderApi* | [**displayTemplateWorkorderGet**](docs/Api/DisplayTemplateDisplayTemplateWorkorderApi.md#displaytemplateworkorderget) | **GET** /DisplayTemplate/Workorder | Get DisplayTemplate.Workorder list
*DisplayTemplateDisplayTemplateWorkorderApi* | [**displayTemplateWorkorderWorkOrderIDGet**](docs/Api/DisplayTemplateDisplayTemplateWorkorderApi.md#displaytemplateworkorderworkorderidget) | **GET** /DisplayTemplate/Workorder/{workOrderID} | Get DisplayTemplate.Workorder by ID
*EmployeeApi* | [**employeeEmployeeIDDelete**](docs/Api/EmployeeApi.md#employeeemployeeiddelete) | **DELETE** /Employee/{employeeID} | Delete Employee
*EmployeeApi* | [**employeeEmployeeIDGet**](docs/Api/EmployeeApi.md#employeeemployeeidget) | **GET** /Employee/{employeeID} | Get Employee by ID
*EmployeeApi* | [**employeeEmployeeIDPut**](docs/Api/EmployeeApi.md#employeeemployeeidput) | **PUT** /Employee/{employeeID} | Update Employee
*EmployeeApi* | [**employeeGet**](docs/Api/EmployeeApi.md#employeeget) | **GET** /Employee | Get Employee list
*EmployeeApi* | [**employeePost**](docs/Api/EmployeeApi.md#employeepost) | **POST** /Employee | Create Employee
*EmployeeHoursApi* | [**employeeHoursEmployeeHoursIDDelete**](docs/Api/EmployeeHoursApi.md#employeehoursemployeehoursiddelete) | **DELETE** /EmployeeHours/{employeeHoursID} | Delete EmployeeHours
*EmployeeHoursApi* | [**employeeHoursEmployeeHoursIDGet**](docs/Api/EmployeeHoursApi.md#employeehoursemployeehoursidget) | **GET** /EmployeeHours/{employeeHoursID} | Get EmployeeHours by ID
*EmployeeHoursApi* | [**employeeHoursEmployeeHoursIDPut**](docs/Api/EmployeeHoursApi.md#employeehoursemployeehoursidput) | **PUT** /EmployeeHours/{employeeHoursID} | Update EmployeeHours
*EmployeeHoursApi* | [**employeeHoursGet**](docs/Api/EmployeeHoursApi.md#employeehoursget) | **GET** /EmployeeHours | Get EmployeeHours list
*EmployeeHoursApi* | [**employeeHoursPost**](docs/Api/EmployeeHoursApi.md#employeehourspost) | **POST** /EmployeeHours | Create EmployeeHours
*IndustryApi* | [**industryGet**](docs/Api/IndustryApi.md#industryget) | **GET** /Industry | Get Industry list
*IndustryApi* | [**industryIndustryIDGet**](docs/Api/IndustryApi.md#industryindustryidget) | **GET** /Industry/{industryID} | Get Industry by ID
*IndustryApi* | [**industryIndustryIDPut**](docs/Api/IndustryApi.md#industryindustryidput) | **PUT** /Industry/{industryID} | Update Industry
*InventoryInventoryCountApi* | [**inventoryCountGet**](docs/Api/InventoryInventoryCountApi.md#inventorycountget) | **GET** /InventoryCount | Get InventoryCount list
*InventoryInventoryCountApi* | [**inventoryCountInventoryCountIDDelete**](docs/Api/InventoryInventoryCountApi.md#inventorycountinventorycountiddelete) | **DELETE** /InventoryCount/{inventoryCountID} | Delete InventoryCount
*InventoryInventoryCountApi* | [**inventoryCountInventoryCountIDGet**](docs/Api/InventoryInventoryCountApi.md#inventorycountinventorycountidget) | **GET** /InventoryCount/{inventoryCountID} | Get InventoryCount by ID
*InventoryInventoryCountApi* | [**inventoryCountInventoryCountIDPut**](docs/Api/InventoryInventoryCountApi.md#inventorycountinventorycountidput) | **PUT** /InventoryCount/{inventoryCountID} | Update InventoryCount
*InventoryInventoryCountApi* | [**inventoryCountPost**](docs/Api/InventoryInventoryCountApi.md#inventorycountpost) | **POST** /InventoryCount | Create InventoryCount
*InventoryInventoryCountCalcApi* | [**inventoryCountCalcGet**](docs/Api/InventoryInventoryCountCalcApi.md#inventorycountcalcget) | **GET** /InventoryCountCalc | Get InventoryCountCalc list
*InventoryInventoryCountCalcApi* | [**inventoryCountCalcInventoryCountCalcIDGet**](docs/Api/InventoryInventoryCountCalcApi.md#inventorycountcalcinventorycountcalcidget) | **GET** /InventoryCountCalc/{inventoryCountCalcID} | Get InventoryCountCalc by ID
*InventoryInventoryCountItemApi* | [**inventoryCountItemDelete**](docs/Api/InventoryInventoryCountItemApi.md#inventorycountitemdelete) | **DELETE** /InventoryCountItem | Delete InventoryCountItem
*InventoryInventoryCountItemApi* | [**inventoryCountItemGet**](docs/Api/InventoryInventoryCountItemApi.md#inventorycountitemget) | **GET** /InventoryCountItem | Get InventoryCountItem list
*InventoryInventoryCountItemApi* | [**inventoryCountItemInventoryCountItemIDGet**](docs/Api/InventoryInventoryCountItemApi.md#inventorycountiteminventorycountitemidget) | **GET** /InventoryCountItem/{inventoryCountItemID} | Get InventoryCountItem by ID
*InventoryInventoryCountItemApi* | [**inventoryCountItemInventoryCountItemIDPut**](docs/Api/InventoryInventoryCountItemApi.md#inventorycountiteminventorycountitemidput) | **PUT** /InventoryCountItem/{inventoryCountItemID} | Update InventoryCountItem
*InventoryInventoryCountItemApi* | [**inventoryCountItemPost**](docs/Api/InventoryInventoryCountItemApi.md#inventorycountitempost) | **POST** /InventoryCountItem | Create InventoryCountItem
*InventoryInventoryCountReconcileApi* | [**inventoryCountReconcileGet**](docs/Api/InventoryInventoryCountReconcileApi.md#inventorycountreconcileget) | **GET** /InventoryCountReconcile | Get InventoryCountReconcile list
*InventoryInventoryCountReconcileApi* | [**inventoryCountReconcileInventoryCountReconcileIDGet**](docs/Api/InventoryInventoryCountReconcileApi.md#inventorycountreconcileinventorycountreconcileidget) | **GET** /InventoryCountReconcile/{inventoryCountReconcileID} | Get InventoryCountReconcile by ID
*InventoryInventoryCountReconcileApi* | [**inventoryCountReconcileInventoryCountReconcileIDPost**](docs/Api/InventoryInventoryCountReconcileApi.md#inventorycountreconcileinventorycountreconcileidpost) | **POST** /InventoryCountReconcile/{inventoryCountReconcileID} | Create InventoryCountReconcile
*InventoryInventoryLogApi* | [**inventoryLogGet**](docs/Api/InventoryInventoryLogApi.md#inventorylogget) | **GET** /InventoryLog | InventoryLog
*InventoryInventoryTransferApi* | [**inventoryTransferGet**](docs/Api/InventoryInventoryTransferApi.md#inventorytransferget) | **GET** /Inventory/Transfer | Get Inventory Transfer list
*InventoryInventoryTransferApi* | [**inventoryTransferPost**](docs/Api/InventoryInventoryTransferApi.md#inventorytransferpost) | **POST** /Inventory/Transfer | Create Create a Transfer
*InventoryInventoryTransferApi* | [**inventoryTransferTransferIDArchivePost**](docs/Api/InventoryInventoryTransferApi.md#inventorytransfertransferidarchivepost) | **POST** /Inventory/Transfer/{transferID}/Archive | Create Archive a Transfer
*InventoryInventoryTransferApi* | [**inventoryTransferTransferIDGet**](docs/Api/InventoryInventoryTransferApi.md#inventorytransfertransferidget) | **GET** /Inventory/Transfer/{transferID} | Get Inventory Transfer by ID
*InventoryInventoryTransferApi* | [**inventoryTransferTransferIDPut**](docs/Api/InventoryInventoryTransferApi.md#inventorytransfertransferidput) | **PUT** /Inventory/Transfer/[transferID} | Update Update a Transfer
*InventoryInventoryTransferApi* | [**inventoryTransferTransferIDRestorePost**](docs/Api/InventoryInventoryTransferApi.md#inventorytransfertransferidrestorepost) | **POST** /Inventory/Transfer/{transferID}/Restore | Create Restore a Transfer
*InventoryInventoryTransferApi* | [**inventoryTransferTransferIDSendPost**](docs/Api/InventoryInventoryTransferApi.md#inventorytransfertransferidsendpost) | **POST** /Inventory/Transfer/{transferID}/Send | Create Send a Transfer
*InventoryInventoryTransferTransferItemsApi* | [**inventoryTransferTransferIDAddItemsPost**](docs/Api/InventoryInventoryTransferTransferItemsApi.md#inventorytransfertransferidadditemspost) | **POST** /Inventory/Transfer/{transferID}/AddItems | Create Add Items to a Transfer
*InventoryInventoryTransferTransferItemsApi* | [**inventoryTransferTransferIDDeleteItemsPost**](docs/Api/InventoryInventoryTransferTransferItemsApi.md#inventorytransfertransferiddeleteitemspost) | **POST** /Inventory/Transfer/{transferID}/DeleteItems | Create Delete TransferItems
*InventoryInventoryTransferTransferItemsApi* | [**inventoryTransferTransferIDTransferItemsGet**](docs/Api/InventoryInventoryTransferTransferItemsApi.md#inventorytransfertransferidtransferitemsget) | **GET** /Inventory/Transfer/{transferID}/TransferItems | Get TransfersItems on a Transfer list
*InventoryInventoryTransferTransferItemsApi* | [**inventoryTransferTransferIDTransferItemsTransferItemIDGet**](docs/Api/InventoryInventoryTransferTransferItemsApi.md#inventorytransfertransferidtransferitemstransferitemidget) | **GET** /Inventory/Transfer/{transferID}/TransferItems/{transferItemID} | Get TransferItem by ID
*InventoryInventoryTransferTransferItemsApi* | [**inventoryTransferTransferIDUpdateItemsPost**](docs/Api/InventoryInventoryTransferTransferItemsApi.md#inventorytransfertransferidupdateitemspost) | **POST** /Inventory/Transfer/{transferID}/UpdateItems | Create Update TransferItems
*ItemItemApi* | [**itemGet**](docs/Api/ItemItemApi.md#itemget) | **GET** /Item | Get Items list
*ItemItemApi* | [**itemItemIDDelete**](docs/Api/ItemItemApi.md#itemitemiddelete) | **DELETE** /Item/{itemID} | Delete Item
*ItemItemApi* | [**itemItemIDGet**](docs/Api/ItemItemApi.md#itemitemidget) | **GET** /Item/{itemID} | Get Item by ID
*ItemItemApi* | [**itemItemIDPut**](docs/Api/ItemItemApi.md#itemitemidput) | **PUT** /Item/{itemID} | Update Item
*ItemItemApi* | [**itemPost**](docs/Api/ItemItemApi.md#itempost) | **POST** /Item | Create Item
*ItemItemAttributeSetApi* | [**itemAttributeSetGet**](docs/Api/ItemItemAttributeSetApi.md#itemattributesetget) | **GET** /ItemAttributeSet | Get ItemAttributeSet list
*ItemItemAttributeSetApi* | [**itemAttributeSetItemAttributeSetIDGet**](docs/Api/ItemItemAttributeSetApi.md#itemattributesetitemattributesetidget) | **GET** /ItemAttributeSet/{itemAttributeSetID} | Get ItemAttributeSet by ID
*ItemItemCustomFieldApi* | [**itemCustomFieldCustomFieldIDDelete**](docs/Api/ItemItemCustomFieldApi.md#itemcustomfieldcustomfieldiddelete) | **DELETE** /Item/CustomField/{customFieldID} | Delete Item CustomField
*ItemItemCustomFieldApi* | [**itemCustomFieldCustomFieldIDGet**](docs/Api/ItemItemCustomFieldApi.md#itemcustomfieldcustomfieldidget) | **GET** /Item/CustomField/{customFieldID} | Get Item CustomField by ID
*ItemItemCustomFieldApi* | [**itemCustomFieldCustomFieldIDPut**](docs/Api/ItemItemCustomFieldApi.md#itemcustomfieldcustomfieldidput) | **PUT** /Item/CustomField/{customFieldID} | Update Item CustomField
*ItemItemCustomFieldApi* | [**itemCustomFieldGet**](docs/Api/ItemItemCustomFieldApi.md#itemcustomfieldget) | **GET** /Item/CustomField | Get Item CustomFields list
*ItemItemCustomFieldApi* | [**itemCustomFieldPost**](docs/Api/ItemItemCustomFieldApi.md#itemcustomfieldpost) | **POST** /Item/CustomField | Create Item CustomField
*ItemItemCustomFieldCustomFieldChoiceApi* | [**itemCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete**](docs/Api/ItemItemCustomFieldCustomFieldChoiceApi.md#itemcustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceiddelete) | **DELETE** /Item/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Delete Item CustomField CustomFieldChoice
*ItemItemCustomFieldCustomFieldChoiceApi* | [**itemCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet**](docs/Api/ItemItemCustomFieldCustomFieldChoiceApi.md#itemcustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceidget) | **GET** /Item/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Get CustomFieldChoice by ID
*ItemItemCustomFieldCustomFieldChoiceApi* | [**itemCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut**](docs/Api/ItemItemCustomFieldCustomFieldChoiceApi.md#itemcustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceidput) | **PUT** /Item/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Update Item CustomField CustomFieldChoice
*ItemItemCustomFieldCustomFieldChoiceApi* | [**itemCustomFieldCustomFieldIDCustomFieldChoiceGet**](docs/Api/ItemItemCustomFieldCustomFieldChoiceApi.md#itemcustomfieldcustomfieldidcustomfieldchoiceget) | **GET** /Item/CustomField/{customFieldID}/CustomFieldChoice | Get CustomFieldChoice list
*ItemItemCustomFieldCustomFieldChoiceApi* | [**itemCustomFieldCustomFieldIDCustomFieldChoicePost**](docs/Api/ItemItemCustomFieldCustomFieldChoiceApi.md#itemcustomfieldcustomfieldidcustomfieldchoicepost) | **POST** /Item/CustomField/{customFieldID}/CustomFieldChoice | Create Item CustomField CustomFieldChoice
*ItemItemMatrixApi* | [**itemMatrixGet**](docs/Api/ItemItemMatrixApi.md#itemmatrixget) | **GET** /ItemMatrix | Get ItemMatrix list
*ItemItemMatrixApi* | [**itemMatrixItemMatrixIDDelete**](docs/Api/ItemItemMatrixApi.md#itemmatrixitemmatrixiddelete) | **DELETE** /ItemMatrix/{itemMatrixID} | Delete ItemMatrix
*ItemItemMatrixApi* | [**itemMatrixItemMatrixIDGet**](docs/Api/ItemItemMatrixApi.md#itemmatrixitemmatrixidget) | **GET** /ItemMatrix/{itemMatrixID} | Get ItemMatrix by ID
*ItemItemMatrixApi* | [**itemMatrixItemMatrixIDPut**](docs/Api/ItemItemMatrixApi.md#itemmatrixitemmatrixidput) | **PUT** /ItemMatrix/{itemMatrixID} | Update ItemMatrix
*ItemItemMatrixApi* | [**itemMatrixPost**](docs/Api/ItemItemMatrixApi.md#itemmatrixpost) | **POST** /ItemMatrix | Create ItemMatrix
*ItemItemShopApi* | [**itemShopGet**](docs/Api/ItemItemShopApi.md#itemshopget) | **GET** /ItemShop | Get ItemShop list
*ItemItemShopApi* | [**itemShopItemShopIDGet**](docs/Api/ItemItemShopApi.md#itemshopitemshopidget) | **GET** /ItemShop/{itemShopID} | Get ItemShop by ID
*ItemItemShopApi* | [**itemShopItemShopIDPut**](docs/Api/ItemItemShopApi.md#itemshopitemshopidput) | **PUT** /ItemShop/{itemShopID} | Update ItemShop
*ManufacturerApi* | [**manufacturerGet**](docs/Api/ManufacturerApi.md#manufacturerget) | **GET** /Manufacturer | Get Manufacturer list
*ManufacturerApi* | [**manufacturerManufacturerIDGet**](docs/Api/ManufacturerApi.md#manufacturermanufactureridget) | **GET** /Manufacturer/{manufacturerID} | Get Manufacturer by ID
*ManufacturerApi* | [**manufacturerManufacturerIDPut**](docs/Api/ManufacturerApi.md#manufacturermanufactureridput) | **PUT** /Manufacturer/{manufacturerID} | Update Manufacturer
*ManufacturerApi* | [**manufacturerPost**](docs/Api/ManufacturerApi.md#manufacturerpost) | **POST** /Manufacturer | Create Manufacturer
*OptionApi* | [**optionGet**](docs/Api/OptionApi.md#optionget) | **GET** /Option | Option
*OrderOrderApi* | [**orderGet**](docs/Api/OrderOrderApi.md#orderget) | **GET** /Order | Get Order list
*OrderOrderApi* | [**orderOrderIDDelete**](docs/Api/OrderOrderApi.md#orderorderiddelete) | **DELETE** /Order/{orderID} | Delete Order
*OrderOrderApi* | [**orderOrderIDGet**](docs/Api/OrderOrderApi.md#orderorderidget) | **GET** /Order/{orderID} | Get Order by ID
*OrderOrderApi* | [**orderOrderIDPut**](docs/Api/OrderOrderApi.md#orderorderidput) | **PUT** /Order/{orderID} | Update Order
*OrderOrderApi* | [**orderPost**](docs/Api/OrderOrderApi.md#orderpost) | **POST** /Order | Create Order
*OrderOrderCustomFieldApi* | [**orderCustomFieldCustomFieldIDDelete**](docs/Api/OrderOrderCustomFieldApi.md#ordercustomfieldcustomfieldiddelete) | **DELETE** /Order/CustomField/{customFieldID} | Delete Order.CustomField
*OrderOrderCustomFieldApi* | [**orderCustomFieldCustomFieldIDGet**](docs/Api/OrderOrderCustomFieldApi.md#ordercustomfieldcustomfieldidget) | **GET** /Order/CustomField/{customFieldID} | Get Order.CustomField by ID
*OrderOrderCustomFieldApi* | [**orderCustomFieldCustomFieldIDPut**](docs/Api/OrderOrderCustomFieldApi.md#ordercustomfieldcustomfieldidput) | **PUT** /Order/CustomField/{customFieldID} | Update Order.CustomField
*OrderOrderCustomFieldApi* | [**orderCustomFieldGet**](docs/Api/OrderOrderCustomFieldApi.md#ordercustomfieldget) | **GET** /Order/CustomField | Get Order.CustomField list
*OrderOrderCustomFieldApi* | [**orderCustomFieldPost**](docs/Api/OrderOrderCustomFieldApi.md#ordercustomfieldpost) | **POST** /Order/CustomField | Create Order.CustomField
*OrderOrderCustomFieldCustomFieldChoiceApi* | [**orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDDelete**](docs/Api/OrderOrderCustomFieldCustomFieldChoiceApi.md#ordercustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceiddelete) | **DELETE** /Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Delete Order.CustomField.CustomFieldChoice
*OrderOrderCustomFieldCustomFieldChoiceApi* | [**orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDGet**](docs/Api/OrderOrderCustomFieldCustomFieldChoiceApi.md#ordercustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceidget) | **GET** /Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Get Order.CustomField.CustomFieldChoice by ID
*OrderOrderCustomFieldCustomFieldChoiceApi* | [**orderCustomFieldCustomFieldIDCustomFieldChoiceCustomFieldChoiceIDPut**](docs/Api/OrderOrderCustomFieldCustomFieldChoiceApi.md#ordercustomfieldcustomfieldidcustomfieldchoicecustomfieldchoiceidput) | **PUT** /Order/CustomField/{customFieldID}/CustomFieldChoice/{customFieldChoiceID} | Update Order.CustomField.CustomFieldChoice
*OrderOrderCustomFieldCustomFieldChoiceApi* | [**orderCustomFieldCustomFieldIDCustomFieldChoiceGet**](docs/Api/OrderOrderCustomFieldCustomFieldChoiceApi.md#ordercustomfieldcustomfieldidcustomfieldchoiceget) | **GET** /Order/CustomField/{customFieldID}/CustomFieldChoice | Get Order.CustomField.CustomFieldChoice list
*OrderOrderCustomFieldCustomFieldChoiceApi* | [**orderCustomFieldCustomFieldIDCustomFieldChoicePost**](docs/Api/OrderOrderCustomFieldCustomFieldChoiceApi.md#ordercustomfieldcustomfieldidcustomfieldchoicepost) | **POST** /Order/CustomField/{customFieldID}/CustomFieldChoice | Create Order.CustomField.CustomFieldChoice
*OrderOrderLineApi* | [**orderLineGet**](docs/Api/OrderOrderLineApi.md#orderlineget) | **GET** /OrderLine | Get OrderLine list
*OrderOrderLineApi* | [**orderLineOrderLineIDDelete**](docs/Api/OrderOrderLineApi.md#orderlineorderlineiddelete) | **DELETE** /OrderLine/{orderLineID} | Delete OrderLine
*OrderOrderLineApi* | [**orderLineOrderLineIDGet**](docs/Api/OrderOrderLineApi.md#orderlineorderlineidget) | **GET** /OrderLine/{orderLineID} | Get OrderLine by ID
*OrderOrderLineApi* | [**orderLineOrderLineIDPut**](docs/Api/OrderOrderLineApi.md#orderlineorderlineidput) | **PUT** /OrderLine/{orderLineID} | Update OrderLine
*OrderOrderLineApi* | [**orderLinePost**](docs/Api/OrderOrderLineApi.md#orderlinepost) | **POST** /OrderLine | Create OrderLine
*PaymentTypeApi* | [**paymentTypeGet**](docs/Api/PaymentTypeApi.md#paymenttypeget) | **GET** /PaymentType | Get PaymentType list
*PaymentTypeApi* | [**paymentTypePaymentTypeIDDelete**](docs/Api/PaymentTypeApi.md#paymenttypepaymenttypeiddelete) | **DELETE** /PaymentType/{paymentTypeID} | Delete PaymentType
*PaymentTypeApi* | [**paymentTypePaymentTypeIDGet**](docs/Api/PaymentTypeApi.md#paymenttypepaymenttypeidget) | **GET** /PaymentType/{paymentTypeID} | Get PaymentType by ID
*PaymentTypeApi* | [**paymentTypePaymentTypeIDPut**](docs/Api/PaymentTypeApi.md#paymenttypepaymenttypeidput) | **PUT** /PaymentType/{paymentTypeID} | Update PaymentType
*PaymentTypeApi* | [**paymentTypePost**](docs/Api/PaymentTypeApi.md#paymenttypepost) | **POST** /PaymentType | Create PaymentType
*PriceLevelApi* | [**priceLevelGet**](docs/Api/PriceLevelApi.md#pricelevelget) | **GET** /PriceLevel | Get PriceLevel list
*PriceLevelApi* | [**priceLevelPriceLevelIDGet**](docs/Api/PriceLevelApi.md#pricelevelpricelevelidget) | **GET** /PriceLevel/{priceLevelID} | Get PriceLevel by ID
*PriceLevelApi* | [**priceLevelPriceLevelIDPut**](docs/Api/PriceLevelApi.md#pricelevelpricelevelidput) | **PUT** /PriceLevel/{priceLevelID} | Update PriceLevel
*QuoteApi* | [**quoteGet**](docs/Api/QuoteApi.md#quoteget) | **GET** /Quote | Get Quote list
*QuoteApi* | [**quotePost**](docs/Api/QuoteApi.md#quotepost) | **POST** /Quote | Create Quote
*QuoteApi* | [**quoteQuoteIDDelete**](docs/Api/QuoteApi.md#quotequoteiddelete) | **DELETE** /Quote/{quoteID} | Delete Quote
*QuoteApi* | [**quoteQuoteIDGet**](docs/Api/QuoteApi.md#quotequoteidget) | **GET** /Quote/{quoteID} | Get Quote by ID
*QuoteApi* | [**quoteQuoteIDPut**](docs/Api/QuoteApi.md#quotequoteidput) | **PUT** /Quote/{quoteID} | Update Quote
*RegisterRegisterApi* | [**registerGet**](docs/Api/RegisterRegisterApi.md#registerget) | **GET** /Register | Get Register list
*RegisterRegisterApi* | [**registerRegisterIDGet**](docs/Api/RegisterRegisterApi.md#registerregisteridget) | **GET** /Register/{registerID} | Get Register by ID
*RegisterRegisterCalculatedApi* | [**registerRegisterIDCalculatedGet**](docs/Api/RegisterRegisterCalculatedApi.md#registerregisteridcalculatedget) | **GET** /Register/{registerID}/calculated | Register.Calculated
*RegisterRegisterCloseApi* | [**registerRegisterIDClosePost**](docs/Api/RegisterRegisterCloseApi.md#registerregisteridclosepost) | **POST** /Register/{registerID}/close | Create Register.Close
*RegisterRegisterCountApi* | [**registerCountGet**](docs/Api/RegisterRegisterCountApi.md#registercountget) | **GET** /RegisterCount | Get RegisterCount list
*RegisterRegisterCountApi* | [**registerCountRegisterCountIDGet**](docs/Api/RegisterRegisterCountApi.md#registercountregistercountidget) | **GET** /RegisterCount/{registerCountID} | Get RegisterCount by ID
*RegisterRegisterCountAmountApi* | [**registerCountAmountGet**](docs/Api/RegisterRegisterCountAmountApi.md#registercountamountget) | **GET** /RegisterCountAmount | Get RegisterCountAmount list
*RegisterRegisterCountAmountApi* | [**registerCountAmountRegisterCountAmountIDGet**](docs/Api/RegisterRegisterCountAmountApi.md#registercountamountregistercountamountidget) | **GET** /RegisterCountAmount/{registerCountAmountID} | Get RegisterCountAmount by ID
*RegisterRegisterOpenApi* | [**registerRegisterIDOpenPost**](docs/Api/RegisterRegisterOpenApi.md#registerregisteridopenpost) | **POST** /Register/{registerID}/open | Create Register.Open
*RegisterRegisterWithdrawApi* | [**registerWithdrawGet**](docs/Api/RegisterRegisterWithdrawApi.md#registerwithdrawget) | **GET** /RegisterWithdraw | Get RegisterWithdraw list
*RegisterRegisterWithdrawApi* | [**registerWithdrawPost**](docs/Api/RegisterRegisterWithdrawApi.md#registerwithdrawpost) | **POST** /RegisterWithdraw | Create RegisterWithdraw
*RegisterRegisterWithdrawApi* | [**registerWithdrawRegisterWithdrawIDGet**](docs/Api/RegisterRegisterWithdrawApi.md#registerwithdrawregisterwithdrawidget) | **GET** /RegisterWithdraw/{registerWithdrawID} | Get RegisterWithdraw by ID
*ReportsApi* | [**reportsAccountingDiscountsByDayGet**](docs/Api/ReportsApi.md#reportsaccountingdiscountsbydayget) | **GET** /Reports/Accounting/DiscountsByDay | Reports.Accounting.DiscountsByDay
*ReportsApi* | [**reportsAccountingOrdersByTaxClassGet**](docs/Api/ReportsApi.md#reportsaccountingordersbytaxclassget) | **GET** /Reports/Accounting/OrdersByTaxClass | Reports.Accounting.OrdersByTaxClass
*ReportsApi* | [**reportsAccountingPaymentsByDayGet**](docs/Api/ReportsApi.md#reportsaccountingpaymentsbydayget) | **GET** /Reports/Accounting/PaymentsByDay | Reports.Accounting.PaymentsByDay
*ReportsApi* | [**reportsAccountingTaxClassSalesByDayGet**](docs/Api/ReportsApi.md#reportsaccountingtaxclasssalesbydayget) | **GET** /Reports/Accounting/TaxClassSalesByDay | Reports.Accounting.TaxClassSalesByDay
*ReportsApi* | [**reportsAccountingTaxesByDayGet**](docs/Api/ReportsApi.md#reportsaccountingtaxesbydayget) | **GET** /Reports/Accounting/TaxesByDay | Reports.Accounting.TaxesByDay
*SaleSaleApi* | [**saleGet**](docs/Api/SaleSaleApi.md#saleget) | **GET** /Sale | Get Sale list
*SaleSaleApi* | [**salePost**](docs/Api/SaleSaleApi.md#salepost) | **POST** /Sale | Create Sale
*SaleSaleApi* | [**saleSaleIDDelete**](docs/Api/SaleSaleApi.md#salesaleiddelete) | **DELETE** /Sale/{saleID} | Delete Sale
*SaleSaleApi* | [**saleSaleIDGet**](docs/Api/SaleSaleApi.md#salesaleidget) | **GET** /Sale/{saleID} | Get Sale by ID
*SaleSaleApi* | [**saleSaleIDPut**](docs/Api/SaleSaleApi.md#salesaleidput) | **PUT** /Sale/{saleID} | Update Sale
*SaleSaleEmailReceiptApi* | [**saleSaleIDEmailReceiptPost**](docs/Api/SaleSaleEmailReceiptApi.md#salesaleidemailreceiptpost) | **POST** /Sale/{saleID}/EmailReceipt | Create Sale.EmailReceipt
*SaleSaleLineApi* | [**saleLineGet**](docs/Api/SaleSaleLineApi.md#salelineget) | **GET** /SaleLine | Get SaleLine list
*SaleSaleLineApi* | [**saleLineSaleLineIDDelete**](docs/Api/SaleSaleLineApi.md#salelinesalelineiddelete) | **DELETE** /SaleLine/{saleLineID} | Delete SaleLine
*SaleSaleLineApi* | [**saleLineSaleLineIDGet**](docs/Api/SaleSaleLineApi.md#salelinesalelineidget) | **GET** /SaleLine/{saleLineID} | Get SaleLine by ID
*SaleSaleLineApi* | [**saleLineSaleLineIDPut**](docs/Api/SaleSaleLineApi.md#salelinesalelineidput) | **PUT** /SaleLine/{saleLineID} | Update SaleLine
*SaleSalePaymentApi* | [**salePaymentGet**](docs/Api/SaleSalePaymentApi.md#salepaymentget) | **GET** /SalePayment | Get SalePayment list
*SaleSalePaymentApi* | [**salePaymentSalePaymentIDGet**](docs/Api/SaleSalePaymentApi.md#salepaymentsalepaymentidget) | **GET** /SalePayment/{salePaymentID} | Get SalePayment by ID
*SaleSalePaymentSalePaymentSignatureApi* | [**salePaymentSalePaymentIDSalePaymentSignaturePost**](docs/Api/SaleSalePaymentSalePaymentSignatureApi.md#salepaymentsalepaymentidsalepaymentsignaturepost) | **POST** /SalePayment/{salePaymentID}/SalePaymentSignature | Create SalePayment.SalePaymentSignature
*SaleSalePaymentSalePaymentSignatureApi* | [**salePaymentSignatureGet**](docs/Api/SaleSalePaymentSalePaymentSignatureApi.md#salepaymentsignatureget) | **GET** /SalePaymentSignature | Get SalePayment.SalePaymentSignature list
*SaleSalePaymentSalePaymentSignatureApi* | [**salePaymentSignatureSalePaymentSignatureIDGet**](docs/Api/SaleSalePaymentSalePaymentSignatureApi.md#salepaymentsignaturesalepaymentsignatureidget) | **GET** /SalePaymentSignature/{salePaymentSignatureID} | Get SalePayment.SalePaymentSignature by ID
*SaleSaleRefundApi* | [**saleSaleIDRefundPost**](docs/Api/SaleSaleRefundApi.md#salesaleidrefundpost) | **POST** /Sale/{saleID}/refund | Create Sale.Refund
*SaleSaleSaleLineApi* | [**saleSaleIDSaleLineGet**](docs/Api/SaleSaleSaleLineApi.md#salesaleidsalelineget) | **GET** /Sale/{saleID}/SaleLine | Get Sale.SaleLine list
*SaleSaleSaleLineApi* | [**saleSaleIDSaleLinePost**](docs/Api/SaleSaleSaleLineApi.md#salesaleidsalelinepost) | **POST** /Sale/{saleID}/SaleLine | Create Sale.SaleLine
*SaleSaleSaleLineApi* | [**saleSaleIDSaleLineSaleLineIDDelete**](docs/Api/SaleSaleSaleLineApi.md#salesaleidsalelinesalelineiddelete) | **DELETE** /Sale/{saleID}/SaleLine/{saleLineID} | Delete Sale.SaleLine
*SaleSaleSaleLineApi* | [**saleSaleIDSaleLineSaleLineIDGet**](docs/Api/SaleSaleSaleLineApi.md#salesaleidsalelinesalelineidget) | **GET** /Sale/{saleID}/SaleLine/{saleLineID} | Get Sale.SaleLine by ID
*SaleSaleSaleLineApi* | [**saleSaleIDSaleLineSaleLineIDPut**](docs/Api/SaleSaleSaleLineApi.md#salesaleidsalelinesalelineidput) | **PUT** /Sale/{saleID}/SaleLine/{saleLineID} | Update Sale.SaleLine
*SaleSaleVoidApi* | [**saleVoidGet**](docs/Api/SaleSaleVoidApi.md#salevoidget) | **GET** /SaleVoid | Get SaleVoid list
*SaleSaleVoidApi* | [**saleVoidSaleVoidIDGet**](docs/Api/SaleSaleVoidApi.md#salevoidsalevoididget) | **GET** /SaleVoid/{saleVoidID} | Get SaleVoid by ID
*SeasonApi* | [**seasonDelete**](docs/Api/SeasonApi.md#seasondelete) | **DELETE** /Season | Delete Season
*SeasonApi* | [**seasonGet**](docs/Api/SeasonApi.md#seasonget) | **GET** /Season | Get Season list
*SeasonApi* | [**seasonPost**](docs/Api/SeasonApi.md#seasonpost) | **POST** /Season | Create Season
*SeasonApi* | [**seasonSeasonIDGet**](docs/Api/SeasonApi.md#seasonseasonidget) | **GET** /Season/{seasonID} | Get Season by ID
*SeasonApi* | [**seasonSeasonIDPut**](docs/Api/SeasonApi.md#seasonseasonidput) | **PUT** /Season/{seasonID} | Update Season
*SerializedApi* | [**serializedDelete**](docs/Api/SerializedApi.md#serializeddelete) | **DELETE** /Serialized | Delete Serialized
*SerializedApi* | [**serializedGet**](docs/Api/SerializedApi.md#serializedget) | **GET** /Serialized | Get Serialized list
*SerializedApi* | [**serializedPost**](docs/Api/SerializedApi.md#serializedpost) | **POST** /Serialized | Create Serialized
*SerializedApi* | [**serializedSerializedIDGet**](docs/Api/SerializedApi.md#serializedserializedidget) | **GET** /Serialized/{serializedID} | Get Serialized by ID
*SerializedApi* | [**serializedSerializedIDPut**](docs/Api/SerializedApi.md#serializedserializedidput) | **PUT** /Serialized/{serializedID} | Update Serialized
*ShipToApi* | [**shipToGet**](docs/Api/ShipToApi.md#shiptoget) | **GET** /ShipTo | Get ShipTo list
*ShipToApi* | [**shipToShipToIDGet**](docs/Api/ShipToApi.md#shiptoshiptoidget) | **GET** /ShipTo/{shipToID} | Get ShipTo by ID
*ShopApi* | [**shopGet**](docs/Api/ShopApi.md#shopget) | **GET** /Shop | Get Shop list
*ShopApi* | [**shopPost**](docs/Api/ShopApi.md#shoppost) | **POST** /Shop | Create Shop
*ShopApi* | [**shopShopIDGet**](docs/Api/ShopApi.md#shopshopidget) | **GET** /Shop/{shopID} | Get Shop by ID
*ShopApi* | [**shopShopIDPut**](docs/Api/ShopApi.md#shopshopidput) | **PUT** /Shop/{shopID} | Update Shop
*SpecialOrderApi* | [**specialOrderGet**](docs/Api/SpecialOrderApi.md#specialorderget) | **GET** /SpecialOrder | Get SpecialOrder list
*SpecialOrderApi* | [**specialOrderSpecialOrderIDGet**](docs/Api/SpecialOrderApi.md#specialorderspecialorderidget) | **GET** /SpecialOrder/{specialOrderID} | Get SpecialOrder by ID
*TagApi* | [**tagDelete**](docs/Api/TagApi.md#tagdelete) | **DELETE** /Tag | Delete Tag
*TagApi* | [**tagGet**](docs/Api/TagApi.md#tagget) | **GET** /Tag | Get Tag list
*TagApi* | [**tagPost**](docs/Api/TagApi.md#tagpost) | **POST** /Tag | Create Tag
*TagApi* | [**tagTagIDGet**](docs/Api/TagApi.md#tagtagidget) | **GET** /Tag/{tagID} | Get Tag by ID
*TagApi* | [**tagTagIDPut**](docs/Api/TagApi.md#tagtagidput) | **PUT** /Tag/{tagID} | Update Tag
*TagGroupApi* | [**tagGroupGet**](docs/Api/TagGroupApi.md#taggroupget) | **GET** /TagGroup | TagGroup
*TaxTaxCategoryApi* | [**taxCategoryDelete**](docs/Api/TaxTaxCategoryApi.md#taxcategorydelete) | **DELETE** /TaxCategory | Delete TaxCategory
*TaxTaxCategoryApi* | [**taxCategoryGet**](docs/Api/TaxTaxCategoryApi.md#taxcategoryget) | **GET** /TaxCategory | Get TaxCategory list
*TaxTaxCategoryApi* | [**taxCategoryPost**](docs/Api/TaxTaxCategoryApi.md#taxcategorypost) | **POST** /TaxCategory | Create TaxCategory
*TaxTaxCategoryApi* | [**taxCategoryTaxCategoryIDGet**](docs/Api/TaxTaxCategoryApi.md#taxcategorytaxcategoryidget) | **GET** /TaxCategory/{taxCategoryID} | Get TaxCategory by ID
*TaxTaxCategoryApi* | [**taxCategoryTaxCategoryIDPut**](docs/Api/TaxTaxCategoryApi.md#taxcategorytaxcategoryidput) | **PUT** /TaxCategory/{taxCategoryID} | Update TaxCategory
*TaxTaxCategoryClassApi* | [**taxCategoryClassDelete**](docs/Api/TaxTaxCategoryClassApi.md#taxcategoryclassdelete) | **DELETE** /TaxCategoryClass | Delete TaxCategoryClass
*TaxTaxCategoryClassApi* | [**taxCategoryClassGet**](docs/Api/TaxTaxCategoryClassApi.md#taxcategoryclassget) | **GET** /TaxCategoryClass | Get TaxCategoryClass list
*TaxTaxCategoryClassApi* | [**taxCategoryClassTaxCategoryClassIDGet**](docs/Api/TaxTaxCategoryClassApi.md#taxcategoryclasstaxcategoryclassidget) | **GET** /TaxCategoryClass/{taxCategoryClassID} | Get TaxCategoryClass by ID
*TaxTaxClassApi* | [**taxClassDelete**](docs/Api/TaxTaxClassApi.md#taxclassdelete) | **DELETE** /TaxClass | Delete TaxClass
*TaxTaxClassApi* | [**taxClassGet**](docs/Api/TaxTaxClassApi.md#taxclassget) | **GET** /TaxClass | Get TaxClass list
*TaxTaxClassApi* | [**taxClassPost**](docs/Api/TaxTaxClassApi.md#taxclasspost) | **POST** /TaxClass | Create TaxClass
*TaxTaxClassApi* | [**taxClassTaxClassIDGet**](docs/Api/TaxTaxClassApi.md#taxclasstaxclassidget) | **GET** /TaxClass/{taxClassID} | Get TaxClass by ID
*TaxTaxClassApi* | [**taxClassTaxClassIDPut**](docs/Api/TaxTaxClassApi.md#taxclasstaxclassidput) | **PUT** /TaxClass/{taxClassID} | Update TaxClass
*TransferApi* | [**transferGet**](docs/Api/TransferApi.md#transferget) | **GET** /Transfer | Get Transfer list
*TransferApi* | [**transferTransferIDGet**](docs/Api/TransferApi.md#transfertransferidget) | **GET** /Transfer/{transferID} | Get Transfer by ID
*TransferItemApi* | [**transferItemGet**](docs/Api/TransferItemApi.md#transferitemget) | **GET** /TransferItem | Get TransferItem list
*TransferItemApi* | [**transferItemTransferItemIDGet**](docs/Api/TransferItemApi.md#transferitemtransferitemidget) | **GET** /TransferItem/{transferItemID} | Get TransferItem by ID
*VendorApi* | [**vendorDelete**](docs/Api/VendorApi.md#vendordelete) | **DELETE** /Vendor | Delete Vendor
*VendorApi* | [**vendorGet**](docs/Api/VendorApi.md#vendorget) | **GET** /Vendor | Get Vendor list
*VendorApi* | [**vendorPost**](docs/Api/VendorApi.md#vendorpost) | **POST** /Vendor | Create Vendor
*VendorApi* | [**vendorVendorIDGet**](docs/Api/VendorApi.md#vendorvendoridget) | **GET** /Vendor/{vendorID} | Get Vendor by ID
*VendorApi* | [**vendorVendorIDPut**](docs/Api/VendorApi.md#vendorvendoridput) | **PUT** /Vendor/{vendorID} | Update Vendor
*WorkorderWorkorderApi* | [**workorderGet**](docs/Api/WorkorderWorkorderApi.md#workorderget) | **GET** /Workorder | Get Workorder list
*WorkorderWorkorderApi* | [**workorderPost**](docs/Api/WorkorderWorkorderApi.md#workorderpost) | **POST** /Workorder | Create Workorder
*WorkorderWorkorderApi* | [**workorderWorkorderIDDelete**](docs/Api/WorkorderWorkorderApi.md#workorderworkorderiddelete) | **DELETE** /Workorder/{workorderID} | Delete Workorder
*WorkorderWorkorderApi* | [**workorderWorkorderIDGet**](docs/Api/WorkorderWorkorderApi.md#workorderworkorderidget) | **GET** /Workorder/{workorderID} | Get Workorder by ID
*WorkorderWorkorderApi* | [**workorderWorkorderIDPut**](docs/Api/WorkorderWorkorderApi.md#workorderworkorderidput) | **PUT** /Workorder/{workorderID} | Update Workorder
*WorkorderWorkorderCheckoutApi* | [**workorderWorkorderIDCheckoutPost**](docs/Api/WorkorderWorkorderCheckoutApi.md#workorderworkorderidcheckoutpost) | **POST** /Workorder/{workorderID}/Checkout | Create Workorder.Checkout
*WorkorderWorkorderStatusApi* | [**workorderStatusGet**](docs/Api/WorkorderWorkorderStatusApi.md#workorderstatusget) | **GET** /WorkorderStatus | Get WorkorderStatus list
*WorkorderWorkorderStatusApi* | [**workorderStatusWorkorderStatusIDGet**](docs/Api/WorkorderWorkorderStatusApi.md#workorderstatusworkorderstatusidget) | **GET** /WorkorderStatus/{workorderStatusID} | Get WorkorderStatus by ID
*WorkorderWorkorderWorkorderImageApi* | [**workorderWorkorderIDWorkorderImageGet**](docs/Api/WorkorderWorkorderWorkorderImageApi.md#workorderworkorderidworkorderimageget) | **GET** /Workorder/{workorderID}/WorkorderImage | Get Workorder.WorkorderImage list
*WorkorderWorkorderWorkorderImageApi* | [**workorderWorkorderIDWorkorderImagePost**](docs/Api/WorkorderWorkorderWorkorderImageApi.md#workorderworkorderidworkorderimagepost) | **POST** /Workorder/{workorderID}/WorkorderImage | Create Workorder.WorkorderImage
*WorkorderWorkorderWorkorderImageApi* | [**workorderWorkorderIDWorkorderImageWorkorderImageIDDelete**](docs/Api/WorkorderWorkorderWorkorderImageApi.md#workorderworkorderidworkorderimageworkorderimageiddelete) | **DELETE** /Workorder/{workorderID}/WorkorderImage/{workorderImageID} | Delete Workorder.WorkorderImage
*WorkorderWorkorderWorkorderImageApi* | [**workorderWorkorderIDWorkorderImageWorkorderImageIDGet**](docs/Api/WorkorderWorkorderWorkorderImageApi.md#workorderworkorderidworkorderimageworkorderimageidget) | **GET** /Workorder/{workorderID}/WorkorderImage/{workorderImageID} | Get Workorder.WorkorderImage by ID
*WorkorderWorkorderWorkorderImageApi* | [**workorderWorkorderIDWorkorderImageWorkorderImageIDPut**](docs/Api/WorkorderWorkorderWorkorderImageApi.md#workorderworkorderidworkorderimageworkorderimageidput) | **PUT** /Workorder/{workorderID}/WorkorderImage/{workorderImageID} | Update Workorder.WorkorderImage
*WorkorderWorkorderWorkorderItemApi* | [**workorderWorkorderIDWorkorderItemGet**](docs/Api/WorkorderWorkorderWorkorderItemApi.md#workorderworkorderidworkorderitemget) | **GET** /Workorder/{workorderID}/WorkorderItem | Get Workorder.WorkorderItem list
*WorkorderWorkorderWorkorderItemApi* | [**workorderWorkorderIDWorkorderItemPost**](docs/Api/WorkorderWorkorderWorkorderItemApi.md#workorderworkorderidworkorderitempost) | **POST** /Workorder/{workorderID}/WorkorderItem | Create Workorder.WorkorderItem
*WorkorderWorkorderWorkorderItemApi* | [**workorderWorkorderIDWorkorderItemWorkorderItemIDDelete**](docs/Api/WorkorderWorkorderWorkorderItemApi.md#workorderworkorderidworkorderitemworkorderitemiddelete) | **DELETE** /Workorder/{workorderID}/WorkorderItem/{workorderItemID} | Delete Workorder.WorkorderItem
*WorkorderWorkorderWorkorderItemApi* | [**workorderWorkorderIDWorkorderItemWorkorderItemIDGet**](docs/Api/WorkorderWorkorderWorkorderItemApi.md#workorderworkorderidworkorderitemworkorderitemidget) | **GET** /Workorder/{workorderID}/WorkorderItem/{workorderItemID} | Get Workorder.WorkorderItem by ID
*WorkorderWorkorderWorkorderItemApi* | [**workorderWorkorderIDWorkorderItemWorkorderItemIDPut**](docs/Api/WorkorderWorkorderWorkorderItemApi.md#workorderworkorderidworkorderitemworkorderitemidput) | **PUT** /Workorder/{workorderID}/WorkorderItem/{workorderItemID} | Update Workorder.WorkorderItem
*WorkorderWorkorderWorkorderLineApi* | [**workorderWorkorderIDWorkorderLineGet**](docs/Api/WorkorderWorkorderWorkorderLineApi.md#workorderworkorderidworkorderlineget) | **GET** /Workorder/{workorderID}/WorkorderLine | Get Workorder.WorkorderLine list
*WorkorderWorkorderWorkorderLineApi* | [**workorderWorkorderIDWorkorderLinePost**](docs/Api/WorkorderWorkorderWorkorderLineApi.md#workorderworkorderidworkorderlinepost) | **POST** /Workorder/{workorderID}/WorkorderLine | Create Workorder.WorkorderLine
*WorkorderWorkorderWorkorderLineApi* | [**workorderWorkorderIDWorkorderLineWorkorderLineIDDelete**](docs/Api/WorkorderWorkorderWorkorderLineApi.md#workorderworkorderidworkorderlineworkorderlineiddelete) | **DELETE** /Workorder/{workorderID}/WorkorderLine/{workorderLineID} | Delete Workorder.WorkorderLine
*WorkorderWorkorderWorkorderLineApi* | [**workorderWorkorderIDWorkorderLineWorkorderLineIDGet**](docs/Api/WorkorderWorkorderWorkorderLineApi.md#workorderworkorderidworkorderlineworkorderlineidget) | **GET** /Workorder/{workorderID}/WorkorderLine/{workorderLineID} | Get Workorder.WorkorderLine by ID
*WorkorderWorkorderWorkorderLineApi* | [**workorderWorkorderIDWorkorderLineWorkorderLineIDPut**](docs/Api/WorkorderWorkorderWorkorderLineApi.md#workorderworkorderidworkorderlineworkorderlineidput) | **PUT** /Workorder/{workorderID}/WorkorderLine/{workorderLineID} | Update Workorder.WorkorderLine

## Models

- [Account](docs/Model/Account.md)
- [AccountAttributes](docs/Model/AccountAttributes.md)
- [AccountListResponse](docs/Model/AccountListResponse.md)
- [AccountPurchasingCurrencies](docs/Model/AccountPurchasingCurrencies.md)
- [AccountResponse](docs/Model/AccountResponse.md)
- [CCCharge](docs/Model/CCCharge.md)
- [Category](docs/Model/Category.md)
- [CategoryListResponse](docs/Model/CategoryListResponse.md)
- [CategoryPost400Response](docs/Model/CategoryPost400Response.md)
- [CategoryResponse](docs/Model/CategoryResponse.md)
- [Contact](docs/Model/Contact.md)
- [ContactAddresses](docs/Model/ContactAddresses.md)
- [ContactEmailsInner](docs/Model/ContactEmailsInner.md)
- [ContactPhonesInner](docs/Model/ContactPhonesInner.md)
- [CreditAccount](docs/Model/CreditAccount.md)
- [CreditAccountListResponse](docs/Model/CreditAccountListResponse.md)
- [CreditAccountResponse](docs/Model/CreditAccountResponse.md)
- [Currency](docs/Model/Currency.md)
- [CustomFieldValue](docs/Model/CustomFieldValue.md)
- [Customer](docs/Model/Customer.md)
- [CustomerCreateRequest](docs/Model/CustomerCreateRequest.md)
- [CustomerListResponse](docs/Model/CustomerListResponse.md)
- [CustomerResponse](docs/Model/CustomerResponse.md)
- [CustomerType](docs/Model/CustomerType.md)
- [CustomerTypeListResponse](docs/Model/CustomerTypeListResponse.md)
- [CustomerTypeResponse](docs/Model/CustomerTypeResponse.md)
- [CustomerUpdateRequest](docs/Model/CustomerUpdateRequest.md)
- [Discount](docs/Model/Discount.md)
- [DiscountCreateRequest](docs/Model/DiscountCreateRequest.md)
- [DiscountListResponse](docs/Model/DiscountListResponse.md)
- [DiscountResponse](docs/Model/DiscountResponse.md)
- [DiscountUpdateRequest](docs/Model/DiscountUpdateRequest.md)
- [Employee](docs/Model/Employee.md)
- [EmployeeCreateRequest](docs/Model/EmployeeCreateRequest.md)
- [EmployeeListResponse](docs/Model/EmployeeListResponse.md)
- [EmployeeResponse](docs/Model/EmployeeResponse.md)
- [EmployeeRole](docs/Model/EmployeeRole.md)
- [EmployeeUpdateRequest](docs/Model/EmployeeUpdateRequest.md)
- [ErrorResponse](docs/Model/ErrorResponse.md)
- [GenericResponse](docs/Model/GenericResponse.md)
- [InventoryCount](docs/Model/InventoryCount.md)
- [InventoryCountItem](docs/Model/InventoryCountItem.md)
- [InventoryCountItemListResponse](docs/Model/InventoryCountItemListResponse.md)
- [InventoryCountListResponse](docs/Model/InventoryCountListResponse.md)
- [InventoryCountReconcile](docs/Model/InventoryCountReconcile.md)
- [InventoryCountReconcileListResponse](docs/Model/InventoryCountReconcileListResponse.md)
- [InventoryCountReconcileResponse](docs/Model/InventoryCountReconcileResponse.md)
- [InventoryCountResponse](docs/Model/InventoryCountResponse.md)
- [Item](docs/Model/Item.md)
- [ItemAttributeSet](docs/Model/ItemAttributeSet.md)
- [ItemCustomFieldValues](docs/Model/ItemCustomFieldValues.md)
- [ItemItemShops](docs/Model/ItemItemShops.md)
- [ItemListResponse](docs/Model/ItemListResponse.md)
- [ItemMatrix](docs/Model/ItemMatrix.md)
- [ItemMatrixItems](docs/Model/ItemMatrixItems.md)
- [ItemMatrixListResponse](docs/Model/ItemMatrixListResponse.md)
- [ItemPrice](docs/Model/ItemPrice.md)
- [ItemPrices](docs/Model/ItemPrices.md)
- [ItemResponse](docs/Model/ItemResponse.md)
- [ItemShop](docs/Model/ItemShop.md)
- [ItemShopListResponse](docs/Model/ItemShopListResponse.md)
- [ItemShopResponse](docs/Model/ItemShopResponse.md)
- [ItemShopUpdateRequest](docs/Model/ItemShopUpdateRequest.md)
- [ItemUpdateRequest](docs/Model/ItemUpdateRequest.md)
- [Manufacturer](docs/Model/Manufacturer.md)
- [ManufacturerListResponse](docs/Model/ManufacturerListResponse.md)
- [ManufacturerResponse](docs/Model/ManufacturerResponse.md)
- [Note](docs/Model/Note.md)
- [Order](docs/Model/Order.md)
- [OrderCreateRequest](docs/Model/OrderCreateRequest.md)
- [OrderLine](docs/Model/OrderLine.md)
- [OrderLineListResponse](docs/Model/OrderLineListResponse.md)
- [OrderLineResponse](docs/Model/OrderLineResponse.md)
- [OrderListResponse](docs/Model/OrderListResponse.md)
- [OrderNote](docs/Model/OrderNote.md)
- [OrderResponse](docs/Model/OrderResponse.md)
- [OrderUpdateRequest](docs/Model/OrderUpdateRequest.md)
- [OrderVendor](docs/Model/OrderVendor.md)
- [PaginationAttributes](docs/Model/PaginationAttributes.md)
- [PaymentType](docs/Model/PaymentType.md)
- [PaymentTypeListResponse](docs/Model/PaymentTypeListResponse.md)
- [PaymentTypeResponse](docs/Model/PaymentTypeResponse.md)
- [PriceLevel](docs/Model/PriceLevel.md)
- [PriceLevelListResponse](docs/Model/PriceLevelListResponse.md)
- [PriceLevelResponse](docs/Model/PriceLevelResponse.md)
- [Quote](docs/Model/Quote.md)
- [Register](docs/Model/Register.md)
- [RegisterListResponse](docs/Model/RegisterListResponse.md)
- [RegisterResponse](docs/Model/RegisterResponse.md)
- [Sale](docs/Model/Sale.md)
- [SaleAccount](docs/Model/SaleAccount.md)
- [SaleCreateRequest](docs/Model/SaleCreateRequest.md)
- [SaleCreateRequestSaleLinesInner](docs/Model/SaleCreateRequestSaleLinesInner.md)
- [SaleLine](docs/Model/SaleLine.md)
- [SaleLineListResponse](docs/Model/SaleLineListResponse.md)
- [SaleLineResponse](docs/Model/SaleLineResponse.md)
- [SaleLineSalesAccounts](docs/Model/SaleLineSalesAccounts.md)
- [SaleLinesWrapper](docs/Model/SaleLinesWrapper.md)
- [SaleListResponse](docs/Model/SaleListResponse.md)
- [SaleNotesWrapper](docs/Model/SaleNotesWrapper.md)
- [SalePayment](docs/Model/SalePayment.md)
- [SalePaymentListResponse](docs/Model/SalePaymentListResponse.md)
- [SalePaymentResponse](docs/Model/SalePaymentResponse.md)
- [SalePaymentsWrapper](docs/Model/SalePaymentsWrapper.md)
- [SaleResponse](docs/Model/SaleResponse.md)
- [Serialized](docs/Model/Serialized.md)
- [SerializedListResponse](docs/Model/SerializedListResponse.md)
- [SerializedResponse](docs/Model/SerializedResponse.md)
- [ShipTo](docs/Model/ShipTo.md)
- [Shop](docs/Model/Shop.md)
- [ShopCreateRequest](docs/Model/ShopCreateRequest.md)
- [ShopListResponse](docs/Model/ShopListResponse.md)
- [ShopResponse](docs/Model/ShopResponse.md)
- [ShopUpdateRequest](docs/Model/ShopUpdateRequest.md)
- [SuccessResponse](docs/Model/SuccessResponse.md)
- [TaxCategory](docs/Model/TaxCategory.md)
- [TaxCategoryClass](docs/Model/TaxCategoryClass.md)
- [TaxCategoryListResponse](docs/Model/TaxCategoryListResponse.md)
- [TaxCategoryResponse](docs/Model/TaxCategoryResponse.md)
- [TaxCategoryTaxCategoryClasses](docs/Model/TaxCategoryTaxCategoryClasses.md)
- [TaxClass](docs/Model/TaxClass.md)
- [TaxClassListResponse](docs/Model/TaxClassListResponse.md)
- [TaxClassResponse](docs/Model/TaxClassResponse.md)
- [TaxClassTotal](docs/Model/TaxClassTotal.md)
- [TaxClassTotals](docs/Model/TaxClassTotals.md)
- [Transfer](docs/Model/Transfer.md)
- [TransferItem](docs/Model/TransferItem.md)
- [TransferListResponse](docs/Model/TransferListResponse.md)
- [TransferResponse](docs/Model/TransferResponse.md)
- [TransferTransferItems](docs/Model/TransferTransferItems.md)
- [Vendor](docs/Model/Vendor.md)
- [VendorCreateRequest](docs/Model/VendorCreateRequest.md)
- [VendorListResponse](docs/Model/VendorListResponse.md)
- [VendorRep](docs/Model/VendorRep.md)
- [VendorReps](docs/Model/VendorReps.md)
- [VendorResponse](docs/Model/VendorResponse.md)
- [VendorUpdateRequest](docs/Model/VendorUpdateRequest.md)
- [Workorder](docs/Model/Workorder.md)
- [WorkorderCreateRequest](docs/Model/WorkorderCreateRequest.md)
- [WorkorderItem](docs/Model/WorkorderItem.md)
- [WorkorderLine](docs/Model/WorkorderLine.md)
- [WorkorderListResponse](docs/Model/WorkorderListResponse.md)
- [WorkorderResponse](docs/Model/WorkorderResponse.md)
- [WorkorderStatus](docs/Model/WorkorderStatus.md)
- [WorkorderUpdateRequest](docs/Model/WorkorderUpdateRequest.md)
- [WorkorderWorkorderItems](docs/Model/WorkorderWorkorderItems.md)
- [WorkorderWorkorderLines](docs/Model/WorkorderWorkorderLines.md)

## Authorization

Authentication schemes defined for the API:
### BearerAuth

- **Type**: Bearer authentication (JWT)

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `3.0.0`
    - Package version: `1.0`
    - Generator version: `7.16.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
