<?php
/**
 * Copyright Talisman Innovations Ltd. (2019). All rights reserved.
 */

namespace ICRTouch;

use Graze\GuzzleHttp\JsonRpc\ClientInterface;
use Graze\GuzzleHttp\JsonRpc\Exception\RequestException;
use GuzzleHttp\Exception\ConnectException;
use InvalidArgumentException;
use Exception;

class ICRTouchApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @param ClientInterface $client
     */
    public function __construct(ClientInterface $client) {

        $this->client = $client;

    }

//      ObjectSerializer::deserialize($content, $returnType, [])

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function getStock($id, array $params = null)
    {
        return $this->send($id, 'GetStock', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function setStockLevels($id, array $params = null)
    {
        return $this->send($id, 'SetStockLevels', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function sendSale($id, array $params = null)
    {
        return $this->send($id, 'SendSale', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function setSaleStatus($id, array $params = null)
    {
        return $this->send($id, 'SetSaleStatus', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function getSaleStatus($id, array $params = null)
    {
        return $this->send($id, 'GetSaleStatus', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function getMenuCategories($id, array $params = null)
    {
        return $this->send($id, 'GetMenuCategories', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function getMenuProductsWithDetail($id, array $params = null)
    {
        return $this->send($id, 'GetMenuProductsWithDetail', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function getProductDetails($id, array $params = null)
    {
        return $this->send($id, 'GetProductDetails', $params);
    }

    /**
     * @param  mixed            $id
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    public function trackOrder($id, array $params = null)
    {
        return $this->send($id, 'TrackOrder', $params);
    }

    /**
     * @param  mixed            $id
     * @param  string           $method
     * @param  array            $params
     * @throws Exception
     * @return mixed
     */
    private function send($id, $method, array $params = null)
    {
        try {

            $result = null;

            $request = $this->client->request($id, $method, $params);

            $response = $this->client->send($request);

            $body = $response->getBody();

            $json = $body->getContents();

            $stdClass = json_decode($json);

            if (isset($stdClass->error)) {

                throw new Exception($stdClass->error->message, $stdClass->error->code);

            }

            if (isset($stdClass->result)) {

                $result = $stdClass->result;

            }

            return $result;

        } catch (RequestException $exception) {

            throw new Exception($exception->getResponse()->getRpcErrorMessage(), $exception->getResponse()->getRpcErrorCode());

        } catch (ConnectException $exception) {

            throw new Exception('Invalid host in url', 0, $exception);

        } catch (InvalidArgumentException $exception) {

            throw new Exception('Invalid path in url', 0, $exception);

        }
    }
}