<?php
/**
 * Copyright Talisman Innovations Ltd. (2019). All rights reserved.
 */

namespace ICRTouch;

use Psr\Log\LoggerInterface;
use GuzzleHttp\HandlerStack;
use ConnectorSupport\Guzzle\Handler\Logger;
use Graze\GuzzleHttp\JsonRpc\Client;

class ClientBuilder
{
    /**
     * @param string $url
     * @param null|LoggerInterface $logger
     * @return Client
     */
    public static function getClient($url, $logger = null)
    {
        $stack = HandlerStack::create();

        $logger = Logger::create($logger);
        $stack->push($logger);

        $client = Client::factory($url, ['handler' => $stack, 'headers' => ['Content-Type' => 'application/json']]);

        return $client;
    }
}