<?php
/**
 * OrderApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Exertis
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * exertis
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Exertis\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Exertis\ApiException;
use Exertis\Configuration;
use Exertis\FormDataProcessor;
use Exertis\HeaderSelector;
use Exertis\ObjectSerializer;

/**
 * OrderApi Class Doc Comment
 *
 * @category Class
 * @package  Exertis
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'billAndHold' => [
            'application/json',
        ],
        'createOrder' => [
            'application/json',
        ],
        'orderStatus' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation billAndHold
     *
     * Bill And Hold
     *
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_last page_last (optional)
     * @param  string|null $page_prev page_prev (optional)
     * @param  string|null $page_after page_after (optional)
     * @param  string|null $filter filter (optional)
     * @param  string|null $material_id material_id (optional)
     * @param  string|null $customer_ref customer_ref (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['billAndHold'] to see the possible values for this operation
     *
     * @throws \Exertis\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Exertis\Model\BillAndHoldResponse
     */
    public function billAndHold($page_size = null, $page_number = null, $page_last = null, $page_prev = null, $page_after = null, $filter = null, $material_id = null, $customer_ref = null, string $contentType = self::contentTypes['billAndHold'][0])
    {
        list($response) = $this->billAndHoldWithHttpInfo($page_size, $page_number, $page_last, $page_prev, $page_after, $filter, $material_id, $customer_ref, $contentType);
        return $response;
    }

    /**
     * Operation billAndHoldWithHttpInfo
     *
     * Bill And Hold
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  string|null $filter (optional)
     * @param  string|null $material_id (optional)
     * @param  string|null $customer_ref (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['billAndHold'] to see the possible values for this operation
     *
     * @throws \Exertis\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Exertis\Model\BillAndHoldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function billAndHoldWithHttpInfo($page_size = null, $page_number = null, $page_last = null, $page_prev = null, $page_after = null, $filter = null, $material_id = null, $customer_ref = null, string $contentType = self::contentTypes['billAndHold'][0])
    {
        $request = $this->billAndHoldRequest($page_size, $page_number, $page_last, $page_prev, $page_after, $filter, $material_id, $customer_ref, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Exertis\Model\BillAndHoldResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Exertis\Model\BillAndHoldResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Exertis\Model\BillAndHoldResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation billAndHoldAsync
     *
     * Bill And Hold
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  string|null $filter (optional)
     * @param  string|null $material_id (optional)
     * @param  string|null $customer_ref (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['billAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function billAndHoldAsync($page_size = null, $page_number = null, $page_last = null, $page_prev = null, $page_after = null, $filter = null, $material_id = null, $customer_ref = null, string $contentType = self::contentTypes['billAndHold'][0])
    {
        return $this->billAndHoldAsyncWithHttpInfo($page_size, $page_number, $page_last, $page_prev, $page_after, $filter, $material_id, $customer_ref, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation billAndHoldAsyncWithHttpInfo
     *
     * Bill And Hold
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  string|null $filter (optional)
     * @param  string|null $material_id (optional)
     * @param  string|null $customer_ref (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['billAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function billAndHoldAsyncWithHttpInfo($page_size = null, $page_number = null, $page_last = null, $page_prev = null, $page_after = null, $filter = null, $material_id = null, $customer_ref = null, string $contentType = self::contentTypes['billAndHold'][0])
    {
        $returnType = '\Exertis\Model\BillAndHoldResponse';
        $request = $this->billAndHoldRequest($page_size, $page_number, $page_last, $page_prev, $page_after, $filter, $material_id, $customer_ref, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'billAndHold'
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  string|null $filter (optional)
     * @param  string|null $material_id (optional)
     * @param  string|null $customer_ref (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['billAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function billAndHoldRequest($page_size = null, $page_number = null, $page_last = null, $page_prev = null, $page_after = null, $filter = null, $material_id = null, $customer_ref = null, string $contentType = self::contentTypes['billAndHold'][0])
    {










        $resourcePath = '/order/bill-and-hold';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page[size]', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'page[number]', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_last,
            'page[last]', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_prev,
            'page[prev]', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_after,
            'page[after]', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $filter,
            'filter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $material_id,
            'material_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_ref,
            'customer_ref', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOrder
     *
     * Create Order
     *
     * @param  \Exertis\Model\Order|null $order order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrder'] to see the possible values for this operation
     *
     * @throws \Exertis\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Exertis\Model\CreateOrderResponse
     */
    public function createOrder($order = null, string $contentType = self::contentTypes['createOrder'][0])
    {
        list($response) = $this->createOrderWithHttpInfo($order, $contentType);
        return $response;
    }

    /**
     * Operation createOrderWithHttpInfo
     *
     * Create Order
     *
     * @param  \Exertis\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrder'] to see the possible values for this operation
     *
     * @throws \Exertis\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Exertis\Model\CreateOrderResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrderWithHttpInfo($order = null, string $contentType = self::contentTypes['createOrder'][0])
    {
        $request = $this->createOrderRequest($order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Exertis\Model\CreateOrderResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Exertis\Model\CreateOrderResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Exertis\Model\CreateOrderResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createOrderAsync
     *
     * Create Order
     *
     * @param  \Exertis\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrderAsync($order = null, string $contentType = self::contentTypes['createOrder'][0])
    {
        return $this->createOrderAsyncWithHttpInfo($order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrderAsyncWithHttpInfo
     *
     * Create Order
     *
     * @param  \Exertis\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrderAsyncWithHttpInfo($order = null, string $contentType = self::contentTypes['createOrder'][0])
    {
        $returnType = '\Exertis\Model\CreateOrderResponse';
        $request = $this->createOrderRequest($order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrder'
     *
     * @param  \Exertis\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrderRequest($order = null, string $contentType = self::contentTypes['createOrder'][0])
    {



        $resourcePath = '/order';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order));
            } else {
                $httpBody = $order;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderStatus
     *
     * Order Status
     *
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $page_last page_last (optional)
     * @param  string|null $page_prev page_prev (optional)
     * @param  string|null $page_after page_after (optional)
     * @param  int|null $page_number page_number (optional)
     * @param  string|null $filter filter (optional)
     * @param  int|null $status_updated_since status_updated_since (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderStatus'] to see the possible values for this operation
     *
     * @throws \Exertis\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Exertis\Model\OrderStatusResponse
     */
    public function orderStatus($page_size = null, $page_last = null, $page_prev = null, $page_after = null, $page_number = null, $filter = null, $status_updated_since = null, string $contentType = self::contentTypes['orderStatus'][0])
    {
        list($response) = $this->orderStatusWithHttpInfo($page_size, $page_last, $page_prev, $page_after, $page_number, $filter, $status_updated_since, $contentType);
        return $response;
    }

    /**
     * Operation orderStatusWithHttpInfo
     *
     * Order Status
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  int|null $page_number (optional)
     * @param  string|null $filter (optional)
     * @param  int|null $status_updated_since (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderStatus'] to see the possible values for this operation
     *
     * @throws \Exertis\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Exertis\Model\OrderStatusResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderStatusWithHttpInfo($page_size = null, $page_last = null, $page_prev = null, $page_after = null, $page_number = null, $filter = null, $status_updated_since = null, string $contentType = self::contentTypes['orderStatus'][0])
    {
        $request = $this->orderStatusRequest($page_size, $page_last, $page_prev, $page_after, $page_number, $filter, $status_updated_since, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Exertis\Model\OrderStatusResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Exertis\Model\OrderStatusResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Exertis\Model\OrderStatusResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderStatusAsync
     *
     * Order Status
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  int|null $page_number (optional)
     * @param  string|null $filter (optional)
     * @param  int|null $status_updated_since (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderStatusAsync($page_size = null, $page_last = null, $page_prev = null, $page_after = null, $page_number = null, $filter = null, $status_updated_since = null, string $contentType = self::contentTypes['orderStatus'][0])
    {
        return $this->orderStatusAsyncWithHttpInfo($page_size, $page_last, $page_prev, $page_after, $page_number, $filter, $status_updated_since, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderStatusAsyncWithHttpInfo
     *
     * Order Status
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  int|null $page_number (optional)
     * @param  string|null $filter (optional)
     * @param  int|null $status_updated_since (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderStatusAsyncWithHttpInfo($page_size = null, $page_last = null, $page_prev = null, $page_after = null, $page_number = null, $filter = null, $status_updated_since = null, string $contentType = self::contentTypes['orderStatus'][0])
    {
        $returnType = '\Exertis\Model\OrderStatusResponse';
        $request = $this->orderStatusRequest($page_size, $page_last, $page_prev, $page_after, $page_number, $filter, $status_updated_since, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderStatus'
     *
     * @param  int|null $page_size (optional)
     * @param  int|null $page_last (optional)
     * @param  string|null $page_prev (optional)
     * @param  string|null $page_after (optional)
     * @param  int|null $page_number (optional)
     * @param  string|null $filter (optional)
     * @param  int|null $status_updated_since (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderStatusRequest($page_size = null, $page_last = null, $page_prev = null, $page_after = null, $page_number = null, $filter = null, $status_updated_since = null, string $contentType = self::contentTypes['orderStatus'][0])
    {









        $resourcePath = '/order';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page[size]', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_last,
            'page[last]', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_prev,
            'page[prev]', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_after,
            'page[after]', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'page[number]', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $filter,
            'filter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status_updated_since,
            'status_updated_since', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
