# Exertis\ProductApi

All URIs are relative to https://ehub.exertis.io, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getProductCatalogue()**](ProductApi.md#getProductCatalogue) | **GET** /product/catalogue | Get Product Catalogue |


## `getProductCatalogue()`

```php
getProductCatalogue($page_size, $page_after, $page_last, $page_prev, $page_number, $filter, $last_stock_update): \Exertis\Model\ProductCatalogueResponse
```

Get Product Catalogue

Allows customers to view smaller subset of product information suitable for stock and price control

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Exertis\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_size = 56; // int
$page_after = 'page_after_example'; // string
$page_last = 56; // int
$page_prev = 'page_prev_example'; // string
$page_number = 56; // int
$filter = 'filter_example'; // string
$last_stock_update = 56; // int

try {
    $result = $apiInstance->getProductCatalogue($page_size, $page_after, $page_last, $page_prev, $page_number, $filter, $last_stock_update);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProductCatalogue: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_size** | **int**|  | [optional] |
| **page_after** | **string**|  | [optional] |
| **page_last** | **int**|  | [optional] |
| **page_prev** | **string**|  | [optional] |
| **page_number** | **int**|  | [optional] |
| **filter** | **string**|  | [optional] |
| **last_stock_update** | **int**|  | [optional] |

### Return type

[**\Exertis\Model\ProductCatalogueResponse**](../Model/ProductCatalogueResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
