# Exertis\OrderApi

All URIs are relative to https://ehub.exertis.io, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**billAndHold()**](OrderApi.md#billAndHold) | **GET** /order/bill-and-hold | Bill And Hold |
| [**createOrder()**](OrderApi.md#createOrder) | **POST** /order | Create Order |
| [**orderStatus()**](OrderApi.md#orderStatus) | **GET** /order | Order Status |


## `billAndHold()`

```php
billAndHold($page_size, $page_number, $page_last, $page_prev, $page_after, $filter, $material_id, $customer_ref): \Exertis\Model\BillAndHoldResponse
```

Bill And Hold

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Exertis\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_size = 56; // int
$page_number = 56; // int
$page_last = 56; // int
$page_prev = 'page_prev_example'; // string
$page_after = 'page_after_example'; // string
$filter = 'filter_example'; // string
$material_id = 'material_id_example'; // string
$customer_ref = 'customer_ref_example'; // string

try {
    $result = $apiInstance->billAndHold($page_size, $page_number, $page_last, $page_prev, $page_after, $filter, $material_id, $customer_ref);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->billAndHold: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_size** | **int**|  | [optional] |
| **page_number** | **int**|  | [optional] |
| **page_last** | **int**|  | [optional] |
| **page_prev** | **string**|  | [optional] |
| **page_after** | **string**|  | [optional] |
| **filter** | **string**|  | [optional] |
| **material_id** | **string**|  | [optional] |
| **customer_ref** | **string**|  | [optional] |

### Return type

[**\Exertis\Model\BillAndHoldResponse**](../Model/BillAndHoldResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createOrder()`

```php
createOrder($order): \Exertis\Model\CreateOrderResponse
```

Create Order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Exertis\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$order = new \Exertis\Model\Order(); // \Exertis\Model\Order

try {
    $result = $apiInstance->createOrder($order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->createOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order** | [**\Exertis\Model\Order**](../Model/Order.md)|  | [optional] |

### Return type

[**\Exertis\Model\CreateOrderResponse**](../Model/CreateOrderResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderStatus()`

```php
orderStatus($page_size, $page_last, $page_prev, $page_after, $page_number, $filter, $status_updated_since): \Exertis\Model\OrderStatusResponse
```

Order Status

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Exertis\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_size = 56; // int
$page_last = 56; // int
$page_prev = 'page_prev_example'; // string
$page_after = 'page_after_example'; // string
$page_number = 56; // int
$filter = 'filter_example'; // string
$status_updated_since = 56; // int

try {
    $result = $apiInstance->orderStatus($page_size, $page_last, $page_prev, $page_after, $page_number, $filter, $status_updated_since);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderStatus: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_size** | **int**|  | [optional] |
| **page_last** | **int**|  | [optional] |
| **page_prev** | **string**|  | [optional] |
| **page_after** | **string**|  | [optional] |
| **page_number** | **int**|  | [optional] |
| **filter** | **string**|  | [optional] |
| **status_updated_since** | **int**|  | [optional] |

### Return type

[**\Exertis\Model\OrderStatusResponse**](../Model/OrderStatusResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
