# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/exertis.git"
    }
  ],
  "require": {
    "talisman/exertis": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Exertis\Api\AuthenticationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->authenticate();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthenticationApi->authenticate: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://ehub.exertis.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**authenticate**](docs/Api/AuthenticationApi.md#authenticate) | **POST** /token/authenticate | Authenticate
*OrderApi* | [**billAndHold**](docs/Api/OrderApi.md#billandhold) | **GET** /order/bill-and-hold | Bill And Hold
*OrderApi* | [**createOrder**](docs/Api/OrderApi.md#createorder) | **POST** /order | Create Order
*OrderApi* | [**orderStatus**](docs/Api/OrderApi.md#orderstatus) | **GET** /order | Order Status
*ProductApi* | [**getProductCatalogue**](docs/Api/ProductApi.md#getproductcatalogue) | **GET** /product/catalogue | Get Product Catalogue

## Models

- [Address](docs/Model/Address.md)
- [AuthenticateResponse](docs/Model/AuthenticateResponse.md)
- [AuthenticateResponseData](docs/Model/AuthenticateResponseData.md)
- [AuthenticateResponseDataBearer](docs/Model/AuthenticateResponseDataBearer.md)
- [BillAndHold](docs/Model/BillAndHold.md)
- [BillAndHoldResponse](docs/Model/BillAndHoldResponse.md)
- [Courier](docs/Model/Courier.md)
- [CreateOrderResponse](docs/Model/CreateOrderResponse.md)
- [CreateOrderResponseData](docs/Model/CreateOrderResponseData.md)
- [Item](docs/Model/Item.md)
- [Links](docs/Model/Links.md)
- [Meta](docs/Model/Meta.md)
- [MetaPage](docs/Model/MetaPage.md)
- [Order](docs/Model/Order.md)
- [OrderPayment](docs/Model/OrderPayment.md)
- [OrderStatusLine](docs/Model/OrderStatusLine.md)
- [OrderStatusResponse](docs/Model/OrderStatusResponse.md)
- [OrderStatusResponseDataInner](docs/Model/OrderStatusResponseDataInner.md)
- [Payment](docs/Model/Payment.md)
- [Product](docs/Model/Product.md)
- [ProductCatalogueResponse](docs/Model/ProductCatalogueResponse.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1.0`
    - Package version: `1.0`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
