<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;
use SoapFault;
use Eurostop\Status\GetDataProcessingStatusByToken;

/**
 * Eurostop Status 
 * 
 */

class Status extends Base {
    
    protected $endpoint = 'status';

    public function __construct(LoggerInterface $logger, $url, $soapOptions) {
        parent::__construct($logger, $url. $this->endpoint . '?wsdl', $soapOptions);
        $this->client = $this->service();
    }
    
    
 
    public function getDataProcessingStatusByToken($token) {
        $request = new GetDataProcessingStatusByToken($token);
        try {
            $response = $this->client->GetDataProcessingStatusByToken($request);
            $this->LogLastRequest();
            return $response;
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
}