<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;

/**
 * Eurostop Service 
 * 
 */

class Service {
    
    protected $logger;
    protected $wsdl;
    protected $soapOptions;
    /**
     * Construct 
     * @param LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger) {
        $this->logger = $logger;
    }
    
    /**
     * Pass in setup data
     */
    public function setup($wsdl, $token = null,  $proxy=null) {
        $this->wsdl = $wsdl;
        $this->soapOptions = [];
        $this->soapOptions['soap_version'] = SOAP_1_2;
        $this->soapOptions['trace'] = 1;
        $this->soapOptions['cache_wsdl'] = WSDL_CACHE_NONE;
        if($proxy) {
            $prox = explode(':',$proxy);
            $this->soapOptions['proxy_host'] = $prox[0];
            $this->soapOptions['proxy_port'] = $prox[1];
        }
        if($token) {
            $this->soapOptions['stream_context'] = stream_context_create(['http'=>['header'=>'AuthToken: '.$token]]);
        }
    }

    public function organisation() {
        return new Organisation($this->logger, $this->wsdl, $this->soapOptions);
    }

    public function products() {
        return new Products($this->logger, $this->wsdl, $this->soapOptions);
    }
    
    public function sales() {
        return new Sales($this->logger, $this->wsdl, $this->soapOptions);
    }
    
    public function fulfilment() {
        return new Fulfilment($this->logger, $this->wsdl, $this->soapOptions);
    }
    
    public function loyalty() {
        return new Loyalty($this->logger, $this->wsdl, $this->soapOptions);
    }
    
    public function stocks() {
        return new Stocks($this->logger, $this->wsdl, $this->soapOptions);
    }
    
    public function status() {
        return new Status($this->logger, $this->wsdl, $this->soapOptions);
    }  
    
    public function security() {
        return new Security($this->logger, $this->wsdl, $this->soapOptions);
    }  

}