<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;
use SoapFault;
use Eurostop\Security\Login;
use Eurostop\Security\RenewAuthToken;

/**
 * Eurostop Oranisation 
 * 
 */

class Security extends Base {
    
    protected $endpoint = 'security';

    public function __construct(LoggerInterface $logger, $url, $soapOptions) {
        parent::__construct($logger, $url. $this->endpoint . '?wsdl', $soapOptions);
        $this->client = $this->service();
    }
    
    ######################### SECURITY #########################


    public function login($username, $password) {
        
        $request = new Login();
        $request->setUsername($username);
        $request->setPassword($password);
        
        try {
            $response = $this->client->Login($request);
            if($response->getLoginResult()->getIsAllowed()===false) {
                $this->logger->critical('SOAP Last Request: '.$this->client->__getLastRequest());
                $this->logger->critical('SOAP Last Request Headers: '.$this->client->__getLastRequestHeaders());
                $this->logger->critical('SOAP Last Response: '.$this->client->__getLastResponse());
                $this->logger->critical('SOAP Last Response Headers: '.$this->client->__getLastResponseHeaders());
                throw new \Exception('Unable to login');
            }
            return $response;
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    
    public function renewToken($username, $password, $token) {
       
        $request = new RenewAuthToken();
        $request->setUsername($username);
        $request->setPassword($password);
        $request->setAuthToken($token);
                
        try {
            $response = $this->client->RenewAuthToken($request);
            $this->LogLastRequest();
            return $response;
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    
}