<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;
use SoapFault;
use Eurostop\Sales\SubmitReceipt;
use Eurostop\Sales\SubmittedReceiptHeader;
use Eurostop\Sales\ArrayOfSubmittedReceiptLineSku;
use Eurostop\Sales\SubmittedReceiptLineSku;
use Eurostop\Sales\ReceiptStatus;
use Eurostop\Sales\ReceiptLineType;
use Eurostop\Sales\SubmittedReceiptTender;
use Eurostop\Sales\DateTimeOffset;
use Eurostop\Sales\GetReceiptByReceiptIdentifier;
use Eurostop\Sales\SubmittedReceiptPriceModifier ;
use Eurostop\Sales\PriceModifierType;

/**
 * Eurostop Sales 
 * 
 */

class Sales extends Base {
    
    protected $endpoint = 'sales';

    public function __construct(LoggerInterface $logger, $url, $soapOptions) {
        parent::__construct($logger, $url. $this->endpoint . '?wsdl', $soapOptions);
        $this->client = $this->service();
    }
    
    ######################### SALES #########################

    /**
     * Submit receipt
     * @param SubmittedReceiptHeader $receipt
     * @param string $submissionReference
     * A reference code (created by the client) for this batch of submitted data. 
     * The status of the import can later be looked up by quoting this reference. 
     * Note that the same submission reference code can be assigned to more than one batch of data.
     * @return type
     */
    public function submitReceipt(SubmittedReceiptHeader $receipt, $submissionReference) {
        $request = new SubmitReceipt($receipt, $submissionReference);
        try {
            $response = $this->client->SubmitReceipt($request);
            $this->LogLastRequest();
            return $response;
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    /**
     * Receipt Object
     * @return SubmittedReceiptHeader
     */
    public function receipt() {
        return new SubmittedReceiptHeader();
    }
    
    
    public function receiptLine() {
        return new SubmittedReceiptLineSku();
    }
    
    public function receiptLineArray(array $receiptLines) {
        $setReceiptLines = new ArrayOfSubmittedReceiptLineSku();
        $setReceiptLines->setSubmittedReceiptLineSku($receiptLines);
        return $setReceiptLines;
    }
    
    public static function status() {
        return new ReceiptStatus();
    }
    
    public static function receiptType() {
        return new ReceiptLineType();
    }
    
    
    public function submittedReceiptTender() {
        return new SubmittedReceiptTender();
    }
    
    public function dateTimeOffset(\DateTime $dt, $offset) {
        return new DateTimeOffset($dt, $offset);
    }
    
    public static function priceModifierTypes() {
        return new PriceModifierType();
    }
    
    public function getReceiptByReceiptIdentifier($identifier, $identifierType) {
        $request = new GetReceiptByReceiptIdentifier($identifier, $identifierType);
        try {
            $response = $this->client->GetCustomerOrderByIdentifier($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    public function submittedReceiptPriceModifier() {
        return new SubmittedReceiptPriceModifier();
    }
    
}