<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;
use SoapFault;
use Eurostop\Organisation\GetCountries;
use Eurostop\Organisation\BranchType;
use Eurostop\Organisation\GetAllVatRates;
use Eurostop\Organisation\GetCurrencies;
use Eurostop\Organisation\GetCurrentCurrencyConversionRates;
use Eurostop\Organisation\GetBranches;
use Eurostop\Organisation\GetSaleReasons;
use Eurostop\Organisation\GetRefundReasons;
use Eurostop\Organisation\GetTenderTypes;
use Eurostop\Organisation\GetPriceModifierReasons;

/**
 * Eurostop Oranisation 
 * 
 */

class Organisation extends Base {
    
    protected $endpoint = 'organisation';

    public function __construct(LoggerInterface $logger, $url, $soapOptions) {
        parent::__construct($logger, $url. $this->endpoint . '?wsdl', $soapOptions);
        $this->client = $this->service();
    }
    
    ######################### ORGANISATION #########################

    /**
     * Get Countries
     * @return object
     */
    public function getCountries() {
        $request = new GetCountries();
        try {
            $response = $this->client->GetCountries($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    /**
     * List of branch types as constants
     *  const __default = 'RetailStore';
        const RetailStore = 'RetailStore';
        const Franchise = 'Franchise';
        const Warehouse = 'Warehouse';
     * @return type
     */
    public function getBranchType() {
        $request = new BranchType();
        try {
            $response = $this->client->BranchType($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }

    /**
     * 
     * @param string $BranchType
     * @param int $TillCount
     * @return type
     */
    public function getBranch($BranchType, $TillCount) {
        $request = new GetBranch($BranchType, $TillCount);
        try {
            $response = $this->client->GetBranch($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    
    public function getBranches() {
        $request = new GetBranches();
        try {
            $response = $this->client->GetBranches($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    public function getAllVatRates() {
        
        $request = new GetAllVatRates();
        try {
            $response = $this->client->GetAllVatRates($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    public function getCurrencies() {
        
        $request = new GetCurrencies();
        try {
            $response = $this->client->GetCurrencies($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    public function getCurrentCurrencyConversionRates() {
        
        $request = new GetCurrentCurrencyConversionRates();
        try {
            $response = $this->client->GetCurrentCurrencyConversionRates($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    
    public function getSaleReasons() {
        
        $request = new GetSaleReasons();
        try {
            $response = $this->client->GetSaleReasons($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    public function getRefundReasons() {
        
        $request = new GetRefundReasons();
        try {
            $response = $this->client->GetRefundReasons($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    
    public function getTenderTypes() {
        
        $request = new GetTenderTypes();
        try {
            $response = $this->client->GetTenderTypes($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
    public function getPriceModifierReasons() {
        
        $request = new GetPriceModifierReasons();
        try {
            $response = $this->client->GetPriceModifierReasons($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
        
    }
    
        
}