<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;
use SoapFault;
use Eurostop\Stocks\GetCurrentSkuStockByBranchGroup;
use Eurostop\Stocks\GetCurrentSkuStockByBranch;
use Talisman\EurostopBundle\Eurostop\Base;
use DateTime;

/**
 * Eurostop Stocks 
 * 
 */

class Stocks extends Base {
    
    protected $endpoint = 'stock';

    public function __construct(LoggerInterface $logger, $url, $soapOptions) {
        parent::__construct($logger, $url. $this->endpoint .'s'. '?wsdl', $soapOptions);
        $this->client = $this->service();
    }
    
    ######################### STOCK #########################

    /**
     * Get current stock by branch group
     * @param string $branchGroupIdentifier
     * @param string $branchGroupIdentifierType (RmisCode)
     * @param DateTime $modifiedSinceDate
     * @param bool $nonZeroOnly
     * @return type
     */
    public function getCurrentSkuStockByBranchGroup($branchGroupIdentifier, $branchGroupIdentifierType, DateTime $modifiedSinceDate = null, $nonZeroOnly=null) {
        $request = new GetCurrentSkuStockByBranchGroup($branchGroupIdentifier, $branchGroupIdentifierType, $modifiedSinceDate, $nonZeroOnly);
        try {
            $response = $this->client->GetCurrentSkuStockByBranchGroup($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    public function getCurrentSkuStockByBranch($branchIdentifier, $branchIdentifierType, DateTime $modifiedSinceDate = null, $nonZeroOnly=null) {
        $request = new GetCurrentSkuStockByBranch($branchIdentifier, $branchIdentifierType, $modifiedSinceDate, $nonZeroOnly);
        try {
            $response = $this->client->GetCurrentSkuStockByBranch($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    
}