<?php

/* 
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use Psr\Log\LoggerInterface;
use SoapFault;
use Eurostop\Loyalty\SubmitCustomer;
use Eurostop\Loyalty\SubmittedCustomer;
use Eurostop\Loyalty\GetCustomerByIdentifier;
use Talisman\EurostopBundle\Eurostop\Base;
use Eurostop\Loyalty\ArrayOfSubmittedCustomerAttribute;
use Eurostop\Loyalty\SubmittedCustomerAttribute;
use Eurostop\Loyalty\ArrayOfSubmittedCustomerAddress;
use Eurostop\Loyalty\SubmittedCustomerAddress;
use Eurostop\Loyalty\GetCustomersByDate;
use Eurostop\Loyalty\GetCustomersByAttribute;
use DateTime;

/**
 * Eurostop Loyalty
 * 
 */

class Loyalty extends Base {
    
    protected $endpoint = 'loyalty';

    public function __construct(LoggerInterface $logger, $url, $soapOptions) {
        parent::__construct($logger, $url. $this->endpoint . '?wsdl', $soapOptions);
        $this->client = $this->service();
    }
    
    ######################### LOYALTY #########################
    
    /**
     * Submit Customer to Loyalty
     * @param SubmittedCustomer $customer
     * @param string $submissionReference
     * A reference code (created by the client) for this batch of submitted data. 
     * The status of the import can later be looked up by quoting this reference. 
     * Note that the same submission reference code can be assigned to more than one batch of data.
     * @return string
     */
    public function submitCustomer(SubmittedCustomer $customer, $submissionReference) {
        $request = new SubmitCustomer($customer, $submissionReference);
        try {
            $response = $this->client->SubmitCustomer($request);
            $this->LogLastRequest();
            return $response;
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
       
    /**
     * Customer object
     * @return SubmittedCustomer
     */
    public function customer() {
        return new SubmittedCustomer();
    }
   
    public function getCustomersByDate(DateTime $createdSinceDate=null, DateTime $modifiedSinceDate=null) {
        $request = new GetCustomersByDate($createdSinceDate, $modifiedSinceDate);
        try {
            $response = $this->client->GetCustomersByDate($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    public function getCustomersByAttribute($attributeIdentifier, $attributeIdentifierType, $attributeValue) {
        $request = new GetCustomersByAttribute($attributeIdentifier, $attributeIdentifierType, $attributeValue );
        try {
            $response = $this->client->GetCustomersByAttribute($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    public function getCustomerByIdentifier($customerIdentifier, $customerIdentifierType) {
        $request = new GetCustomerByIdentifier($customerIdentifier, $customerIdentifierType);
        try {
            $response = $this->client->GetCustomerByIdentifier($request);
            $this->LogLastRequest();
            return $this->response($response);
        } catch (SoapFault $fault) {
            $this->LogFaults($fault);
        }
        return;
    }
    
    
    public function customerAttribute() {
        return new SubmittedCustomerAttribute();
    }
    
    public function customerAttributeArray(array $customerAttribute) {
        $setCustomerAttribute = new ArrayOfSubmittedCustomerAttribute();
        $setCustomerAttribute->setSubmittedCustomerAttribute($customerAttribute);
        return $setCustomerAttribute;
    }
    
    public function address() {
        return new SubmittedCustomerAddress();
    }
    
    public function customerAddressArray(array $customerAddress) {
        $setCustomerAddress = new ArrayOfSubmittedCustomerAddress();
        $setCustomerAddress->setSubmittedCustomerAddress($customerAddress);
        return $setCustomerAddress;
    }
    
}