<?php

/*
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\EurostopBundle\Eurostop;

use ConnectorSupport\Curl\Logger;
use Psr\Log\LoggerInterface;
use SoapFault;
use Exception;

/**
 * Eurostop Base Class
 *
 */
class Base {

    protected $logger;
    protected $wsdl;
    protected $soapOptions;
    protected $endpoint;

    /**
     * Construct
     * @param LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger, $wsdl, $soapOptions) {
        $this->logger = $logger;
        $this->wsdl = $wsdl;
        $this->soapOptions = $soapOptions;
    }


    /**
     * Get service class
     */
    protected function service() {
        $dir = $this->endpoint;
        if($this->endpoint == 'stock') {
            $dir = $this->endpoint.'s';
        }
        $interfaceName = '\\Eurostop\\'.ucfirst($dir).'\\'.ucfirst($this->endpoint).'WebServiceInterfacePlugin';
        return new $interfaceName($this->soapOptions, $this->wsdl);
    }


    /**
     * Break up the response object and return the usuable
     * parts like items.
     * @param object $response
     * @return object or array of objects
     * @throws Exception
     */
    protected function response($response) {

        if (is_null($response)) {
            return $response;
        }
        $classMethods = get_class_methods($response);
        $result = $response->{$classMethods[1]}();

        if($result->getErrorSource()) {
            throw new Exception('Eurostop: '.ucfirst($this->endpoint). ' '.$result->getErrorSource());
        }
        # Single item
        if($result->getDataItem()) {
            return [$result->getDataItem()];
        }
        # Array of results
        if($result->getDataItems()) {
            return $result->getDataItems();
        }

        return;

    }



    protected function LogFaults($fault) {

        $this->LogLastRequest();

        $this->logger->info($fault->getMessage());
    }

    protected function LogLastRequest() {

        $bodySent = $this->client->__getLastRequest();
        $headersSent = $this->client->__getLastRequestHeaders();
        $headers = explode("\r\n", $headersSent);
        $temp = explode(" ", array_shift($headers));
        $method = $temp[0];
        $url = $temp[1];
        $sent = [];
        foreach ($headers as $header) {
            $temp = explode(':', $header, 2);
            if (count($temp) > 1) {
                $sent[trim($temp[0])] = trim($temp[1]);
            }
        }

        if (array_key_exists('Host', $sent)) {
            $url = $sent['Host'] . $url;
        }

        $bodyRecv = $this->client->__getLastResponse();
        $headersRecv = $this->client->__getLastResponseHeaders();
        $headers = explode("\r\n", $headersRecv);
        $temp = explode(" ", array_shift($headers));
        $http_code = $temp[1];
        $recv = [];
        foreach ($headers as $header) {
            $temp = explode(':', $header, 2);
            if (count($temp) > 1) {
                $recv[trim($temp[0])] = trim($temp[1]);
            }
        }

        $logger = new Logger($this->logger);
        $logger->logRequest($method, $url, '', $sent, $bodySent);
        $logger->logResponse($method, $url, $http_code, $headers, $bodyRecv);
    }
}
