<?php

namespace Eurostop\Stocks;

class TransferDetail extends RetrievedDataItemOfTransferDetailDto6qbTdoQx
{

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var int $StockUnits
     */
    protected $StockUnits = null;

    /**
     * @var float $CostPrice
     */
    protected $CostPrice = null;

    /**
     * @param int $StockUnits
     */
    public function __construct($StockUnits)
    {
      parent::__construct();
      $this->StockUnits = $StockUnits;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Stocks\TransferDetail
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\TransferDetail
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getStockUnits()
    {
      return $this->StockUnits;
    }

    /**
     * @param int $StockUnits
     * @return \Eurostop\Stocks\TransferDetail
     */
    public function setStockUnits($StockUnits)
    {
      $this->StockUnits = $StockUnits;
      return $this;
    }

    /**
     * @return float
     */
    public function getCostPrice()
    {
      return $this->CostPrice;
    }

    /**
     * @param float $CostPrice
     * @return \Eurostop\Stocks\TransferDetail
     */
    public function setCostPrice($CostPrice)
    {
      $this->CostPrice = $CostPrice;
      return $this;
    }

}
