<?php

namespace Eurostop\Stocks;

class SubmittedWriteOnOffLine extends SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQx
{

    /**
     * @var \DateTime $AuthorisedDate
     */
    protected $AuthorisedDate = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var int $QuantityVariance
     */
    protected $QuantityVariance = null;

    /**
     * @var string $ReasonIdentifier
     */
    protected $ReasonIdentifier = null;

    /**
     * @var ReasonIdentifierType $ReasonIdentifierType
     */
    protected $ReasonIdentifierType = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @param int $QuantityVariance
     * @param SkuIdentifierType $SkuIdentifierType
     */
    public function __construct($QuantityVariance, $SkuIdentifierType)
    {
      parent::__construct();
      $this->QuantityVariance = $QuantityVariance;
      $this->SkuIdentifierType = $SkuIdentifierType;
    }

    /**
     * @return \DateTime
     */
    public function getAuthorisedDate()
    {
      if ($this->AuthorisedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AuthorisedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AuthorisedDate
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setAuthorisedDate(\DateTime $AuthorisedDate = null)
    {
      if ($AuthorisedDate == null) {
       $this->AuthorisedDate = null;
      } else {
        $this->AuthorisedDate = $AuthorisedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getQuantityVariance()
    {
      return $this->QuantityVariance;
    }

    /**
     * @param int $QuantityVariance
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setQuantityVariance($QuantityVariance)
    {
      $this->QuantityVariance = $QuantityVariance;
      return $this;
    }

    /**
     * @return string
     */
    public function getReasonIdentifier()
    {
      return $this->ReasonIdentifier;
    }

    /**
     * @param string $ReasonIdentifier
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setReasonIdentifier($ReasonIdentifier)
    {
      $this->ReasonIdentifier = $ReasonIdentifier;
      return $this;
    }

    /**
     * @return ReasonIdentifierType
     */
    public function getReasonIdentifierType()
    {
      return $this->ReasonIdentifierType;
    }

    /**
     * @param ReasonIdentifierType $ReasonIdentifierType
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setReasonIdentifierType($ReasonIdentifierType)
    {
      $this->ReasonIdentifierType = $ReasonIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedWriteOnOffLine
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

}
