<?php

namespace Eurostop\Stocks;

class SubmittedTransferItem extends SubmittedDataItemOfSubmittedTransferItemDto6qbTdoQx
{

    /**
     * @var int $Quantity
     */
    protected $Quantity = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @param int $Quantity
     * @param SkuIdentifierType $SkuIdentifierType
     */
    public function __construct($Quantity, $SkuIdentifierType)
    {
      parent::__construct();
      $this->Quantity = $Quantity;
      $this->SkuIdentifierType = $SkuIdentifierType;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param int $Quantity
     * @return \Eurostop\Stocks\SubmittedTransferItem
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferItem
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedTransferItem
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

}
