<?php

namespace Eurostop\Stocks;

class SubmittedTransferHeader extends SubmittedDataItemOfSubmittedTransferHeaderDto6qbTdoQx
{

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var string $FromBranchIdentifier
     */
    protected $FromBranchIdentifier = null;

    /**
     * @var string $FromWarehouseLocationIdentifier
     */
    protected $FromWarehouseLocationIdentifier = null;

    /**
     * @var ArrayOfSubmittedTransferItem $Lines
     */
    protected $Lines = null;

    /**
     * @var TransferMethod $Method
     */
    protected $Method = null;

    /**
     * @var string $ReasonIdentifier
     */
    protected $ReasonIdentifier = null;

    /**
     * @var TransferReasonTypeIdentifierType $ReasonIdentifierType
     */
    protected $ReasonIdentifierType = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var TransferStatus $Status
     */
    protected $Status = null;

    /**
     * @var string $ToBranchIdentifier
     */
    protected $ToBranchIdentifier = null;

    /**
     * @var string $ToWarehouseLocationIdentifier
     */
    protected $ToWarehouseLocationIdentifier = null;

    /**
     * @var WarehouseLocationIdentifierType $WarehouseLocationIdentifierType
     */
    protected $WarehouseLocationIdentifierType = null;

    /**
     * @param TransferMethod $Method
     * @param TransferStatus $Status
     */
    public function __construct($Method, $Status)
    {
      parent::__construct();
      $this->Method = $Method;
      $this->Status = $Status;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->FromBranchIdentifier;
    }

    /**
     * @param string $FromBranchIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setFromBranchIdentifier($FromBranchIdentifier)
    {
      $this->FromBranchIdentifier = $FromBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromWarehouseLocationIdentifier()
    {
      return $this->FromWarehouseLocationIdentifier;
    }

    /**
     * @param string $FromWarehouseLocationIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setFromWarehouseLocationIdentifier($FromWarehouseLocationIdentifier)
    {
      $this->FromWarehouseLocationIdentifier = $FromWarehouseLocationIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedTransferItem
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfSubmittedTransferItem $Lines
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return TransferMethod
     */
    public function getMethod()
    {
      return $this->Method;
    }

    /**
     * @param TransferMethod $Method
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setMethod($Method)
    {
      $this->Method = $Method;
      return $this;
    }

    /**
     * @return string
     */
    public function getReasonIdentifier()
    {
      return $this->ReasonIdentifier;
    }

    /**
     * @param string $ReasonIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setReasonIdentifier($ReasonIdentifier)
    {
      $this->ReasonIdentifier = $ReasonIdentifier;
      return $this;
    }

    /**
     * @return TransferReasonTypeIdentifierType
     */
    public function getReasonIdentifierType()
    {
      return $this->ReasonIdentifierType;
    }

    /**
     * @param TransferReasonTypeIdentifierType $ReasonIdentifierType
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setReasonIdentifierType($ReasonIdentifierType)
    {
      $this->ReasonIdentifierType = $ReasonIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return TransferStatus
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param TransferStatus $Status
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->ToBranchIdentifier;
    }

    /**
     * @param string $ToBranchIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setToBranchIdentifier($ToBranchIdentifier)
    {
      $this->ToBranchIdentifier = $ToBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToWarehouseLocationIdentifier()
    {
      return $this->ToWarehouseLocationIdentifier;
    }

    /**
     * @param string $ToWarehouseLocationIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setToWarehouseLocationIdentifier($ToWarehouseLocationIdentifier)
    {
      $this->ToWarehouseLocationIdentifier = $ToWarehouseLocationIdentifier;
      return $this;
    }

    /**
     * @return WarehouseLocationIdentifierType
     */
    public function getWarehouseLocationIdentifierType()
    {
      return $this->WarehouseLocationIdentifierType;
    }

    /**
     * @param WarehouseLocationIdentifierType $WarehouseLocationIdentifierType
     * @return \Eurostop\Stocks\SubmittedTransferHeader
     */
    public function setWarehouseLocationIdentifierType($WarehouseLocationIdentifierType)
    {
      $this->WarehouseLocationIdentifierType = $WarehouseLocationIdentifierType;
      return $this;
    }

}
