<?php

namespace Eurostop\Stocks;

class SubmittedDeliveryLine extends SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQx
{

    /**
     * @var \DateTime $AuthorisedDate
     */
    protected $AuthorisedDate = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var float $CostPrice
     */
    protected $CostPrice = null;

    /**
     * @var boolean $IsReturnToSupplier
     */
    protected $IsReturnToSupplier = null;

    /**
     * @var string $PurchaseOrderIdentifier
     */
    protected $PurchaseOrderIdentifier = null;

    /**
     * @var PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     */
    protected $PurchaseOrderIdentifierType = null;

    /**
     * @var int $Quantity
     */
    protected $Quantity = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var string $SupplierIdentifier
     */
    protected $SupplierIdentifier = null;

    /**
     * @var SupplierIdentifierType $SupplierIdentifierType
     */
    protected $SupplierIdentifierType = null;

    /**
     * @var string $TransferToBranchIdentifier
     */
    protected $TransferToBranchIdentifier = null;

    /**
     * @var string $WarehouseIdentifier
     */
    protected $WarehouseIdentifier = null;

    /**
     * @param float $CostPrice
     * @param boolean $IsReturnToSupplier
     * @param int $Quantity
     * @param SkuIdentifierType $SkuIdentifierType
     */
    public function __construct($CostPrice, $IsReturnToSupplier, $Quantity, $SkuIdentifierType)
    {
      parent::__construct();
      $this->CostPrice = $CostPrice;
      $this->IsReturnToSupplier = $IsReturnToSupplier;
      $this->Quantity = $Quantity;
      $this->SkuIdentifierType = $SkuIdentifierType;
    }

    /**
     * @return \DateTime
     */
    public function getAuthorisedDate()
    {
      if ($this->AuthorisedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AuthorisedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AuthorisedDate
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setAuthorisedDate(\DateTime $AuthorisedDate = null)
    {
      if ($AuthorisedDate == null) {
       $this->AuthorisedDate = null;
      } else {
        $this->AuthorisedDate = $AuthorisedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getCostPrice()
    {
      return $this->CostPrice;
    }

    /**
     * @param float $CostPrice
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setCostPrice($CostPrice)
    {
      $this->CostPrice = $CostPrice;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsReturnToSupplier()
    {
      return $this->IsReturnToSupplier;
    }

    /**
     * @param boolean $IsReturnToSupplier
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setIsReturnToSupplier($IsReturnToSupplier)
    {
      $this->IsReturnToSupplier = $IsReturnToSupplier;
      return $this;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->PurchaseOrderIdentifier;
    }

    /**
     * @param string $PurchaseOrderIdentifier
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setPurchaseOrderIdentifier($PurchaseOrderIdentifier)
    {
      $this->PurchaseOrderIdentifier = $PurchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->PurchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setPurchaseOrderIdentifierType($PurchaseOrderIdentifierType)
    {
      $this->PurchaseOrderIdentifierType = $PurchaseOrderIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param int $Quantity
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->SupplierIdentifier;
    }

    /**
     * @param string $SupplierIdentifier
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setSupplierIdentifier($SupplierIdentifier)
    {
      $this->SupplierIdentifier = $SupplierIdentifier;
      return $this;
    }

    /**
     * @return SupplierIdentifierType
     */
    public function getSupplierIdentifierType()
    {
      return $this->SupplierIdentifierType;
    }

    /**
     * @param SupplierIdentifierType $SupplierIdentifierType
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setSupplierIdentifierType($SupplierIdentifierType)
    {
      $this->SupplierIdentifierType = $SupplierIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getTransferToBranchIdentifier()
    {
      return $this->TransferToBranchIdentifier;
    }

    /**
     * @param string $TransferToBranchIdentifier
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setTransferToBranchIdentifier($TransferToBranchIdentifier)
    {
      $this->TransferToBranchIdentifier = $TransferToBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->WarehouseIdentifier;
    }

    /**
     * @param string $WarehouseIdentifier
     * @return \Eurostop\Stocks\SubmittedDeliveryLine
     */
    public function setWarehouseIdentifier($WarehouseIdentifier)
    {
      $this->WarehouseIdentifier = $WarehouseIdentifier;
      return $this;
    }

}
