<?php

namespace Eurostop\Stocks;

class SubmittedAllocationItem extends SubmittedDataItemOfSubmittedAllocationItemDto6qbTdoQx
{

    /**
     * @var int $AllocationUnits
     */
    protected $AllocationUnits = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @param int $AllocationUnits
     * @param SkuIdentifierType $SkuIdentifierType
     */
    public function __construct($AllocationUnits, $SkuIdentifierType)
    {
      parent::__construct();
      $this->AllocationUnits = $AllocationUnits;
      $this->SkuIdentifierType = $SkuIdentifierType;
    }

    /**
     * @return int
     */
    public function getAllocationUnits()
    {
      return $this->AllocationUnits;
    }

    /**
     * @param int $AllocationUnits
     * @return \Eurostop\Stocks\SubmittedAllocationItem
     */
    public function setAllocationUnits($AllocationUnits)
    {
      $this->AllocationUnits = $AllocationUnits;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\SubmittedAllocationItem
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedAllocationItem
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedAllocationItem
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedAllocationItem
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

}
