<?php

namespace Eurostop\Stocks;

class SubmitSkuReplenishmentCeilings
{

    /**
     * @var ArrayOfSubmittedSkuReplenishmentCeiling $ceilings
     */
    protected $ceilings = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSkuReplenishmentCeiling $ceilings
     * @param string $submissionReference
     */
    public function __construct($ceilings, $submissionReference)
    {
      $this->ceilings = $ceilings;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSkuReplenishmentCeiling
     */
    public function getCeilings()
    {
      return $this->ceilings;
    }

    /**
     * @param ArrayOfSubmittedSkuReplenishmentCeiling $ceilings
     * @return \Eurostop\Stocks\SubmitSkuReplenishmentCeilings
     */
    public function setCeilings($ceilings)
    {
      $this->ceilings = $ceilings;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitSkuReplenishmentCeilings
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
