<?php

namespace Eurostop\Stocks;

class SubmitPurchaseOrderAction
{

    /**
     * @var SubmittedPurchaseOrderAction $purchaseOrderAction
     */
    protected $purchaseOrderAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedPurchaseOrderAction $purchaseOrderAction
     * @param string $submissionReference
     */
    public function __construct($purchaseOrderAction, $submissionReference)
    {
      $this->purchaseOrderAction = $purchaseOrderAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedPurchaseOrderAction
     */
    public function getPurchaseOrderAction()
    {
      return $this->purchaseOrderAction;
    }

    /**
     * @param SubmittedPurchaseOrderAction $purchaseOrderAction
     * @return \Eurostop\Stocks\SubmitPurchaseOrderAction
     */
    public function setPurchaseOrderAction($purchaseOrderAction)
    {
      $this->purchaseOrderAction = $purchaseOrderAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitPurchaseOrderAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
