<?php

namespace Eurostop\Stocks;

class SubmitAllocations
{

    /**
     * @var ArrayOfSubmittedAllocationHeader $allocations
     */
    protected $allocations = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedAllocationHeader $allocations
     * @param string $submissionReference
     */
    public function __construct($allocations, $submissionReference)
    {
      $this->allocations = $allocations;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedAllocationHeader
     */
    public function getAllocations()
    {
      return $this->allocations;
    }

    /**
     * @param ArrayOfSubmittedAllocationHeader $allocations
     * @return \Eurostop\Stocks\SubmitAllocations
     */
    public function setAllocations($allocations)
    {
      $this->allocations = $allocations;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitAllocations
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
